/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.histogram;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.views.histogram.HistogramBucket;
import org.eclipse.tracecompass.tmf.ui.views.histogram.HistogramScaledData;
import org.eclipse.tracecompass.tmf.ui.views.histogram.IHistogramDataModel;
import org.eclipse.tracecompass.tmf.ui.views.histogram.IHistogramModelListener;

public class HistogramDataModel
implements IHistogramDataModel {
    public static final int DEFAULT_NUMBER_OF_BUCKETS = 16000;
    public static final int REFRESH_FREQUENCY = 16000;
    private ITmfTrace fTrace = null;
    private final Map<ITmfTrace, Integer> fTraceMap = new LinkedHashMap<ITmfTrace, Integer>();
    private final int fNbBuckets;
    private final HistogramBucket[] fBuckets;
    private final long[] fLostEventsBuckets;
    private long fBucketDuration;
    private long fNbEvents;
    private int fLastBucket;
    private long fFirstBucketTime;
    private long fFirstEventTime;
    private long fEndTime;
    private long fSelectionBegin;
    private long fSelectionEnd;
    private long fTimeLimit;
    private final ListenerList fModelListeners;

    public HistogramDataModel() {
        this(0L, 16000);
    }

    public HistogramDataModel(long startTime) {
        this(startTime, 16000);
    }

    public HistogramDataModel(int nbBuckets) {
        this(0L, nbBuckets);
    }

    public HistogramDataModel(long startTime, int nbBuckets) {
        this.fFirstEventTime = this.fEndTime = startTime;
        this.fFirstBucketTime = this.fEndTime;
        this.fNbBuckets = nbBuckets;
        this.fBuckets = new HistogramBucket[nbBuckets];
        this.fLostEventsBuckets = new long[nbBuckets];
        this.fModelListeners = new ListenerList();
        this.clear();
    }

    public HistogramDataModel(HistogramDataModel other) {
        Object[] listeners;
        this.fNbBuckets = other.fNbBuckets;
        this.fBuckets = new HistogramBucket[this.fNbBuckets];
        int i = 0;
        while (i < this.fNbBuckets) {
            this.fBuckets[i] = new HistogramBucket(other.fBuckets[i]);
            ++i;
        }
        this.fLostEventsBuckets = Arrays.copyOf(other.fLostEventsBuckets, this.fNbBuckets);
        this.fBucketDuration = Math.max(other.fBucketDuration, 1L);
        this.fNbEvents = other.fNbEvents;
        this.fLastBucket = other.fLastBucket;
        this.fFirstBucketTime = other.fFirstBucketTime;
        this.fFirstEventTime = other.fFirstEventTime;
        this.fEndTime = other.fEndTime;
        this.fSelectionBegin = other.fSelectionBegin;
        this.fSelectionEnd = other.fSelectionEnd;
        this.fTimeLimit = other.fTimeLimit;
        this.fModelListeners = new ListenerList();
        Object[] objectArray = listeners = other.fModelListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            this.fModelListeners.add(listener);
            ++n2;
        }
    }

    public void dispose() {
        this.fTraceMap.clear();
        this.fTrace = null;
    }

    public long getNbEvents() {
        return this.fNbEvents;
    }

    public int getNbBuckets() {
        return this.fNbBuckets;
    }

    public long getBucketDuration() {
        return this.fBucketDuration;
    }

    public long getFirstBucketTime() {
        return this.fFirstBucketTime;
    }

    public long getStartTime() {
        return this.fFirstEventTime;
    }

    public void setTrace(ITmfTrace trace) {
        this.fTrace = trace;
        this.fTraceMap.clear();
        int i = 0;
        for (ITmfTrace tr : TmfTraceManager.getTraceSet((ITmfTrace)this.fTrace)) {
            this.fTraceMap.put(tr, i);
            ++i;
        }
    }

    public ITmfTrace getTrace() {
        return this.fTrace;
    }

    public String[] getTraceNames() {
        FluentIterable traces = FluentIterable.from((Iterable)TmfTraceManager.getTraceSet((ITmfTrace)this.fTrace));
        FluentIterable traceNames = traces.transform((Function)new Function<ITmfTrace, String>(){

            public String apply(ITmfTrace input) {
                return input.getName();
            }
        });
        return (String[])traceNames.toArray(String.class);
    }

    public int getNbTraces() {
        Collection traces = TmfTraceManager.getTraceSet((ITmfTrace)this.fTrace);
        if (traces.isEmpty()) {
            return 1;
        }
        return traces.size();
    }

    public void setTimeRange(long startTime, long endTime) {
        this.fFirstEventTime = this.fEndTime = startTime;
        this.fFirstBucketTime = this.fEndTime;
        this.fBucketDuration = 1L;
        this.updateEndTime();
        while (endTime >= this.fTimeLimit) {
            this.mergeBuckets();
        }
    }

    public void setEndTime(long endTime) {
        this.fEndTime = endTime;
        this.fLastBucket = (int)((endTime - this.fFirstBucketTime) / this.fBucketDuration);
    }

    public long getEndTime() {
        return this.fEndTime;
    }

    public long getSelectionBegin() {
        return this.fSelectionBegin;
    }

    public long getSelectionEnd() {
        return this.fSelectionEnd;
    }

    public long getTimeLimit() {
        return this.fTimeLimit;
    }

    public void addHistogramListener(IHistogramModelListener listener) {
        this.fModelListeners.add((Object)listener);
    }

    public void removeHistogramListener(IHistogramModelListener listener) {
        this.fModelListeners.remove((Object)listener);
    }

    private void fireModelUpdateNotification() {
        this.fireModelUpdateNotification(0L);
    }

    private void fireModelUpdateNotification(long count) {
        if (count % 16000L == 0L) {
            Object[] listeners;
            Object[] objectArray = listeners = this.fModelListeners.getListeners();
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener2 = objectArray[n2];
                IHistogramModelListener listener = (IHistogramModelListener)listener2;
                listener.modelUpdated();
                ++n2;
            }
        }
    }

    @Override
    public void complete() {
        this.fireModelUpdateNotification();
    }

    @Override
    public synchronized void clear() {
        Arrays.fill(this.fBuckets, null);
        Arrays.fill(this.fLostEventsBuckets, 0L);
        this.fNbEvents = 0L;
        this.fFirstBucketTime = 0L;
        this.fEndTime = 0L;
        this.fSelectionBegin = 0L;
        this.fSelectionEnd = 0L;
        this.fLastBucket = -1;
        this.fBucketDuration = 1L;
        this.updateEndTime();
        this.fireModelUpdateNotification();
    }

    public void setSelection(long beginTime, long endTime) {
        this.fSelectionBegin = beginTime;
        this.fSelectionEnd = endTime;
    }

    public void setSelectionNotifyListeners(long beginTime, long endTime) {
        this.fSelectionBegin = beginTime;
        this.fSelectionEnd = endTime;
        this.fireModelUpdateNotification();
    }

    @Override
    public synchronized void countEvent(long eventCount, long timestamp, ITmfTrace trace) {
        Integer traceIndex;
        if (timestamp < 0L) {
            return;
        }
        if (this.fFirstBucketTime == 0L && this.fLastBucket == -1 && this.fBuckets[0] == null && timestamp > 0L) {
            this.fFirstBucketTime = timestamp;
            this.fFirstEventTime = timestamp;
            this.updateEndTime();
        }
        if (timestamp < this.fFirstEventTime) {
            this.fFirstEventTime = timestamp;
        }
        if (this.fEndTime < timestamp) {
            this.fEndTime = timestamp;
        }
        if (timestamp >= this.fFirstBucketTime) {
            while (timestamp >= this.fTimeLimit) {
                this.mergeBuckets();
            }
        } else {
            long preMergeOffset = this.getOffset(timestamp);
            while ((long)this.fLastBucket + preMergeOffset >= (long)this.fNbBuckets) {
                this.mergeBuckets();
                preMergeOffset = this.getOffset(timestamp);
            }
            int offset = (int)preMergeOffset;
            this.moveBuckets(offset);
            this.fLastBucket += offset;
            this.fFirstBucketTime -= (long)offset * this.fBucketDuration;
            this.updateEndTime();
        }
        int index = (int)((timestamp - this.fFirstBucketTime) / this.fBucketDuration);
        if (this.fBuckets[index] == null) {
            this.fBuckets[index] = new HistogramBucket(this.getNbTraces());
        }
        if ((traceIndex = this.fTraceMap.get(trace)) == null) {
            traceIndex = 0;
        }
        this.fBuckets[index].addEvent(traceIndex);
        ++this.fNbEvents;
        if (this.fLastBucket < index) {
            this.fLastBucket = index;
        }
        this.fireModelUpdateNotification(eventCount);
    }

    public void countLostEvent(TmfTimeRange timeRange, long nbLostEvents, boolean fullRange) {
        long startTime = timeRange.getStartTime().getValue();
        long endTime = timeRange.getEndTime().getValue();
        if (startTime < 0L || endTime < 0L) {
            return;
        }
        if (this.fFirstBucketTime == 0L && this.fLastBucket == -1 && this.fBuckets[0] == null) {
            this.fFirstBucketTime = startTime;
            this.fFirstEventTime = startTime;
            this.updateEndTime();
        }
        if (fullRange) {
            this.fEndTime = Math.max(this.fEndTime, endTime);
            while (endTime >= this.fTimeLimit) {
                this.mergeBuckets();
            }
        }
        int indexStart = (int)((startTime - this.fFirstBucketTime) / this.fBucketDuration);
        int indexEnd = (int)((endTime - this.fFirstBucketTime) / this.fBucketDuration);
        int nbBucketRange = indexEnd - indexStart + 1;
        double lostEventsPerBucket = (double)nbLostEvents / (double)nbBucketRange;
        double remainder = 0.0;
        indexEnd = Math.min(indexEnd, this.fLostEventsBuckets.length - 1);
        int index = indexStart;
        while (index <= indexEnd) {
            long lostEvents = Math.round(remainder += lostEventsPerBucket);
            int n = index++;
            this.fLostEventsBuckets[n] = this.fLostEventsBuckets[n] + lostEvents;
            remainder -= (double)lostEvents;
        }
        ++this.fNbEvents;
        if (fullRange) {
            this.fLastBucket = Math.max(this.fLastBucket, indexEnd);
        }
        this.fireModelUpdateNotification(nbLostEvents);
    }

    @Override
    public HistogramScaledData scaleTo(int width, int height, int barWidth) {
        if (width <= 0 || height <= 0 || barWidth <= 0) {
            throw new AssertionError((Object)("Invalid histogram dimensions (" + width + "x" + height + ", barWidth=" + barWidth + ")"));
        }
        if (this.fBucketDuration == 0L) {
            throw new IllegalStateException("Bucket width is 0, that should be impossible");
        }
        HistogramScaledData result = new HistogramScaledData(width, height, barWidth);
        result.fMaxValue = 0L;
        int nbBars = width / barWidth;
        double bucketsPerBar = (double)this.fLastBucket / (double)nbBars;
        long modelBucketStartTime = this.fFirstBucketTime;
        long modelBucketEndTime = this.fEndTime;
        double bucketDuration = (double)Math.max(modelBucketEndTime - modelBucketStartTime, 1L) / (double)nbBars;
        result.fBucketDuration = this.fLastBucket == 0 ? 0.0 : bucketDuration;
        int scaledCount = 0;
        int scaledCountLostEvent = 0;
        int offset = (int)(0.5 / bucketDuration);
        int i = 0;
        while (i < result.fData.length) {
            result.fData[i] = new HistogramBucket(this.getNbTraces());
            ++i;
        }
        int modelIndex = 0;
        while (modelIndex <= this.fLastBucket) {
            double done = (double)modelIndex / (double)this.fLastBucket;
            double doneNext = (double)(modelIndex + 1) / (double)this.fLastBucket;
            int scaledStart = Math.max((int)(done * (double)nbBars) - offset, 0);
            int scaledEnd = Math.min((int)(doneNext * (double)nbBars) - offset, nbBars - 1);
            int scaledIndex = scaledStart;
            HistogramBucket currentModelBucket = this.fBuckets[modelIndex];
            long lostEvents = this.fLostEventsBuckets[modelIndex];
            if (currentModelBucket != null || lostEvents != 0L) {
                do {
                    if (result.fData[scaledIndex = Math.min(scaledIndex, nbBars - 1)].getNbEvents() == 0) {
                        scaledCount = 0;
                        scaledCountLostEvent = 0;
                    }
                    if (currentModelBucket != null) {
                        result.fData[scaledIndex].add(currentModelBucket);
                        scaledCount += currentModelBucket.getNbEvents();
                        if (!currentModelBucket.isEmpty()) {
                            result.fLastBucket = scaledIndex;
                        }
                    }
                    int n = scaledIndex++;
                    result.fLostEventsData[n] = (int)((long)result.fLostEventsData[n] + lostEvents);
                    scaledCountLostEvent = (int)((long)scaledCountLostEvent + lostEvents);
                    result.fMaxValue = Math.max(result.fMaxValue, (long)scaledCount);
                    result.fMaxCombinedValue = Math.max(result.fMaxCombinedValue, (long)(scaledCount + scaledCountLostEvent));
                } while (scaledIndex < scaledEnd);
            }
            ++modelIndex;
        }
        if (result.fMaxValue > 0L) {
            result.fScalingFactor = (double)height / (double)result.fMaxValue;
        }
        if (result.fMaxCombinedValue > 0L) {
            result.fScalingFactorCombined = (double)height / (double)result.fMaxCombinedValue;
        }
        this.fBucketDuration = Math.max(this.fBucketDuration, 1L);
        result.fSelectionBeginBucket = this.fSelectionBegin == this.fEndTime ? result.fWidth - 1 : (int)Math.round((double)(this.fSelectionBegin - this.fFirstBucketTime) / (double)this.fBucketDuration / bucketsPerBar);
        result.fSelectionEndBucket = this.fSelectionEnd == this.fEndTime ? result.fWidth - 1 : (int)Math.round((double)(this.fSelectionEnd - this.fFirstBucketTime) / (double)this.fBucketDuration / bucketsPerBar);
        result.fFirstBucketTime = this.fFirstBucketTime;
        result.fFirstEventTime = this.fFirstEventTime;
        return result;
    }

    private void updateEndTime() {
        this.fTimeLimit = this.fFirstBucketTime + (long)this.fNbBuckets * this.fBucketDuration;
    }

    private void mergeBuckets() {
        int i = 0;
        while (i < this.fNbBuckets / 2) {
            this.fBuckets[i] = new HistogramBucket(this.fBuckets[2 * i], this.fBuckets[2 * i + 1]);
            this.fLostEventsBuckets[i] = this.fLostEventsBuckets[2 * i] + this.fLostEventsBuckets[2 * i + 1];
            ++i;
        }
        Arrays.fill(this.fBuckets, this.fNbBuckets / 2, this.fNbBuckets, null);
        Arrays.fill(this.fLostEventsBuckets, this.fNbBuckets / 2, this.fNbBuckets, 0L);
        this.fBucketDuration *= 2L;
        this.updateEndTime();
        this.fLastBucket = this.fNbBuckets / 2 - 1;
    }

    private void moveBuckets(int offset) {
        int i = this.fNbBuckets - 1;
        while (i >= offset) {
            this.fBuckets[i] = new HistogramBucket(this.fBuckets[i - offset]);
            this.fLostEventsBuckets[i] = this.fLostEventsBuckets[i - offset];
            --i;
        }
        i = 0;
        while (i < offset) {
            this.fBuckets[i] = null;
            this.fLostEventsBuckets[i] = 0L;
            ++i;
        }
    }

    private long getOffset(long timestamp) {
        long offset = (this.fFirstBucketTime - timestamp) / this.fBucketDuration;
        if ((this.fFirstBucketTime - timestamp) % this.fBucketDuration != 0L) {
            ++offset;
        }
        return offset;
    }
}

