/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor.actions;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.linuxtools.changelog.core.IFormatterChangeLogContrib;
import org.eclipse.linuxtools.internal.rpm.ui.editor.Activator;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfileLog;
import org.eclipse.linuxtools.internal.rpm.ui.editor.UiUtils;
import org.eclipse.linuxtools.rpm.ui.editor.SpecfileEditor;
import org.eclipse.linuxtools.rpm.ui.editor.parser.Specfile;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class SpecfileChangelogFormatter
implements IFormatterChangeLogContrib {
    public final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("EEE MMM d yyyy");
    private static final String EMPTY_STRING = "";
    private IEditorPart changelog;

    public String formatDateLine(String authorName, String authorEmail) {
        Specfile specfile = this.getParsedSpecfile();
        String epoch = specfile.getEpoch() == -1 ? EMPTY_STRING : String.valueOf(specfile.getEpoch()) + ":";
        String version = specfile.getVersion();
        String release = specfile.getRelease();
        release = release.replaceAll("\\%\\{\\?dist\\}", EMPTY_STRING);
        String dateLine = MessageFormat.format("* {0} {1} <{2}> {3}{4}-{5}", this.formatTodaysDate(), authorName, authorEmail, epoch, version, release);
        String format = Activator.getDefault().getPreferenceStore().getString("changelogEntryFormat");
        if (format.equals("2")) {
            dateLine = MessageFormat.format("* {0} {1} <{2}> - {3}{4}-{5}", this.formatTodaysDate(), authorName, authorEmail, epoch, version, release);
        } else if (format.equals("3")) {
            dateLine = MessageFormat.format("* {0} {1} <{2}>", this.formatTodaysDate(), authorName, authorEmail);
        }
        dateLine = UiUtils.resolveDefines(specfile, dateLine);
        return dateLine;
    }

    protected Specfile getParsedSpecfile() {
        if (this.changelog == null) {
            this.changelog = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        }
        if (this.changelog instanceof SpecfileEditor) {
            SpecfileEditor specEditor = (SpecfileEditor)this.changelog;
            return specEditor.getSpecfile();
        }
        return null;
    }

    private String formatTodaysDate() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date());
        Locale defaultLocale = Locale.getDefault();
        Locale.setDefault(new Locale(Activator.getDefault().getPreferenceStore().getString("changelogLocal")));
        String date = this.SIMPLE_DATE_FORMAT.format(new Date());
        Locale.setDefault(defaultLocale);
        return date;
    }

    public String mergeChangelog(String dateLine, String functionGuess, String defaultContent, IEditorPart changelog, String changeLogLocation, String fileLocation) {
        if (changelog instanceof SpecfileEditor) {
            SpecfileEditor specEditor = (SpecfileEditor)changelog;
            IDocument doc = specEditor.getDocumentProvider().getDocument((Object)specEditor.getEditorInput());
            String[] positionCategories = doc.getPositionCategories();
            String contentTypesPositionCategory = null;
            String[] stringArray = positionCategories;
            int n = positionCategories.length;
            int n2 = 0;
            while (n2 < n) {
                String positionCategory = stringArray[n2];
                if (positionCategory.startsWith("__content_types_category")) {
                    contentTypesPositionCategory = positionCategory;
                }
                ++n2;
            }
            if (contentTypesPositionCategory != null) {
                try {
                    Position[] sectionPositions = doc.getPositions(contentTypesPositionCategory);
                    ITypedRegion changelogPartition = null;
                    Position[] positionArray = sectionPositions;
                    int n3 = sectionPositions.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Position position = positionArray[n4];
                        int offset = position.getOffset();
                        ITypedRegion partition = doc.getPartition(offset);
                        if (partition.getType().equals("__spec_changelog")) {
                            changelogPartition = partition;
                        }
                        ++n4;
                    }
                    StringBuilder buf = new StringBuilder();
                    String changelogText = EMPTY_STRING;
                    String[] changelogLines = new String[]{};
                    int offset = doc.getLength();
                    int length = 0;
                    if (changelogPartition == null) {
                        String endString = doc.get(doc.getLength() - 2, 2);
                        if (endString.charAt(0) != '\n') {
                            buf.append('\n');
                        }
                        if (endString.charAt(1) != '\n') {
                            buf.append('\n');
                        }
                        buf.append("%changelog\n");
                    } else {
                        offset = changelogPartition.getOffset();
                        length = changelogPartition.getLength();
                        changelogText = doc.get(offset, length);
                        changelogLines = changelogText.split("\n");
                        buf.append(changelogLines[0]).append('\n');
                    }
                    buf.append(dateLine);
                    buf.append('\n');
                    buf.append("- \n");
                    int newCursorOffset = offset + buf.length() - 1;
                    int i = 1;
                    while (i < changelogLines.length) {
                        buf.append('\n').append(changelogLines[i]);
                        ++i;
                    }
                    if (changelogLines.length > 0) {
                        buf.append('\n');
                    }
                    doc.replace(offset, length, buf.toString());
                    specEditor.selectAndReveal(newCursorOffset, 0);
                    specEditor.setFocus();
                }
                catch (BadPositionCategoryException e) {
                    SpecfileLog.logError(e);
                }
                catch (BadLocationException e) {
                    SpecfileLog.logError(e);
                }
            }
        }
        return EMPTY_STRING;
    }
}

