/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.ui.views;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.IRemoteServicesManager;
import org.eclipse.remote.internal.ui.Messages;
import org.eclipse.remote.internal.ui.RemoteUIPlugin;
import org.eclipse.remote.ui.IRemoteUIConnectionService;
import org.eclipse.remote.ui.IRemoteUIConnectionWizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class NewRemoteConnectionTypePage
extends WizardPage {
    private Table table;
    private IRemoteUIConnectionWizard nextWizard;

    public NewRemoteConnectionTypePage() {
        super("NewLaunchTargetTypePage");
        this.setTitle(Messages.NewRemoteConnectionTypePage_LaunchTargetType);
        this.setDescription(Messages.NewRemoteConnectionTypePage_SelectTargetType);
    }

    public IRemoteUIConnectionWizard getNextWizard() {
        return this.nextWizard;
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        this.table = new Table(comp, 2052);
        GridData data = new GridData(4, 4, true, true);
        this.table.setLayoutData((Object)data);
        this.setPageComplete(false);
        IRemoteServicesManager remoteManager = RemoteUIPlugin.getService(IRemoteServicesManager.class);
        for (IRemoteConnectionType connectionType : remoteManager.getAllConnectionTypes()) {
            IRemoteUIConnectionWizard wizard;
            IRemoteUIConnectionService connService;
            if (!connectionType.canAdd() || (connService = (IRemoteUIConnectionService)connectionType.getService(IRemoteUIConnectionService.class)) == null || (wizard = connService.getConnectionWizard(parent.getShell())) == null) continue;
            TableItem item = new TableItem(this.table, 0);
            item.setText(connectionType.getName());
            item.setData((Object)wizard);
            Image icon = connService.getLabelProvider().getImage((Object)connectionType);
            if (icon != null) {
                item.setImage(icon);
            }
            this.table.select(0);
            this.setPageComplete(true);
        }
        this.setControl((Control)comp);
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public IWizardPage getNextPage() {
        this.nextWizard = (IRemoteUIConnectionWizard)this.table.getSelection()[0].getData();
        if (this.nextWizard != null) {
            this.nextWizard.addPages();
            IWizardPage[] pages = this.nextWizard.getPages();
            if (pages.length > 0) {
                return pages[0];
            }
        }
        return super.getNextPage();
    }
}

