/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.ui.views;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionControlService;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.internal.ui.views.Messages;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenConnectionHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        if (selection != null && selection instanceof IStructuredSelection) {
            final ArrayList<IRemoteConnection> connections = new ArrayList<IRemoteConnection>();
            for (Object obj : (IStructuredSelection)selection) {
                if (!(obj instanceof IRemoteConnection)) continue;
                IRemoteConnection connection = (IRemoteConnection)obj;
                connections.add(connection);
            }
            new Job(Messages.OpenConnectionHandler_0){

                protected IStatus run(IProgressMonitor monitor) {
                    ArrayList<IStatus> status = new ArrayList<IStatus>();
                    for (IRemoteConnection connection : connections) {
                        IRemoteConnectionControlService controlService = (IRemoteConnectionControlService)connection.getService(IRemoteConnectionControlService.class);
                        if (controlService == null) continue;
                        try {
                            controlService.open(monitor);
                        }
                        catch (RemoteConnectionException e) {
                            status.add(e.getStatus());
                        }
                    }
                    if (status.isEmpty()) {
                        return Status.OK_STATUS;
                    }
                    return new MultiStatus("org.eclipse.remote.ui", 1, status.toArray(new IStatus[status.size()]), Messages.OpenConnectionHandler_1, null);
                }
            }.schedule();
        }
        return Status.OK_STATUS;
    }
}

