/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.viewmodel.expression;

import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.debug.internal.ui.viewmodel.VMViewerUpdateTracing;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.expression.IExpressionUpdate;
import org.eclipse.cdt.dsf.internal.DsfPlugin;
import org.eclipse.cdt.dsf.internal.LoggingUtils;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.ui.viewmodel.VMViewerUpdate;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.jface.viewers.TreePath;

class VMExpressionUpdate
extends VMViewerUpdate
implements IExpressionUpdate {
    private final IExpression fExpression;
    private Object fExpressionElement;

    public VMExpressionUpdate(IViewerUpdate clientUpdate, IExpression expression, DataRequestMonitor<Object> rm) {
        super(clientUpdate, (RequestMonitor)rm);
        this.fExpression = expression;
    }

    public VMExpressionUpdate(IModelDelta delta, IPresentationContext presentationContext, IExpression expression, DataRequestMonitor<Object> rm) {
        super(delta, presentationContext, (RequestMonitor)rm);
        this.fExpression = expression;
    }

    public VMExpressionUpdate(TreePath elementPath, Object viewerInput, IPresentationContext presentationContext, IExpression expression, DataRequestMonitor<Object> rm) {
        super(elementPath, viewerInput, presentationContext, (RequestMonitor)rm);
        this.fExpression = expression;
    }

    @Override
    public IExpression getExpression() {
        return this.fExpression;
    }

    @Override
    public void setExpressionElement(Object element) {
        this.fExpressionElement = element;
    }

    public String toString() {
        return "VMExpressionUpdate for elements under parent = " + this.getElement() + ", in for expression " + this.getExpression().getExpressionText();
    }

    @Override
    public void done() {
        DataRequestMonitor rm = (DataRequestMonitor)this.getRequestMonitor();
        if (this.fExpressionElement != null) {
            rm.setData(this.fExpressionElement);
        } else if (rm.isSuccess()) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 10004, "Incomplete elements of updates", null));
        }
        if (VMViewerUpdateTracing.DEBUG_VMUPDATES && !this.isCanceled() && VMViewerUpdateTracing.matchesFilterRegex(this.getClass())) {
            DsfUIPlugin.debug(String.valueOf(DsfPlugin.getDebugTime()) + " " + LoggingUtils.toString((Object)this) + " marked done; element = " + LoggingUtils.toString((Object)this.getElement()) + "\n   expression = " + (this.fExpressionElement != null ? LoggingUtils.toString((Object)this.fExpressionElement) : "<unset>"));
        }
        super.done();
    }
}

