/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core;

import com.ibm.icu.text.MessageFormat;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.DebugCoreMessages;
import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.model.ICAddressBreakpoint;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICBreakpointType;
import org.eclipse.cdt.debug.core.model.ICDynamicPrintf;
import org.eclipse.cdt.debug.core.model.ICFunctionBreakpoint;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.core.model.ICValue;
import org.eclipse.cdt.debug.core.model.ICWatchpoint;
import org.eclipse.cdt.debug.core.model.ICWatchpoint2;
import org.eclipse.cdt.debug.internal.core.model.CFloatingPointValue;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IBreakpoint;
import org.osgi.service.prefs.BackingStoreException;
import org.w3c.dom.Document;

public class CDebugUtils {
    private static CharsetDecoder fDecoder;

    public static boolean question(IStatus status, Object source) {
        Boolean result = Boolean.FALSE;
        IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler(status);
        if (handler != null) {
            try {
                result = (Boolean)handler.handleStatus(status, source);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return result;
    }

    public static void info(IStatus status, Object source) {
        IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler(status);
        if (handler != null) {
            try {
                handler.handleStatus(status, source);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    public static void error(IStatus status, Object source) {
        IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler(status);
        if (handler != null) {
            try {
                handler.handleStatus(status, source);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    public static char[] getByteText(byte b) {
        return new char[]{CDebugUtils.charFromByte((byte)(b >>> 4 & 0xF)), CDebugUtils.charFromByte((byte)(b & 0xF))};
    }

    public static byte textToByte(char[] text) {
        byte result = 0;
        if (text.length == 2) {
            byte[] bytes = new byte[]{CDebugUtils.charToByte(text[0]), CDebugUtils.charToByte(text[1])};
            result = (byte)((bytes[0] << 4) + bytes[1]);
        }
        return result;
    }

    public static char charFromByte(byte value) {
        if (value >= 0 && value <= 9) {
            return (char)(value + 48);
        }
        if (value >= 10 && value <= 15) {
            return (char)(value - 10 + 97);
        }
        return '0';
    }

    public static byte charToByte(char ch) {
        if (Character.isDigit(ch)) {
            return (byte)(ch - 48);
        }
        if (ch >= 'a' && ch <= 'f') {
            return (byte)(10 + ch - 97);
        }
        if (ch >= 'A' && ch <= 'F') {
            return (byte)(10 + ch - 65);
        }
        return 0;
    }

    public static char bytesToChar(byte[] bytes) {
        try {
            return (char)Short.parseShort(new String(bytes), 16);
        }
        catch (RuntimeException runtimeException) {
            return '\u0000';
        }
    }

    public static byte toByte(char[] bytes, boolean le) {
        if (bytes.length != 2) {
            return 0;
        }
        return (byte)Long.parseLong(CDebugUtils.bytesToString(bytes, le, true), 16);
    }

    public static short toUnsignedByte(char[] bytes, boolean le) {
        if (bytes.length != 2) {
            return 0;
        }
        return (short)Long.parseLong(CDebugUtils.bytesToString(bytes, le, false), 16);
    }

    public static short toShort(char[] bytes, boolean le) {
        if (bytes.length != 4) {
            return 0;
        }
        return (short)Long.parseLong(CDebugUtils.bytesToString(bytes, le, true), 16);
    }

    public static int toUnsignedShort(char[] bytes, boolean le) {
        if (bytes.length != 4) {
            return 0;
        }
        return (int)Long.parseLong(CDebugUtils.bytesToString(bytes, le, false), 16);
    }

    public static int toInt(char[] bytes, boolean le) {
        if (bytes.length != 8) {
            return 0;
        }
        return (int)Long.parseLong(CDebugUtils.bytesToString(bytes, le, true), 16);
    }

    public static long toUnsignedInt(char[] bytes, boolean le) {
        if (bytes.length != 8) {
            return 0L;
        }
        return Long.parseLong(CDebugUtils.bytesToString(bytes, le, false), 16);
    }

    private static String bytesToString(char[] bytes, boolean le, boolean signed) {
        char[] copy = new char[bytes.length];
        if (le) {
            int i = 0;
            while (i < bytes.length / 2) {
                copy[2 * i] = bytes[bytes.length - 2 * i - 2];
                copy[2 * i + 1] = bytes[bytes.length - 2 * i - 1];
                ++i;
            }
        } else {
            System.arraycopy(bytes, 0, copy, 0, copy.length);
        }
        return new String(copy);
    }

    public static String prependString(String text, int length, char ch) {
        StringBuffer sb = new StringBuffer(length);
        if (text.length() > length) {
            sb.append(text.substring(0, length));
        } else {
            char[] prefix = new char[length - text.length()];
            Arrays.fill(prefix, ch);
            sb.append(prefix);
            sb.append(text);
        }
        return sb.toString();
    }

    public static boolean isReferencedProject(IProject parent, IProject project) {
        if (parent != null && parent.exists()) {
            List<IProject> projects = CDebugUtils.getReferencedProjects(project);
            for (IProject proj : projects) {
                if (!proj.exists() || !proj.equals((Object)project)) continue;
                return true;
            }
        }
        return false;
    }

    public static String serializeDocument(Document doc, boolean indent) throws IOException, TransformerException {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", indent ? "yes" : "no");
        DOMSource source = new DOMSource(doc);
        StreamResult outputTarget = new StreamResult(s);
        transformer.transform(source, outputTarget);
        return s.toString("UTF8");
    }

    public static String serializeDocument(Document doc) throws IOException, TransformerException {
        return CDebugUtils.serializeDocument(doc, true);
    }

    public static Number getFloatingPointValue(ICValue value) {
        if (value instanceof CFloatingPointValue) {
            try {
                return ((CFloatingPointValue)value).getFloatingPointValue();
            }
            catch (CDIException cDIException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isNaN(Number value) {
        if (value instanceof Double) {
            return ((Double)value).isNaN();
        }
        if (value instanceof Float) {
            return ((Float)value).isNaN();
        }
        return false;
    }

    public static boolean isPositiveInfinity(Number value) {
        if (value instanceof Double) {
            return ((Double)value).isInfinite() && value.doubleValue() == Double.POSITIVE_INFINITY;
        }
        if (value instanceof Float) {
            return ((Float)value).isInfinite() && value.floatValue() == Float.POSITIVE_INFINITY;
        }
        return false;
    }

    public static boolean isNegativeInfinity(Number value) {
        if (value instanceof Double) {
            return ((Double)value).isInfinite() && value.doubleValue() == Double.NEGATIVE_INFINITY;
        }
        if (value instanceof Float) {
            return ((Float)value).isInfinite() && value.floatValue() == Float.NEGATIVE_INFINITY;
        }
        return false;
    }

    public static List<IProject> getReferencedProjects(IProject project) {
        ArrayList<IProject> list = new ArrayList<IProject>(10);
        if (project != null && project.exists() && project.isOpen()) {
            IProject[] refs = new IProject[]{};
            try {
                refs = project.getReferencedProjects();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            int i = 0;
            while (i < refs.length) {
                if (!project.equals((Object)refs[i]) && refs[i] != null && refs[i].exists() && refs[i].isOpen()) {
                    list.add(refs[i]);
                    CDebugUtils.getReferencedProjects(project, refs[i], list);
                }
                ++i;
            }
        }
        return list;
    }

    private static void getReferencedProjects(IProject root, IProject project, List<IProject> list) {
        if (project != null && project.exists() && project.isOpen()) {
            IProject[] refs = new IProject[]{};
            try {
                refs = project.getReferencedProjects();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            int i = 0;
            while (i < refs.length) {
                if (!list.contains(refs[i]) && refs[i] != null && !refs[i].equals((Object)root) && refs[i].exists() && refs[i].isOpen()) {
                    list.add(refs[i]);
                    CDebugUtils.getReferencedProjects(root, refs[i], list);
                }
                ++i;
            }
        }
    }

    public static String getBreakpointText(IBreakpoint breakpoint, boolean qualified) throws CoreException {
        try {
            if (breakpoint instanceof ICAddressBreakpoint) {
                return CDebugUtils.getAddressBreakpointText((ICAddressBreakpoint)breakpoint, qualified);
            }
            if (breakpoint instanceof ICFunctionBreakpoint) {
                return CDebugUtils.getFunctionBreakpointText((ICFunctionBreakpoint)breakpoint, qualified);
            }
            if (breakpoint instanceof ICLineBreakpoint) {
                return CDebugUtils.getLineBreakpointText((ICLineBreakpoint)breakpoint, qualified);
            }
            if (breakpoint instanceof ICWatchpoint) {
                return CDebugUtils.getWatchpointText((ICWatchpoint)breakpoint, qualified);
            }
            Object message = breakpoint.getMarker().getAttribute("message");
            if (message != null) {
                return message.toString();
            }
        }
        catch (CoreException e) {
            IMarker marker = breakpoint.getMarker();
            if (marker == null || !marker.exists()) {
                return DebugCoreMessages.getString("CDebugUtils.breakpoint_deleted");
            }
            CDebugCorePlugin.log(e);
            return DebugCoreMessages.getString("CDebugUtils.exception_occurred");
        }
        return "";
    }

    protected static String getLineBreakpointText(ICLineBreakpoint breakpoint, boolean qualified) throws CoreException {
        StringBuffer label = new StringBuffer();
        CDebugUtils.appendSourceName(breakpoint, label, qualified);
        CDebugUtils.appendLineNumber(breakpoint, label);
        if (breakpoint instanceof ICDynamicPrintf) {
            CDebugUtils.appendPrintfString((ICDynamicPrintf)breakpoint, label);
        }
        CDebugUtils.appendBreakpointType(breakpoint, label);
        CDebugUtils.appendIgnoreCount(breakpoint, label);
        CDebugUtils.appendCondition(breakpoint, label);
        return label.toString();
    }

    protected static String getWatchpointText(ICWatchpoint watchpoint, boolean qualified) throws CoreException {
        StringBuffer label = new StringBuffer();
        CDebugUtils.appendSourceName(watchpoint, label, qualified);
        CDebugUtils.appendWatchExpression(watchpoint, label);
        if (watchpoint instanceof ICWatchpoint2) {
            ICWatchpoint2 wp2 = (ICWatchpoint2)watchpoint;
            CDebugUtils.appendWatchMemorySpace(wp2, label);
            CDebugUtils.appendWatchRange(wp2, label);
        }
        CDebugUtils.appendBreakpointType(watchpoint, label);
        CDebugUtils.appendIgnoreCount(watchpoint, label);
        CDebugUtils.appendCondition(watchpoint, label);
        return label.toString();
    }

    protected static String getAddressBreakpointText(ICAddressBreakpoint breakpoint, boolean qualified) throws CoreException {
        StringBuffer label = new StringBuffer();
        CDebugUtils.appendSourceName(breakpoint, label, qualified);
        CDebugUtils.appendAddress(breakpoint, label);
        if (breakpoint instanceof ICDynamicPrintf) {
            CDebugUtils.appendPrintfString((ICDynamicPrintf)((Object)breakpoint), label);
        }
        CDebugUtils.appendBreakpointType(breakpoint, label);
        CDebugUtils.appendIgnoreCount(breakpoint, label);
        CDebugUtils.appendCondition(breakpoint, label);
        return label.toString();
    }

    protected static String getFunctionBreakpointText(ICFunctionBreakpoint breakpoint, boolean qualified) throws CoreException {
        StringBuffer label = new StringBuffer();
        CDebugUtils.appendSourceName(breakpoint, label, qualified);
        CDebugUtils.appendFunction(breakpoint, label);
        if (breakpoint instanceof ICDynamicPrintf) {
            CDebugUtils.appendPrintfString((ICDynamicPrintf)((Object)breakpoint), label);
        }
        CDebugUtils.appendBreakpointType(breakpoint, label);
        CDebugUtils.appendIgnoreCount(breakpoint, label);
        CDebugUtils.appendCondition(breakpoint, label);
        return label.toString();
    }

    protected static StringBuffer appendSourceName(ICBreakpoint breakpoint, StringBuffer label, boolean qualified) throws CoreException {
        Path path;
        String handle = breakpoint.getSourceHandle();
        if (!CDebugUtils.isEmpty(handle) && (path = new Path(handle)).isValidPath(handle)) {
            label.append(qualified ? path.toOSString() : path.lastSegment());
        }
        return label;
    }

    protected static StringBuffer appendLineNumber(ICLineBreakpoint breakpoint, StringBuffer label) throws CoreException {
        int lineNumber = breakpoint.getLineNumber();
        if (lineNumber > 0) {
            label.append(' ');
            label.append(MessageFormat.format((String)DebugCoreMessages.getString("CDebugUtils.0"), (Object[])new String[]{Integer.toString(lineNumber)}));
        }
        return label;
    }

    protected static StringBuffer appendAddress(ICAddressBreakpoint breakpoint, StringBuffer label) throws CoreException {
        try {
            label.append(' ');
            label.append(MessageFormat.format((String)DebugCoreMessages.getString("CDebugUtils.1"), (Object[])new String[]{breakpoint.getAddress()}));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return label;
    }

    protected static StringBuffer appendFunction(ICFunctionBreakpoint breakpoint, StringBuffer label) throws CoreException {
        String function = breakpoint.getFunction();
        if (function != null && function.trim().length() > 0) {
            label.append(' ');
            label.append(MessageFormat.format((String)DebugCoreMessages.getString("CDebugUtils.2"), (Object[])new String[]{function.trim()}));
        }
        return label;
    }

    protected static void appendPrintfString(ICDynamicPrintf dprintf, StringBuffer buffer) throws CoreException {
        String printfStr = dprintf.getPrintfString();
        if (printfStr != null && printfStr.length() > 0) {
            buffer.append(' ');
            buffer.append(MessageFormat.format((String)DebugCoreMessages.getString("CDebugUtils.printfString"), (Object[])new String[]{printfStr}));
        }
    }

    protected static StringBuffer appendIgnoreCount(ICBreakpoint breakpoint, StringBuffer label) throws CoreException {
        int ignoreCount = breakpoint.getIgnoreCount();
        if (ignoreCount > 0) {
            label.append(' ');
            label.append(MessageFormat.format((String)DebugCoreMessages.getString("CDebugUtils.3"), (Object[])new String[]{Integer.toString(ignoreCount)}));
        }
        return label;
    }

    protected static void appendCondition(ICBreakpoint breakpoint, StringBuffer buffer) throws CoreException {
        String condition = breakpoint.getCondition();
        if (condition != null && condition.length() > 0) {
            buffer.append(' ');
            buffer.append(MessageFormat.format((String)DebugCoreMessages.getString("CDebugUtils.4"), (Object[])new String[]{condition}));
        }
    }

    private static void appendWatchExpression(ICWatchpoint watchpoint, StringBuffer label) throws CoreException {
        String expression = watchpoint.getExpression();
        if (expression != null && expression.length() > 0) {
            label.append(' ');
            label.append(MessageFormat.format((String)DebugCoreMessages.getString("CDebugUtils.5"), (Object[])new String[]{expression}));
        }
    }

    private static void appendWatchMemorySpace(ICWatchpoint2 watchpoint, StringBuffer label) throws CoreException {
        String memorySpace = watchpoint.getMemorySpace();
        if (memorySpace != null && memorySpace.length() > 0) {
            label.append(' ');
            label.append(MessageFormat.format((String)DebugCoreMessages.getString("CDebugUtils.6"), (Object[])new String[]{memorySpace}));
        }
    }

    private static void appendWatchRange(ICWatchpoint2 watchpoint, StringBuffer label) throws CoreException {
        String range = watchpoint.getRange().toString();
        if (range.length() > 0 && !range.equals("0")) {
            label.append(' ');
            label.append(MessageFormat.format((String)DebugCoreMessages.getString("CDebugUtils.7"), (Object[])new String[]{range}));
        }
    }

    protected static StringBuffer appendBreakpointType(ICBreakpoint breakpoint, StringBuffer label) throws CoreException {
        if (breakpoint instanceof ICBreakpointType) {
            String typeString = "";
            int type = ((ICBreakpointType)((Object)breakpoint)).getType();
            switch (type & 0xFFFFFFFE) {
                case 2: {
                    typeString = DebugCoreMessages.getString("CDebugUtils.Hardware");
                    break;
                }
                case 4: {
                    typeString = DebugCoreMessages.getString("CDebugUtils.Software");
                }
            }
            if ((type & 1) != 0) {
                if (typeString.length() > 0) {
                    typeString = String.valueOf(typeString) + "/";
                }
                typeString = String.valueOf(typeString) + DebugCoreMessages.getString("CDebugUtils.Temporary");
            }
            if (typeString.length() > 0) {
                label.append(' ');
                label.append(MessageFormat.format((String)DebugCoreMessages.getString("CDebugUtils.8"), (Object[])new String[]{typeString}));
            }
        }
        return label;
    }

    private static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static CharsetDecoder getCharsetDecoder() {
        String charsetName = CDebugCorePlugin.getDefault().getPluginPreferences().getString(ICDebugConstants.PREF_DEBUG_WIDE_CHARSET);
        if (fDecoder == null || !fDecoder.charset().name().equals(charsetName)) {
            Charset charset = Charset.forName(charsetName);
            fDecoder = charset.newDecoder();
        }
        return fDecoder;
    }

    public static ICProject getCProject(ILaunchConfiguration configuration) throws CoreException {
        String projectName = CDebugUtils.getProjectName(configuration);
        if (projectName != null && (projectName = projectName.trim()).length() > 0) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            ICProject cProject = CCorePlugin.getDefault().getCoreModel().create(project);
            if (cProject != null && cProject.exists()) {
                return cProject;
            }
        }
        return null;
    }

    public static String getProjectName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", null);
    }

    public static String getProgramName(ILaunchConfiguration configuration) throws CoreException {
        String programName = configuration.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", null);
        if (programName != null) {
            programName = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(programName);
        }
        return programName;
    }

    public static IPath getProgramPath(ILaunchConfiguration configuration) throws CoreException {
        String path = CDebugUtils.getProgramName(configuration);
        if (path == null || path.trim().length() == 0) {
            return null;
        }
        return new Path(path);
    }

    public static ICProject verifyCProject(ILaunchConfiguration config) throws CoreException {
        ICProject cproject;
        String name = CDebugUtils.getProjectName(config);
        if (name == null) {
            CDebugUtils.throwCoreException(DebugCoreMessages.getString("CDebugUtils.C_Project_not_specified"), 102);
        }
        if ((cproject = CDebugUtils.getCProject(config)) == null) {
            IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
            if (!proj.exists()) {
                CDebugUtils.throwCoreException(DebugCoreMessages.getFormattedString("CDebugUtils.Project_NAME_does_not_exist", name), 103);
            } else if (!proj.isOpen()) {
                CDebugUtils.throwCoreException(DebugCoreMessages.getFormattedString("CDebugUtils.Project_NAME_is_closed", name), 103);
            }
            CDebugUtils.throwCoreException(DebugCoreMessages.getString("CDebugUtils.Not_a_C_CPP_project"), 103);
        }
        return cproject;
    }

    public static IPath verifyProgramPath(ILaunchConfiguration config, boolean ignoreProjectSetting) throws CoreException {
        IPath programPath;
        ICProject cproject = null;
        if (!ignoreProjectSetting) {
            cproject = CDebugUtils.verifyCProject(config);
        }
        if ((programPath = CDebugUtils.getProgramPath(config)) == null || programPath.isEmpty()) {
            CDebugUtils.throwCoreException(DebugCoreMessages.getString("CDebugUtils.Program_file_not_specified"), 105);
        }
        if (programPath != null) {
            IPath location;
            if (!programPath.isAbsolute() && cproject != null && (location = cproject.getProject().getLocation()) != null && !(programPath = location.append(programPath)).toFile().exists()) {
                IFile projFile = null;
                try {
                    projFile = cproject.getProject().getFile(CDebugUtils.getProgramPath(config));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (projFile != null && projFile.exists()) {
                    programPath = projFile.getLocation();
                }
            }
            if (!programPath.toFile().exists()) {
                CDebugUtils.throwCoreException(DebugCoreMessages.getString("CDebugUtils.Program_file_does_not_exist"), new FileNotFoundException(DebugCoreMessages.getFormattedString("CDebugUtils.PROGRAM_PATH_not_found", programPath.toOSString())), 104);
            }
        }
        return programPath;
    }

    public static IPath verifyProgramPath(ILaunchConfiguration config) throws CoreException {
        return CDebugUtils.verifyProgramPath(config, false);
    }

    private static void throwCoreException(String msg, int code) throws CoreException {
        CDebugUtils.throwCoreException(msg, null, code);
    }

    private static void throwCoreException(String msg, Exception innerException, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, CDebugCorePlugin.getUniqueIdentifier(), code, msg, (Throwable)innerException));
    }

    public static <V> V getAttribute(Map<String, ?> attributes, String key, V defaultValue) {
        Object value = attributes.get(key);
        if (defaultValue.getClass().isInstance(value)) {
            return (V)value;
        }
        return defaultValue;
    }

    public static void setToggleBreakpointFactory(IProject project, String factoryId) {
        try {
            IEclipsePreferences pref = new ProjectScope(project).getNode("org.eclipse.cdt.debug.core");
            pref.put(ICDebugConstants.PREF_TOGGLE_BREAKPOINT_MODEL_IDENTIFIER, factoryId);
            pref.flush();
        }
        catch (BackingStoreException e) {
            CDebugCorePlugin.log(e);
        }
    }

    public static String getToggleBreakpointFactory(IProject project) {
        IEclipsePreferences pref = new ProjectScope(project.getProject()).getNode("org.eclipse.cdt.debug.core");
        return pref.get(ICDebugConstants.PREF_TOGGLE_BREAKPOINT_MODEL_IDENTIFIER, null);
    }

    public static boolean isStandardCBreakpointFactory(IProject project) {
        return CDebugUtils.getToggleBreakpointFactory(project) == null;
    }

    public static boolean isCustomToggleBreakpointFactory() {
        String customModel = System.getProperty(ICDebugConstants.PREF_TOGGLE_BREAKPOINT_MODEL_IDENTIFIER, null);
        return customModel != null && Boolean.valueOf(customModel) != false;
    }
}

