/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.accessibility.util;

import com.sun.java.accessibility.util.AccessibilityListenerList;
import com.sun.java.accessibility.util.EventQueueMonitor;
import com.sun.java.accessibility.util.TopLevelWindowListener;
import com.sun.java.accessibility.util._AccessibleState;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import jdk.Exported;

@Exported
public class AccessibilityEventMonitor {
    protected static final AccessibilityListenerList listenerList = new AccessibilityListenerList();
    protected static final AccessibilityEventListener accessibilityListener = new AccessibilityEventListener();

    public static void addPropertyChangeListener(PropertyChangeListener l) {
        if (listenerList.getListenerCount(PropertyChangeListener.class) == 0) {
            accessibilityListener.installListeners();
        }
        listenerList.add(PropertyChangeListener.class, l);
    }

    public static void removePropertyChangeListener(PropertyChangeListener l) {
        listenerList.remove(PropertyChangeListener.class, l);
        if (listenerList.getListenerCount(PropertyChangeListener.class) == 0) {
            accessibilityListener.removeListeners();
        }
    }

    static class AccessibilityEventListener
    implements TopLevelWindowListener,
    PropertyChangeListener {
        public AccessibilityEventListener() {
            EventQueueMonitor.addTopLevelWindowListener(this);
        }

        protected void installListeners() {
            Window[] topLevelWindows = EventQueueMonitor.getTopLevelWindows();
            if (topLevelWindows != null) {
                for (int i = 0; i < topLevelWindows.length; ++i) {
                    if (!(topLevelWindows[i] instanceof Accessible)) continue;
                    this.installListeners(topLevelWindows[i]);
                }
            }
        }

        protected void installListeners(Accessible a) {
            this.installListeners(a.getAccessibleContext());
        }

        private void installListeners(AccessibleContext ac) {
            AccessibleStateSet states;
            if (ac != null && !(states = ac.getAccessibleStateSet()).contains(AccessibleState.TRANSIENT)) {
                AccessibleContext ac2;
                Accessible child;
                ac.addPropertyChangeListener(this);
                AccessibleStateSet set = ac.getAccessibleStateSet();
                if (set.contains(_AccessibleState.MANAGES_DESCENDANTS)) {
                    return;
                }
                AccessibleRole role = ac.getAccessibleRole();
                if (role == AccessibleRole.LIST || role == AccessibleRole.TREE) {
                    return;
                }
                if (role == AccessibleRole.TABLE && (child = ac.getAccessibleChild(0)) != null && (ac2 = child.getAccessibleContext()) != null && (role = ac2.getAccessibleRole()) != null && role != AccessibleRole.TABLE) {
                    return;
                }
                int count = ac.getAccessibleChildrenCount();
                for (int i = 0; i < count; ++i) {
                    Accessible child2 = ac.getAccessibleChild(i);
                    if (child2 == null) continue;
                    this.installListeners(child2);
                }
            }
        }

        protected void removeListeners() {
            Window[] topLevelWindows = EventQueueMonitor.getTopLevelWindows();
            if (topLevelWindows != null) {
                for (int i = 0; i < topLevelWindows.length; ++i) {
                    if (!(topLevelWindows[i] instanceof Accessible)) continue;
                    this.removeListeners(topLevelWindows[i]);
                }
            }
        }

        protected void removeListeners(Accessible a) {
            this.removeListeners(a.getAccessibleContext());
        }

        private void removeListeners(AccessibleContext ac) {
            AccessibleStateSet states;
            if (ac != null && !(states = ac.getAccessibleStateSet()).contains(AccessibleState.TRANSIENT)) {
                ac.removePropertyChangeListener(this);
                if (states.contains(_AccessibleState.MANAGES_DESCENDANTS)) {
                    return;
                }
                AccessibleRole role = ac.getAccessibleRole();
                if (role == AccessibleRole.LIST || role == AccessibleRole.TABLE || role == AccessibleRole.TREE) {
                    return;
                }
                int count = ac.getAccessibleChildrenCount();
                for (int i = 0; i < count; ++i) {
                    Accessible child = ac.getAccessibleChild(i);
                    if (child == null) continue;
                    this.removeListeners(child);
                }
            }
        }

        @Override
        public void topLevelWindowCreated(Window w) {
            if (w instanceof Accessible) {
                this.installListeners(w);
            }
        }

        @Override
        public void topLevelWindowDestroyed(Window w) {
            if (w instanceof Accessible) {
                this.removeListeners(w);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            Object[] listeners = listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != PropertyChangeListener.class) continue;
                ((PropertyChangeListener)listeners[i + 1]).propertyChange(e);
            }
            String name = e.getPropertyName();
            if (name.compareTo("AccessibleChild") == 0) {
                Object newValue;
                Object oldValue = e.getOldValue();
                if (oldValue == null ^ (newValue = e.getNewValue()) == null) {
                    if (oldValue != null) {
                        if (oldValue instanceof Accessible) {
                            Accessible a = (Accessible)oldValue;
                            this.removeListeners(a.getAccessibleContext());
                        } else if (oldValue instanceof AccessibleContext) {
                            this.removeListeners((AccessibleContext)oldValue);
                        }
                    } else if (newValue != null) {
                        if (newValue instanceof Accessible) {
                            Accessible a = (Accessible)newValue;
                            this.installListeners(a.getAccessibleContext());
                        } else if (newValue instanceof AccessibleContext) {
                            this.installListeners((AccessibleContext)newValue);
                        }
                    }
                } else {
                    System.out.println("ERROR in usage of PropertyChangeEvents for: " + e.toString());
                }
            }
        }
    }
}

