/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPAliasTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPTemplateParameterOwner;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.core.runtime.PlatformObject;

public class CPPAliasTemplate
extends PlatformObject
implements ICPPAliasTemplate,
ICPPTemplateParameterOwner {
    private final IASTName aliasName;
    private final IType aliasedType;
    private ICPPTemplateParameter[] templateParameters;

    public CPPAliasTemplate(IASTName aliasName, IType aliasedType) {
        this.aliasName = aliasName;
        this.aliasedType = aliasedType;
        aliasName.setBinding(this);
    }

    @Override
    public IType getType() {
        return this.aliasedType;
    }

    @Override
    public String getName() {
        return new String(this.getNameCharArray());
    }

    @Override
    public char[] getNameCharArray() {
        return this.aliasName.getSimpleID();
    }

    @Override
    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    @Override
    public IBinding getOwner() {
        return CPPVisitor.findDeclarationOwner(this.aliasName, true);
    }

    @Override
    public IScope getScope() throws DOMException {
        return CPPVisitor.getContainingScope(this.aliasName.getParent());
    }

    @Override
    public boolean isSameType(IType type) {
        if (type == null) {
            return false;
        }
        IType aliasedType = this.getType();
        return type.isSameType(aliasedType);
    }

    @Override
    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return t;
    }

    @Override
    public String[] getQualifiedName() throws DOMException {
        return CPPVisitor.getQualifiedName(this);
    }

    @Override
    public char[][] getQualifiedNameCharArray() throws DOMException {
        return CPPVisitor.getQualifiedNameCharArray(this);
    }

    @Override
    public boolean isGloballyQualified() throws DOMException {
        return true;
    }

    @Override
    public ICPPTemplateParameter[] getTemplateParameters() {
        if (this.templateParameters == null) {
            ICPPASTTemplateDeclaration template = CPPTemplates.getTemplateDeclaration(this.aliasName);
            if (template == null) {
                return ICPPTemplateParameter.EMPTY_TEMPLATE_PARAMETER_ARRAY;
            }
            ICPPASTTemplateParameter[] params = template.getTemplateParameters();
            IBinding p = null;
            ICPPTemplateParameter[] result = null;
            ICPPASTTemplateParameter[] iCPPASTTemplateParameterArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPASTTemplateParameter param = iCPPASTTemplateParameterArray[n2];
                p = CPPTemplates.getTemplateParameterName(param).resolveBinding();
                if (p instanceof ICPPTemplateParameter) {
                    result = ArrayUtil.append(ICPPTemplateParameter.class, result, (ICPPTemplateParameter)p);
                }
                ++n2;
            }
            this.templateParameters = ArrayUtil.trim(ICPPTemplateParameter.class, result);
        }
        return this.templateParameters;
    }

    public String toString() {
        return String.valueOf(ASTTypeUtil.getQualifiedName(this)) + " -> " + ASTTypeUtil.getType(this.aliasedType, true);
    }

    @Override
    public IBinding resolveTemplateParameter(ICPPTemplateParameter templateParameter) {
        ICPPASTTemplateParameter[] params;
        short pos = templateParameter.getParameterPosition();
        if (pos < (params = CPPTemplates.getTemplateDeclaration(this.aliasName).getTemplateParameters()).length) {
            IASTName oName = CPPTemplates.getTemplateParameterName(params[pos]);
            return oName.resolvePreBinding();
        }
        return templateParameter;
    }
}

