/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.packs.ui.views;

import ilg.gnuarmeclipse.core.EclipseUtils;
import ilg.gnuarmeclipse.packs.core.data.PacksStorage;
import ilg.gnuarmeclipse.packs.core.tree.Leaf;
import ilg.gnuarmeclipse.packs.core.tree.Node;
import ilg.gnuarmeclipse.packs.core.tree.NodeViewContentProvider;
import ilg.gnuarmeclipse.packs.core.tree.PackNode;
import ilg.gnuarmeclipse.packs.data.DataManager;
import ilg.gnuarmeclipse.packs.jobs.ParsePdscRunnable;
import ilg.gnuarmeclipse.packs.ui.Activator;
import ilg.gnuarmeclipse.packs.ui.IconUtils;
import ilg.gnuarmeclipse.packs.ui.views.PacksView;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IProgressService;

public class OutlineView
extends ViewPart {
    public static final String ID = "ilg.gnuarmeclipse.packs.ui.views.OutlineView";
    public static final int AUTOEXPAND_LEVEL = 0;
    private TreeViewer fViewer;
    private ISelectionListener fPageSelectionListener;
    private ViewContentProvider fContentProvider;
    private Action fExpandAll;
    private Action fCollapseAll;
    private Action fDoubleClickAction;
    private Action fOpenWithText;
    private Action fOpenWithSystem;
    private IPath fPackageAbsolutePath;
    private Node fNoOutlineNode = new Node("outline");
    private DataManager fDataManager;

    public OutlineView() {
        this.fNoOutlineNode.setName("No outline");
        Node.addNewChild((Node)this.fNoOutlineNode, (String)"none").setName("An outline is not available.");
        this.fDataManager = DataManager.getInstance();
    }

    public void createPartControl(Composite parent) {
        this.fViewer = new TreeViewer(parent, 66304);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.fViewer);
        this.fContentProvider = new ViewContentProvider();
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fViewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.fViewer.setSorter((ViewerSorter)new NameSorter());
        this.fViewer.setInput((Object)this.fNoOutlineNode);
        this.addProviders();
        this.addListners();
        this.hookPostSelectionListener();
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
    }

    public void setFocus() {
        this.fViewer.getControl().setFocus();
    }

    private void addProviders() {
        this.getSite().setSelectionProvider((ISelectionProvider)this.fViewer);
    }

    private void addListners() {
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                String category;
                OutlineView.this.fOpenWithText.setEnabled(false);
                OutlineView.this.fOpenWithSystem.setEnabled(false);
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection == null || selection.isEmpty()) {
                    return;
                }
                Leaf node = (Leaf)selection.getFirstElement();
                String type = node.getType();
                if ("file".equals(type)) {
                    category = node.getProperty("category");
                    if ("header".equals(category) || category.startsWith("source") || "linkerScript".equals(category)) {
                        OutlineView.this.fOpenWithText.setEnabled(true);
                    }
                } else if ("header".equals(type)) {
                    OutlineView.this.fOpenWithText.setEnabled(true);
                } else if ("debug".equals(type)) {
                    OutlineView.this.fOpenWithText.setEnabled(true);
                }
                if ("file".equals(type)) {
                    category = node.getProperty("category");
                    if ("doc".equals(category)) {
                        OutlineView.this.fOpenWithSystem.setEnabled(true);
                    }
                } else if ("debug".equals(type)) {
                    OutlineView.this.fOpenWithSystem.setEnabled(true);
                } else if ("book".equals(type)) {
                    String url;
                    String relativeFile = node.getProperty("file");
                    if (relativeFile.length() > 0) {
                        OutlineView.this.fOpenWithSystem.setEnabled(true);
                    }
                    if ((url = node.getProperty("url")).length() > 0) {
                        OutlineView.this.fOpenWithSystem.setEnabled(true);
                    }
                }
            }
        });
    }

    private void hookPostSelectionListener() {
        this.fPageSelectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (part instanceof PacksView) {
                    OutlineView.this.packsViewSelectionChanged(part, selection);
                }
            }
        };
        this.getSite().getPage().addPostSelectionListener(this.fPageSelectionListener);
    }

    public void dispose() {
        super.dispose();
        if (this.fPageSelectionListener != null) {
            this.getSite().getPage().removePostSelectionListener(this.fPageSelectionListener);
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("OutlineView.dispose()");
        }
    }

    protected void packsViewSelectionChanged(IWorkbenchPart part, ISelection selection) {
        Leaf node;
        Node outline = this.fNoOutlineNode;
        if (!selection.isEmpty() && selection instanceof TreeSelection && (node = (Leaf)((TreeSelection)selection).getFirstElement()) instanceof PackNode) {
            Node versionNode;
            if (((PackNode)node).hasOutline()) {
                outline = ((PackNode)node).getOutline();
            } else if (node.isType("version")) {
                if (node.isBooleanProperty("installed")) {
                    this.parseOutline((PackNode)node);
                    outline = ((PackNode)node).getOutline();
                } else {
                    outline = this.getBriefOutline((Node)node);
                    ((PackNode)node).setOutline(outline);
                }
            } else if (node.isType("package")) {
                outline = this.getBriefOutline((Node)node);
                ((PackNode)node).setOutline(outline);
            } else if (node.isType("example") && (versionNode = node.getParent()).isBooleanProperty("installed")) {
                this.parseOutline((PackNode)versionNode);
                outline = ((PackNode)node).getOutline();
            }
        }
        this.fViewer.setAutoExpandLevel(0);
        this.fViewer.setInput((Object)outline);
    }

    private void parseOutline(PackNode versionNode) {
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        try {
            progressService.busyCursorWhile((IRunnableWithProgress)new ParsePdscRunnable("Parse Outline", versionNode));
        }
        catch (InvocationTargetException e1) {
            Activator.log((Throwable)e1);
        }
        catch (InterruptedException e1) {
            Activator.log((Throwable)e1);
        }
    }

    private void makeActions() {
        this.fExpandAll = new Action(){

            public void run() {
                OutlineView.this.fViewer.expandAll();
            }
        };
        this.fExpandAll.setText("Expand all");
        this.fExpandAll.setToolTipText("Expand all children nodes");
        this.fExpandAll.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"ilg.gnuarmeclipse.packs.ui", (String)"icons/expandall.png"));
        this.fCollapseAll = new Action(){

            public void run() {
                OutlineView.this.fViewer.collapseAll();
            }
        };
        this.fCollapseAll.setText("Collapse all");
        this.fCollapseAll.setToolTipText("Collapse all children nodes");
        this.fCollapseAll.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"ilg.gnuarmeclipse.packs.ui", (String)"icons/collapseall.png"));
        this.fOpenWithText = new Action(){

            public void run() {
                ISelection selection;
                Object obj;
                if (Activator.getInstance().isDebugging()) {
                    System.out.println("openWithText");
                }
                if ((obj = ((IStructuredSelection)(selection = OutlineView.this.fViewer.getSelection())).getFirstElement()) instanceof Leaf) {
                    try {
                        OutlineView.this.openWithTextAction((Leaf)((Node)obj));
                    }
                    catch (PartInitException partInitException) {
                        // empty catch block
                    }
                }
            }
        };
        this.fOpenWithText.setText("Open With Text Viewer");
        this.fOpenWithText.setEnabled(false);
        this.fOpenWithSystem = new Action(){

            public void run() {
                ISelection selection;
                Object obj;
                if (Activator.getInstance().isDebugging()) {
                    System.out.println("openWithSystem");
                }
                if ((obj = ((IStructuredSelection)(selection = OutlineView.this.fViewer.getSelection())).getFirstElement()) instanceof Node) {
                    try {
                        OutlineView.this.openWithSystemAction((Leaf)((Node)obj));
                    }
                    catch (PartInitException partInitException) {
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
        };
        this.fOpenWithSystem.setText("Open With System Viewer");
        this.fOpenWithSystem.setEnabled(false);
        this.fDoubleClickAction = new Action(){

            public void run() {
                ISelection selection = OutlineView.this.fViewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj instanceof Node) {
                    try {
                        OutlineView.this.doubleClickAction((Node)obj);
                    }
                    catch (PartInitException partInitException) {
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
        };
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                OutlineView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.fViewer.getControl());
        this.fViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.fViewer);
    }

    private void hookDoubleClickAction() {
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                OutlineView.this.fDoubleClickAction.run();
            }
        });
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.fExpandAll);
        manager.add((IAction)this.fCollapseAll);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.fOpenWithText);
        manager.add((IAction)this.fOpenWithSystem);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.fExpandAll);
        manager.add((IAction)this.fCollapseAll);
    }

    private void doubleClickAction(Node node) throws PartInitException, MalformedURLException {
        String type = node.getType();
        if (this.fPackageAbsolutePath == null) {
            Activator.log((String)"doubleClickAction() null fPackageAbsolutePath");
            return;
        }
        if ("file".equals(type)) {
            String category = node.getProperty("category");
            String relativeFile = node.getProperty("file");
            if ("header".equals(category) || category.startsWith("source") || "linkerScript".equals(category)) {
                EclipseUtils.openFileWithInternalEditor((IPath)this.fPackageAbsolutePath.append(relativeFile));
            } else if ("doc".equals(category)) {
                EclipseUtils.openExternalFile((IPath)this.fPackageAbsolutePath.append(relativeFile));
            } else if (!"include".equals(category) && !"library".equals(category)) {
                Activator.log((String)("File " + node + "  " + category + " ignored"));
            }
        } else if ("book".equals(type)) {
            String url = node.getProperty("url");
            String relativeFile = node.getProperty("file");
            if (url.length() > 0) {
                EclipseUtils.openExternalBrowser((URL)new URL(url));
            } else if (relativeFile.length() > 0) {
                EclipseUtils.openExternalFile((IPath)this.fPackageAbsolutePath.append(relativeFile));
            } else {
                Activator.log((String)("Book " + node + " ignored"));
            }
        } else if ("header".equals(type)) {
            String relativeFile = node.getProperty("file");
            EclipseUtils.openFileWithInternalEditor((IPath)this.fPackageAbsolutePath.append(relativeFile));
        } else if ("debug".equals(type)) {
            String relativeFile = node.getProperty("file");
            EclipseUtils.openFileWithInternalEditor((IPath)this.fPackageAbsolutePath.append(relativeFile));
        }
    }

    private void openWithTextAction(Leaf node) throws PartInitException {
        String relativeFile = node.getProperty("file");
        if (relativeFile.length() > 0) {
            assert (this.fPackageAbsolutePath != null);
            EclipseUtils.openFileWithInternalEditor((IPath)this.fPackageAbsolutePath.append(relativeFile));
        }
    }

    private void openWithSystemAction(Leaf node) throws PartInitException, MalformedURLException {
        String relativeFile = node.getProperty("file");
        if (relativeFile.length() > 0) {
            assert (this.fPackageAbsolutePath != null);
            EclipseUtils.openExternalFile((IPath)this.fPackageAbsolutePath.append(relativeFile));
            return;
        }
        String url = node.getProperty("url");
        if (url.length() > 0) {
            EclipseUtils.openExternalBrowser((URL)new URL(url));
            return;
        }
    }

    private Node getBriefOutline(Node node) {
        Node oNode;
        String packName;
        String vendorName;
        Node outlineNode = this.fNoOutlineNode;
        PackNode input = null;
        if (node.isType("package")) {
            vendorName = node.getProperty("vendor.name");
            packName = node.getName();
            input = this.fDataManager.findPackLatest(vendorName, packName);
        } else if (node.isType("version")) {
            vendorName = node.getProperty("vendor.name");
            packName = node.getProperty("pack.name");
            String versionName = node.getName();
            input = this.fDataManager.findPackVersion(vendorName, packName, versionName);
        }
        assert (input != null);
        if (input.isType("version") && (oNode = (Node)input.findChild("outline")) != null && oNode.hasChildren()) {
            outlineNode = new Node("outline");
            outlineNode.setName("Brief Outline");
            Leaf leaf = Leaf.addNewChild((Node)outlineNode, (String)"package");
            leaf.setName(input.getProperty("pack.name"));
            leaf = Leaf.addNewChild((Node)outlineNode, (String)"version");
            leaf.setName(input.getName());
            for (Leaf child : oNode.getChildren()) {
                if (child.isType("keyword")) continue;
                leaf = Leaf.addNewChild((Node)outlineNode, (Leaf)child);
            }
        }
        return outlineNode;
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return 1;
        }
    }

    class ViewContentProvider
    extends NodeViewContentProvider {
        ViewContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            String folder;
            super.inputChanged(viewer, oldInput, newInput);
            OutlineView.this.fPackageAbsolutePath = null;
            if (newInput instanceof Node && (folder = ((Node)newInput).getProperty("dest.folder")).length() > 0) {
                try {
                    OutlineView.this.fPackageAbsolutePath = PacksStorage.getFolderPath().append(folder);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    class ViewLabelProvider
    extends CellLabelProvider {
        ViewLabelProvider() {
        }

        public String getText(Object obj) {
            Leaf node = (Leaf)obj;
            String name = node.getName();
            return " " + name;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Image getImage(Object obj) {
            Leaf node = (Leaf)obj;
            String type = node.getType();
            if ("none".equals(type)) {
                return null;
            }
            String name = "";
            try {
                name = node.getName().toLowerCase();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if ("family".equals(type)) return Activator.getInstance().getImage("hardware_chip");
            if ("subfamily".equals(type)) return Activator.getInstance().getImage("hardware_chip");
            if ("device".equals(type)) return Activator.getInstance().getImage("hardware_chip");
            if ("variant".equals(type)) {
                return Activator.getInstance().getImage("hardware_chip");
            }
            if ("compatibledevice".equals(type)) {
                return Activator.getInstance().getImage("hardware_chip_grey");
            }
            if ("board".equals(type)) {
                return Activator.getInstance().getImage("board");
            }
            if ("version".equals(type)) {
                return Activator.getInstance().getImage("jtypeassist_co");
            }
            if ("example".equals(type)) {
                return Activator.getInstance().getImage("binaries_obj");
            }
            if ("component".equals(type)) {
                return Activator.getInstance().getImage("component");
            }
            if ("bundle".equals(type)) {
                return Activator.getInstance().getImage("bundle");
            }
            if ("category".equals(type)) {
                return Activator.getInstance().getImage("label_obj");
            }
            if ("keyword".equals(type)) {
                return Activator.getInstance().getImage("info_obj");
            }
            if ("debuginterface".equals(type)) return Activator.getInstance().getImage("exec_dbg_obj");
            if ("debug".equals(type)) {
                return Activator.getInstance().getImage("exec_dbg_obj");
            }
            if ("feature".equals(type)) {
                return Activator.getInstance().getImage("genericvariable_obj");
            }
            if ("book".equals(type)) {
                return IconUtils.getBookIcon(node);
            }
            if ("processor".equals(type)) {
                return Activator.getInstance().getImage("methpro_obj");
            }
            if ("file".equals(type)) {
                String category = node.getProperty("category");
                if ("source".equals(category)) {
                    if (!name.endsWith(".s")) return Activator.getInstance().getImage("c_file_obj");
                    Activator.getInstance().getImage("s_file_obj");
                    return null;
                }
                if ("header".equals(category)) {
                    return Activator.getInstance().getImage("h_file_obj");
                }
                if ("include".equals(category)) {
                    return Activator.getInstance().getImage("includes_container");
                }
                if ("library".equals(category)) {
                    return Activator.getInstance().getImage("ar_obj");
                }
                if (!"doc".equals(category)) return Activator.getInstance().getImage("file_obj");
                if (name.endsWith(".pdf")) {
                    return Activator.getInstance().getImage("pdficon_small");
                }
                if (!name.endsWith(".html")) return Activator.getInstance().getImage("file_obj");
                return Activator.getInstance().getImage("external_browser");
            }
            if ("header".equals(type)) {
                return Activator.getInstance().getImage("include_obj");
            }
            if ("define".equals(type)) {
                return Activator.getInstance().getImage("define_obj");
            }
            if ("memory".equals(type)) {
                return Activator.getInstance().getImage("memory_view");
            }
            if ("taxonomy".equals(type)) {
                return Activator.getInstance().getImage("jdoc_tag_obj");
            }
            if ("condition".equals(type)) {
                return Activator.getInstance().getImage("smartmode_co");
            }
            if ("require".equals(type)) {
                return Activator.getInstance().getImage("default_co");
            }
            if ("accept".equals(type)) {
                return Activator.getInstance().getImage("method_public_obj");
            }
            if ("deny".equals(type)) {
                return Activator.getInstance().getImage("method_private_obj");
            }
            if ("package".equals(type)) {
                return Activator.getInstance().getImage("package_obj");
            }
            if ("api".equals(type)) {
                return Activator.getInstance().getImage("int_obj");
            }
            if (!"environment".equals(type)) return Activator.getInstance().getImage("unknown_obj");
            return Activator.getInstance().getImage("config-profile");
        }

        public String getToolTipText(Object obj) {
            Leaf node = (Leaf)obj;
            String description = node.getDescription();
            if (description != null && description.length() > 0) {
                return description;
            }
            return null;
        }

        public void update(ViewerCell cell) {
            cell.setText(this.getText(cell.getElement()));
            cell.setImage(this.getImage(cell.getElement()));
        }
    }
}

