/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.gdbjtag.core;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.gdbjtag.core.Activator;
import org.eclipse.cdt.debug.gdbjtag.core.IGDBJtagConnection;
import org.eclipse.cdt.debug.gdbjtag.core.Messages;
import org.eclipse.cdt.debug.gdbjtag.core.jtagdevice.GDBJtagDeviceContribution;
import org.eclipse.cdt.debug.gdbjtag.core.jtagdevice.GDBJtagDeviceContributionFactory;
import org.eclipse.cdt.debug.gdbjtag.core.jtagdevice.IGDBJtagDevice;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ReflectionSequence;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitorWithProgress;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.gdb.launching.FinalLaunchSequence;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.IGDBMemory;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.IMIContainerDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIProcesses;
import org.eclipse.cdt.dsf.mi.service.MIBreakpointsManager;
import org.eclipse.cdt.dsf.mi.service.command.commands.CLICommand;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.utils.CommandLineUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;

public class GDBJtagDSFFinalLaunchSequence
extends FinalLaunchSequence {
    private IGDBControl fCommandControl;
    private IGDBBackend fGDBBackend;
    private IMIProcesses fProcService;
    private IGDBJtagDevice fGdbJtagDevice;
    private DsfServicesTracker fTracker;
    private IMIContainerDMContext fContainerCtx;
    protected static final String GROUP_JTAG = "GROUP_JTAG";

    private void queueCommands(List<String> commands, RequestMonitor rm) {
        if (!commands.isEmpty()) {
            this.fCommandControl.queueCommand((ICommand)new CLICommand((IDMContext)this.fCommandControl.getContext(), this.composeCommand(commands)), new DataRequestMonitor((Executor)this.getExecutor(), rm));
        } else {
            rm.done();
        }
    }

    public GDBJtagDSFFinalLaunchSequence(DsfSession session, Map<String, Object> attributes, RequestMonitorWithProgress rm) {
        super(session, attributes, rm);
    }

    public GDBJtagDSFFinalLaunchSequence(DsfExecutor executor, GdbLaunch launch, SessionType sessionType, boolean attach, RequestMonitorWithProgress rm) {
        this(launch.getSession(), GDBJtagDSFFinalLaunchSequence.getAttributes(launch), rm);
    }

    private static Map<String, Object> getAttributes(GdbLaunch launch) {
        try {
            return launch.getLaunchConfiguration().getAttributes();
        }
        catch (CoreException coreException) {
            return new HashMap<String, Object>();
        }
    }

    protected IMIContainerDMContext getContainerContext() {
        return this.fContainerCtx;
    }

    protected void setContainerContext(IMIContainerDMContext ctx) {
        this.fContainerCtx = ctx;
    }

    protected String[] getExecutionOrder(String group) {
        if ("GROUP_TOP_LEVEL".equals(group)) {
            ArrayList<String> orderList = new ArrayList<String>(Arrays.asList(super.getExecutionOrder("GROUP_TOP_LEVEL")));
            orderList.removeAll(Arrays.asList("stepNewProcess"));
            orderList.add(orderList.indexOf("stepDataModelInitializationComplete"), GROUP_JTAG);
            return orderList.toArray(new String[orderList.size()]);
        }
        if (GROUP_JTAG.equals(group)) {
            return new String[]{"stepInitializeJTAGFinalLaunchSequence", "stepRetrieveJTAGDevice", "stepLoadSymbols", "stepConnectToTarget", "stepResetBoard", "stepDelayStartup", "stepHaltBoard", "stepUserInitCommands", "stepLoadImage", "stepUpdateContainer", "stepInitializeMemory", "stepSetArguments", "stepSetEnvironmentVariables", "stepStartTrackingBreakpoints", "stepSetProgramCounter", "stepStopScript", "stepResumeScript", "stepUserDebugCommands", "stepJTAGCleanup"};
        }
        return super.getExecutionOrder(group);
    }

    @ReflectionSequence.Execute
    public void stepInitializeJTAGFinalLaunchSequence(RequestMonitor rm) {
        this.fTracker = new DsfServicesTracker(Activator.getBundleContext(), this.getSession().getId());
        this.fGDBBackend = (IGDBBackend)this.fTracker.getService(IGDBBackend.class);
        if (this.fGDBBackend == null) {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot obtain GDBBackend service", null));
            return;
        }
        this.fCommandControl = (IGDBControl)this.fTracker.getService(IGDBControl.class);
        if (this.fCommandControl == null) {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot obtain control service", null));
            return;
        }
        this.fProcService = (IMIProcesses)this.fTracker.getService(IMIProcesses.class);
        if (this.fProcService == null) {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot obtain process service", null));
            return;
        }
        this.setContainerContext(this.fProcService.createContainerContextFromGroupId(this.fCommandControl.getContext(), ""));
        rm.done();
    }

    @ReflectionSequence.RollBack(value="stepInitializeJTAGFinalLaunchSequence")
    public void rollBackInitializeFinalLaunchSequence(RequestMonitor rm) {
        if (this.fTracker != null) {
            this.fTracker.dispose();
        }
        this.fTracker = null;
        rm.done();
    }

    @ReflectionSequence.Execute
    public void stepRetrieveJTAGDevice(RequestMonitor rm) {
        NullPointerException exception = null;
        try {
            this.fGdbJtagDevice = this.getGDBJtagDevice();
        }
        catch (NullPointerException e) {
            exception = e;
        }
        if (this.fGdbJtagDevice == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot get Jtag device", (Throwable)exception));
        }
        rm.done();
    }

    @ReflectionSequence.Execute
    public void stepLoadSymbols(RequestMonitor rm) {
        try {
            if (((Boolean)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.loadSymbols", (Object)true)).booleanValue()) {
                String symbolsFileName = null;
                if (this.getAttributes().containsKey("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForSymbols") && ((Boolean)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForSymbols", (Object)true)).booleanValue()) {
                    IPath programFile = this.fGDBBackend.getProgramPath();
                    if (programFile != null) {
                        symbolsFileName = programFile.toOSString();
                    }
                } else {
                    symbolsFileName = (String)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.symbolsFileName", (Object)"");
                    symbolsFileName = symbolsFileName.length() > 0 ? VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(symbolsFileName) : null;
                }
                if (symbolsFileName == null) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, Messages.getString("GDBJtagDebugger.err_no_img_file"), null));
                    rm.done();
                    return;
                }
                symbolsFileName = symbolsFileName.replace("\\", "\\\\");
                String symbolsOffset = (String)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.symbolsOffset", (Object)"");
                if (symbolsOffset.length() > 0) {
                    symbolsOffset = "0x" + symbolsOffset;
                }
                ArrayList<String> commands = new ArrayList<String>();
                this.fGdbJtagDevice.doLoadSymbol(symbolsFileName, symbolsOffset, commands);
                this.queueCommands(commands, rm);
            } else {
                rm.done();
            }
        }
        catch (CoreException e) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot load symbol", (Throwable)e));
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepConnectToTarget(RequestMonitor rm) {
        try {
            if (((Boolean)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.useRemoteTarget", (Object)true)).booleanValue()) {
                ArrayList<String> commands = new ArrayList<String>();
                if (this.fGdbJtagDevice instanceof IGDBJtagConnection) {
                    URI uri = new URI((String)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.connection", (Object)"unspecified-ip-address:unspecified-port-number"));
                    IGDBJtagConnection device = (IGDBJtagConnection)((Object)this.fGdbJtagDevice);
                    device.doRemote(uri.getSchemeSpecificPart(), commands);
                } else {
                    String ipAddress = (String)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.ipAddress", (Object)"unspecified-ip-address");
                    int portNumber = (Integer)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.portNumber", (Object)0);
                    this.fGdbJtagDevice.doRemote(ipAddress, portNumber, commands);
                }
                this.queueCommands(commands, rm);
            } else {
                rm.done();
            }
        }
        catch (URISyntaxException e) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Invalid remote target connection syntax", (Throwable)e));
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepResetBoard(RequestMonitor rm) {
        if (((Boolean)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.doReset", (Object)true)).booleanValue()) {
            ArrayList<String> commands = new ArrayList<String>();
            this.fGdbJtagDevice.doReset(commands);
            this.queueCommands(commands, rm);
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepDelayStartup(RequestMonitor rm) {
        if (((Boolean)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.doReset", (Object)true)).booleanValue()) {
            int defaultDelay = this.fGdbJtagDevice.getDefaultDelay();
            ArrayList<String> commands = new ArrayList<String>();
            this.fGdbJtagDevice.doDelay((Integer)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.delay", (Object)defaultDelay), commands);
            this.queueCommands(commands, rm);
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepHaltBoard(RequestMonitor rm) {
        if (((Boolean)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.doHalt", (Object)true)).booleanValue()) {
            ArrayList<String> commands = new ArrayList<String>();
            this.fGdbJtagDevice.doHalt(commands);
            this.queueCommands(commands, rm);
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepUserInitCommands(RequestMonitor rm) {
        try {
            String userCmd = (String)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.initCommands", (Object)"");
            userCmd = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(userCmd);
            if (userCmd.length() > 0) {
                String[] commands = userCmd.split("\\r?\\n");
                CountingRequestMonitor crm = new CountingRequestMonitor((Executor)this.getExecutor(), rm);
                crm.setDoneCount(commands.length);
                int i = 0;
                while (i < commands.length) {
                    this.fCommandControl.queueCommand((ICommand)new CLICommand((IDMContext)this.fCommandControl.getContext(), commands[i]), new DataRequestMonitor((Executor)this.getExecutor(), (RequestMonitor)crm));
                    ++i;
                }
            } else {
                rm.done();
            }
        }
        catch (CoreException e) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot run user defined init commands", (Throwable)e));
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepLoadImage(RequestMonitor rm) {
        try {
            String imageFileName = null;
            if (((Boolean)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.loadImage", (Object)true)).booleanValue()) {
                if (this.getAttributes().containsKey("org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForImage") && ((Boolean)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.useProjBinaryForImage", (Object)true)).booleanValue()) {
                    IPath programFile = this.fGDBBackend.getProgramPath();
                    if (programFile != null) {
                        imageFileName = programFile.toOSString();
                    }
                } else {
                    imageFileName = (String)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.imageFileName", (Object)"");
                    imageFileName = imageFileName.length() > 0 ? VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(imageFileName) : null;
                }
                if (imageFileName == null) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, Messages.getString("GDBJtagDebugger.err_no_img_file"), null));
                    rm.done();
                    return;
                }
                imageFileName = imageFileName.replace("\\", "\\\\");
                String imageOffset = (String)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.imageOffset", (Object)"");
                if (imageOffset.length() > 0) {
                    imageOffset = imageFileName.endsWith(".elf") ? "" : "0x" + (String)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.imageOffset", (Object)"");
                }
                ArrayList<String> commands = new ArrayList<String>();
                this.fGdbJtagDevice.doLoadImage(imageFileName, imageOffset, commands);
                this.queueCommands(commands, rm);
            } else {
                rm.done();
            }
        }
        catch (CoreException e) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot load image", (Throwable)e));
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepUpdateContainer(RequestMonitor rm) {
        String groupId = this.getContainerContext().getGroupId();
        this.setContainerContext(this.fProcService.createContainerContextFromGroupId(this.fCommandControl.getContext(), groupId));
        rm.done();
    }

    @ReflectionSequence.Execute
    public void stepSetArguments(RequestMonitor rm) {
        try {
            String args = (String)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", (Object)"");
            if (args.length() != 0) {
                args = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(args);
                String[] argArray = CommandLineUtil.argumentsToArray((String)args);
                this.fCommandControl.queueCommand(this.fCommandControl.getCommandFactory().createMIGDBSetArgs(this.getContainerContext(), argArray), (DataRequestMonitor)new ImmediateDataRequestMonitor(rm));
            } else {
                rm.done();
            }
        }
        catch (CoreException e) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot get inferior arguments", (Throwable)e));
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepSetEnvironmentVariables(RequestMonitor rm) {
        boolean clear = false;
        Properties properties = new Properties();
        try {
            clear = this.fGDBBackend.getClearEnvironment();
            properties = this.fGDBBackend.getEnvironmentVariables();
        }
        catch (CoreException e) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot get environment information", (Throwable)e));
            rm.done();
            return;
        }
        if (clear || properties.size() > 0) {
            this.fCommandControl.setEnvironment(properties, clear, rm);
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepStartTrackingBreakpoints(RequestMonitor rm) {
        MIBreakpointsManager bpmService = (MIBreakpointsManager)this.fTracker.getService(MIBreakpointsManager.class);
        bpmService.startTrackingBpForProcess((IRunControl.IContainerDMContext)this.getContainerContext(), rm);
    }

    @ReflectionSequence.Execute
    public void stepSetProgramCounter(RequestMonitor rm) {
        if (((Boolean)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.setPcRegister", (Object)false)).booleanValue()) {
            String pcRegister = (String)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.pcRegister", (Object)((String)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.imageOffset", (Object)"")));
            ArrayList<String> commands = new ArrayList<String>();
            this.fGdbJtagDevice.doSetPC(pcRegister, commands);
            this.queueCommands(commands, rm);
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepStopScript(RequestMonitor rm) {
        if (((Boolean)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.setStopAt", (Object)false)).booleanValue()) {
            String stopAt = (String)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.stopAt", (Object)"");
            ArrayList<String> commands = new ArrayList<String>();
            this.fGdbJtagDevice.doStopAt(stopAt, commands);
            this.queueCommands(commands, rm);
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepResumeScript(RequestMonitor rm) {
        if (((Boolean)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.setResume", (Object)false)).booleanValue()) {
            ArrayList<String> commands = new ArrayList<String>();
            this.fGdbJtagDevice.doContinue(commands);
            this.queueCommands(commands, rm);
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepUserDebugCommands(RequestMonitor rm) {
        try {
            String userCmd = (String)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.runCommands", (Object)"");
            if (userCmd.length() > 0) {
                userCmd = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(userCmd);
                String[] commands = userCmd.split("\\r?\\n");
                CountingRequestMonitor crm = new CountingRequestMonitor((Executor)this.getExecutor(), rm);
                crm.setDoneCount(commands.length);
                int i = 0;
                while (i < commands.length) {
                    this.fCommandControl.queueCommand((ICommand)new CLICommand((IDMContext)this.fCommandControl.getContext(), commands[i]), new DataRequestMonitor((Executor)this.getExecutor(), (RequestMonitor)crm));
                    ++i;
                }
            } else {
                rm.done();
            }
        }
        catch (CoreException e) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.gdbjtag.core", -1, "Cannot run user defined run commands", (Throwable)e));
            rm.done();
        }
    }

    private IGDBJtagDevice getGDBJtagDevice() {
        GDBJtagDeviceContribution[] availableDevices;
        IGDBJtagDevice gdbJtagDevice = null;
        String jtagDeviceName = (String)CDebugUtils.getAttribute((Map)this.getAttributes(), (String)"org.eclipse.cdt.debug.gdbjtag.core.jtagDevice", (Object)"");
        GDBJtagDeviceContribution[] gDBJtagDeviceContributionArray = availableDevices = GDBJtagDeviceContributionFactory.getInstance().getGDBJtagDeviceContribution();
        int n = availableDevices.length;
        int n2 = 0;
        while (n2 < n) {
            GDBJtagDeviceContribution availableDevice = gDBJtagDeviceContributionArray[n2];
            if (jtagDeviceName.equals(availableDevice.getDeviceName())) {
                gdbJtagDevice = availableDevice.getDevice();
                break;
            }
            ++n2;
        }
        return gdbJtagDevice;
    }

    private String composeCommand(Collection<String> commands) {
        if (commands.isEmpty()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        Iterator<String> it = commands.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
        }
        return sb.toString();
    }

    @ReflectionSequence.Execute
    public void stepJTAGCleanup(RequestMonitor requestMonitor) {
        this.fTracker.dispose();
        this.fTracker = null;
        requestMonitor.done();
    }

    @ReflectionSequence.Execute
    public void stepInitializeMemory(RequestMonitor rm) {
        IGDBMemory memory = (IGDBMemory)this.fTracker.getService(IGDBMemory.class);
        IMemory.IMemoryDMContext memContext = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)this.getContainerContext(), IMemory.IMemoryDMContext.class);
        if (memory == null || memContext == null) {
            rm.done();
            return;
        }
        memory.initializeMemoryData(memContext, rm);
    }
}

