/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.debug.gdbjtag.datamodel;

import ilg.gnuarmeclipse.debug.gdbjtag.datamodel.SvdObjectDMNode;
import ilg.gnuarmeclipse.debug.gdbjtag.datamodel.SvdUtils;
import ilg.gnuarmeclipse.debug.gdbjtag.viewmodel.peripheral.PeripheralValue;
import ilg.gnuarmeclipse.packs.core.tree.Leaf;
import java.math.BigInteger;

public class SvdEnumeratedValueDMNode
extends SvdObjectDMNode {
    public SvdEnumeratedValueDMNode(Leaf node) {
        super(node);
    }

    public String getValue() {
        return this.getNode().getProperty("value");
    }

    public boolean isDefault() {
        String isDefault = this.getNode().getProperty("isDefault");
        if (isDefault.isEmpty()) {
            return false;
        }
        return "true".equalsIgnoreCase(isDefault);
    }

    public boolean isMatchForValue(PeripheralValue value) {
        BigInteger bigEnumerationValue = null;
        try {
            bigEnumerationValue = SvdUtils.parseScaledNonNegativeBigInteger(this.getValue());
            if (bigEnumerationValue.equals(value.getBigValue())) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public String toString() {
        String value = this.getValue();
        if (this.isDefault()) {
            value = "default";
        }
        return "[" + this.getClass().getSimpleName() + ": " + this.getName() + ", " + value + ", \"" + this.getDescription() + "\"]";
    }
}

