/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.debug.gdbjtag.datamodel;

import ilg.gnuarmeclipse.core.Xml;
import ilg.gnuarmeclipse.debug.gdbjtag.Activator;
import ilg.gnuarmeclipse.debug.gdbjtag.data.SVDPathManagerProxy;
import ilg.gnuarmeclipse.packs.core.ConsoleStream;
import ilg.gnuarmeclipse.packs.core.data.IPacksDataManager;
import ilg.gnuarmeclipse.packs.core.data.PacksDataManagerFactoryProxy;
import ilg.gnuarmeclipse.packs.core.data.SvdGenericParser;
import ilg.gnuarmeclipse.packs.core.tree.AbstractTreePreOrderIterator;
import ilg.gnuarmeclipse.packs.core.tree.Leaf;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.console.MessageConsoleStream;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SvdUtils {
    private static long computeScale(String str) {
        long scale = 1L;
        String lastChar = str.substring(str.length() - 1);
        if (lastChar.matches("[kmgtKMGT]")) {
            if ("k".equals(lastChar = lastChar.toLowerCase())) {
                scale = 1024L;
            } else if ("m".equals(lastChar)) {
                scale = 0x100000L;
            } else if ("g".equals(lastChar)) {
                scale = 0x40000000L;
            } else if ("7".equals(lastChar)) {
                scale = 0L;
            }
        }
        return scale;
    }

    private static String adjustForScale(String str, long scale) {
        if (scale != 1L) {
            return str.substring(0, str.length() - 2);
        }
        return str;
    }

    private static int computeRadix(String str) {
        int radix = 10;
        if (str.startsWith("0x") || str.startsWith("0X")) {
            radix = 16;
        } else if (str.startsWith("0b") || str.startsWith("0B")) {
            radix = 2;
        } else if (str.startsWith("#")) {
            radix = 2;
        }
        return radix;
    }

    private static String adjustForRadix(String str) {
        if (str.startsWith("0x") || str.startsWith("0X")) {
            return str.substring(2);
        }
        if (str.startsWith("0b") || str.startsWith("0B")) {
            return str.substring(2);
        }
        if (str.startsWith("#")) {
            return str.substring(1);
        }
        return str;
    }

    private static String adjustForSign(String str) {
        if (str.startsWith("+")) {
            return str.substring(1);
        }
        return str;
    }

    public static long parseScaledNonNegativeLong(String str) throws NumberFormatException {
        str = SvdUtils.adjustForSign(str);
        int radix = SvdUtils.computeRadix(str);
        str = SvdUtils.adjustForRadix(str);
        long scale = SvdUtils.computeScale(str);
        str = SvdUtils.adjustForScale(str, scale);
        long value = Long.parseLong(str, radix);
        if (scale != 1L) {
            value *= scale;
        }
        return value;
    }

    public static BigInteger parseScaledNonNegativeBigInteger(String str) throws NumberFormatException {
        str = SvdUtils.adjustForSign(str);
        int radix = SvdUtils.computeRadix(str);
        str = SvdUtils.adjustForRadix(str);
        long scale = SvdUtils.computeScale(str);
        str = SvdUtils.adjustForScale(str, scale);
        BigInteger value = new BigInteger(str, radix);
        if (scale != 1L) {
            value = value.multiply(new BigInteger(String.valueOf(scale)));
        }
        return value;
    }

    public static Leaf getTree(String deviceVendorId, String deviceName) throws CoreException {
        MessageConsoleStream out = ConsoleStream.getConsoleOut();
        IPath path = null;
        SVDPathManagerProxy pathManager = SVDPathManagerProxy.getInstance();
        path = pathManager.getSVDAbsolutePath(deviceVendorId, deviceName);
        if (path == null) {
            IPacksDataManager dataManager = PacksDataManagerFactoryProxy.getInstance().createDataManager();
            if (dataManager == null) {
                throw new CoreException((IStatus)new Status(4, "ilg.gnuarmeclipse.debug.gdbjtag", "Peripherals descriptions are available only via the Packs plug-in."));
            }
            path = dataManager.getSVDAbsolutePath(deviceVendorId, deviceName);
            if (path == null) {
                throw new CoreException((IStatus)new Status(4, "ilg.gnuarmeclipse.debug.gdbjtag", "There are no peripherals descriptions available, install the required packs."));
            }
        }
        try {
            out.println("Parsing SVD file \"" + path.toOSString() + "\"...");
            File file = path.toFile();
            if (file == null) {
                throw new IOException(path + " File object null.");
            }
            Document document = Xml.parseFile((File)file);
            SvdGenericParser parser = new SvdGenericParser();
            return parser.parse(document);
        }
        catch (ParserConfigurationException e) {
            Activator.log((Throwable)e);
            throw new CoreException((IStatus)new Status(4, "ilg.gnuarmeclipse.debug.gdbjtag", "Failed to get the peripherals descriptions.", (Throwable)e));
        }
        catch (SAXParseException e) {
            Activator.log((Throwable)e);
            String msg = "Failed to parse the peripherals descriptions, line: " + e.getLineNumber() + ", column: " + e.getColumnNumber() + ".";
            throw new CoreException((IStatus)new Status(4, "ilg.gnuarmeclipse.debug.gdbjtag", msg, (Throwable)e));
        }
        catch (SAXException e) {
            Activator.log((Throwable)e);
            throw new CoreException((IStatus)new Status(4, "ilg.gnuarmeclipse.debug.gdbjtag", "Failed to parse the peripherals descriptions.", (Throwable)e));
        }
        catch (IOException e) {
            Activator.log((Throwable)e);
            throw new CoreException((IStatus)new Status(4, "ilg.gnuarmeclipse.debug.gdbjtag", "Failed to get the peripherals descriptions.", (Throwable)e));
        }
    }

    public static List<Leaf> getPeripherals(Leaf tree) {
        LinkedList<Leaf> list = new LinkedList<Leaf>();
        if (tree != null) {
            class SvdPeriphIterator
            extends AbstractTreePreOrderIterator {
                SvdPeriphIterator() {
                }

                public boolean isIterable(Leaf node) {
                    return node.isType("peripheral");
                }

                public boolean isLeaf(Leaf node) {
                    return node.isType("peripheral");
                }
            }
            SvdPeriphIterator peripheralNodes = new SvdPeriphIterator();
            peripheralNodes.setTreeNode(tree);
            Iterator iterator = peripheralNodes.iterator();
            while (iterator.hasNext()) {
                Leaf peripheral = (Leaf)iterator.next();
                list.add(peripheral);
            }
            if (!list.isEmpty()) {
                return list;
            }
        }
        return list;
    }
}

