/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.debug.gdbjtag.dsf;

import ilg.gnuarmeclipse.core.EclipseUtils;
import ilg.gnuarmeclipse.debug.gdbjtag.Activator;
import ilg.gnuarmeclipse.debug.gdbjtag.DebugUtils;
import ilg.gnuarmeclipse.debug.gdbjtag.services.IGdbServerBackendService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.Hashtable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.gdb.service.command.GDBControl;
import org.eclipse.cdt.dsf.mi.service.IMIBackend;
import org.eclipse.cdt.dsf.mi.service.command.events.MIStoppedEvent;
import org.eclipse.cdt.dsf.service.AbstractDsfService;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.osgi.framework.BundleContext;

public abstract class GnuArmGdbServerBackend
extends AbstractDsfService
implements IGdbServerBackendService {
    protected final ILaunchConfiguration fLaunchConfiguration;
    protected boolean fDoStartGdbServer = true;
    protected Process fServerProcess;
    protected PushBackProcess fServerPipedProcess;
    protected GdbServerMonitorJob fServerMonitorJob;
    protected IMIBackend.State fServerBackendState = IMIBackend.State.NOT_INITIALIZED;
    private int fGdbServerExitValue = 0;
    protected IStatus fGdbServerExitStatus = null;
    private ScheduledFuture<?> fTimeoutFuture = null;
    private Job fStartGdbServerJob;
    private final String fBackendId;
    private static int fgInstanceCounter = 0;

    public GnuArmGdbServerBackend(DsfSession session, ILaunchConfiguration lc) {
        super(session);
        this.fLaunchConfiguration = lc;
        this.fBackendId = "gdbServer[" + Integer.toString(fgInstanceCounter++) + "]";
        if (Activator.getInstance().isDebugging()) {
            System.out.println("GnuArmGdbServerBackend(" + session + "," + lc.getName() + ")");
        }
    }

    public void initialize(final RequestMonitor rm) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("GnuArmGdbServerBackend.initialize()");
        }
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                GnuArmGdbServerBackend.this.doInitialize(rm);
            }
        });
    }

    private void doInitialize(RequestMonitor rm) {
        final Sequence.Step[] initializeSteps = this.fDoStartGdbServer ? new Sequence.Step[]{new RegisterStep(GDBControl.InitializationShutdownStep.Direction.INITIALIZING), new GdbServerStep(GDBControl.InitializationShutdownStep.Direction.INITIALIZING), new GdbServerMonitorStep(GDBControl.InitializationShutdownStep.Direction.INITIALIZING)} : new Sequence.Step[]{new RegisterStep(GDBControl.InitializationShutdownStep.Direction.INITIALIZING)};
        Sequence startupSequence = new Sequence(this.getExecutor(), rm){

            public Sequence.Step[] getSteps() {
                return initializeSteps;
            }
        };
        this.getExecutor().execute((Runnable)startupSequence);
    }

    public void shutdown(final RequestMonitor rm) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("GnuArmGdbServerBackend.shutdown()");
        }
        final Sequence.Step[] shutdownSteps = this.fDoStartGdbServer ? new Sequence.Step[]{new GdbServerMonitorStep(GDBControl.InitializationShutdownStep.Direction.SHUTTING_DOWN), new GdbServerStep(GDBControl.InitializationShutdownStep.Direction.SHUTTING_DOWN), new RegisterStep(GDBControl.InitializationShutdownStep.Direction.SHUTTING_DOWN)} : new Sequence.Step[]{new RegisterStep(GDBControl.InitializationShutdownStep.Direction.SHUTTING_DOWN)};
        Sequence startupSequence = new Sequence(this.getExecutor(), (RequestMonitor)new ImmediateRequestMonitor(rm){

            protected void handleSuccess() {
                GnuArmGdbServerBackend.super.shutdown(rm);
            }
        }){

            public Sequence.Step[] getSteps() {
                return shutdownSteps;
            }
        };
        this.getExecutor().execute((Runnable)startupSequence);
    }

    @Override
    public void destroy() {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("GnuArmGdbServerBackend.destroy() " + Thread.currentThread());
        }
        if (this.fStartGdbServerJob != null && this.fStartGdbServerJob.getThread() != null) {
            this.fStartGdbServerJob.getThread().interrupt();
        }
        if (this.getServerProcess() != null && this.getServerState() == IMIBackend.State.STARTED) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("GnuArmGdbServerBackend.destroy() fServerProcess " + this.fServerProcess);
            }
            this.getServerProcess().destroy();
        } else if (this.fServerProcess != null) {
            this.fServerProcess.destroy();
        }
        if (this.fTimeoutFuture != null) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("GnuArmGdbServerBackend.destroy() cancel timeout");
            }
            this.fTimeoutFuture.cancel(true);
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIStoppedEvent e) {
    }

    @DsfServiceEventHandler
    public void eventDispatched(IMIBackend.BackendStateChangedEvent e) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("GnuArmGdbServerBackend.eventDispatched() " + e);
        }
        if (this.fDoStartGdbServer) {
            if (e.getState() == IMIBackend.State.TERMINATED && e.getSessionId().equals(this.getSession().getId()) && this.getServerState() == IMIBackend.State.STARTED) {
                this.destroy();
            }
        } else {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("GnuArmGdbServerBackend.eventDispatched() -> dispatchEvent(ServerBackendStateChangedEvent, TERMINATED)");
            }
            this.getSession().dispatchEvent((Object)new IGdbServerBackendService.ServerBackendStateChangedEvent(this.getSession().getId(), this.getId(), IMIBackend.State.TERMINATED), this.getProperties());
        }
    }

    protected abstract BundleContext getBundleContext();

    public abstract String[] getServerCommandLineArray();

    public abstract int getServerLaunchTimeoutSeconds();

    public abstract String getServerName();

    public abstract String prepareMessageBoxText(int var1);

    public boolean canMatchStdOut() {
        return true;
    }

    public boolean matchStdOutExpectedPattern(String line) {
        return false;
    }

    public boolean canMatchStdErr() {
        return false;
    }

    public boolean matchStdErrExpectedPattern(String line) {
        return false;
    }

    public String getStartingServerJobName() {
        return "Starting " + this.getServerName();
    }

    public String getTerminatingServerJobName() {
        return "Terminating " + this.getServerName();
    }

    public String getMonitorServerJobName() {
        return String.valueOf(this.getServerName()) + " Monitor";
    }

    @Override
    public Process getServerProcess() {
        return this.fServerPipedProcess;
    }

    @Override
    public IMIBackend.State getServerState() {
        return this.fServerBackendState;
    }

    @Override
    public int getServerExitCode() {
        return this.fGdbServerExitValue;
    }

    @Override
    public IStatus getServerExitStatus() {
        return this.fGdbServerExitStatus;
    }

    @Override
    public String getId() {
        return this.fBackendId;
    }

    protected Process launchGdbServerProcess(String[] commandLineArray) throws CoreException {
        Process proc = null;
        File dir = null;
        IPath path = DebugUtils.getGdbWorkingDirectory(this.fLaunchConfiguration);
        if (path != null) {
            dir = new File(path.toOSString());
        }
        proc = DebugUtils.exec(commandLineArray, DebugUtils.getLaunchEnvironment(this.fLaunchConfiguration), dir);
        return proc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean checkServer(RequestMonitor serverLaunchRequestMonitor, IProgressMonitor monitor, StringBuffer outBuffer, StringBuffer errBuffer) {
        String str2;
        int count;
        byte[] b;
        boolean success;
        block29: {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("GnuArmGdbServerBackend.checkServer()");
            }
            success = false;
            if (this.canMatchStdOut()) {
                InputStream inputStream = null;
                try {
                    inputStream = this.fServerProcess.getInputStream();
                    b = new byte[1024];
                    while ((count = inputStream.read(b, 0, b.length)) != -1) {
                        str2 = new String(b, 0, count, "ascii");
                        if (Activator.getInstance().isDebugging()) {
                            System.out.print(str2);
                        }
                        outBuffer.append(new String(b, 0, count, "ascii"));
                        if (this.matchStdOutExpectedPattern(outBuffer.toString())) {
                            success = true;
                            break;
                        }
                        if (!serverLaunchRequestMonitor.isCanceled() && !monitor.isCanceled()) continue;
                        if (Activator.getInstance().isDebugging()) {
                            System.out.println("startGdbServerJob run canceled read");
                        }
                        serverLaunchRequestMonitor.setStatus((IStatus)new Status(8, "ilg.gnuarmeclipse.debug.gdbjtag", -1, String.valueOf(this.getStartingServerJobName()) + " cancelled.", null));
                        serverLaunchRequestMonitor.done();
                        return false;
                    }
                    if (success) {
                        try {
                            this.getExecutor().submit((Runnable)new DsfRunnable(){

                                public void run() {
                                    if (Activator.getInstance().isDebugging()) {
                                        System.out.println("startGdbServerJob run() State.STARTED");
                                    }
                                    GnuArmGdbServerBackend.this.fServerBackendState = IMIBackend.State.STARTED;
                                    if (GnuArmGdbServerBackend.this.fGdbServerExitStatus == null) {
                                        GnuArmGdbServerBackend.this.fGdbServerExitStatus = Status.OK_STATUS;
                                    }
                                }
                            }).get();
                        }
                        catch (InterruptedException str2) {
                        }
                        catch (ExecutionException e) {
                            Activator.log((Throwable)e);
                        }
                        break block29;
                    }
                    if (Activator.getInstance().isDebugging()) {
                        System.out.println("startGdbServerJob run() EOF stdout");
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e) {
                            Activator.log((Throwable)e);
                        }
                    }
                }
                catch (IOException e) {
                    success = false;
                    serverLaunchRequestMonitor.setStatus((IStatus)new Status(4, "ilg.gnuarmeclipse.debug.gdbjtag", -1, "Error reading " + this.getServerName() + " stdout", (Throwable)e));
                }
            }
        }
        if (!this.canMatchStdErr()) return success;
        InputStream errorStream = null;
        try {
            errorStream = this.fServerProcess.getErrorStream();
            b = new byte[1024];
            while ((count = errorStream.read(b, 0, b.length)) != -1) {
                str2 = new String(b, 0, count, "ascii");
                if (Activator.getInstance().isDebugging()) {
                    System.out.print(str2);
                }
                errBuffer.append(new String(b, 0, count, "ascii"));
                if (this.matchStdErrExpectedPattern(errBuffer.toString())) {
                    success = true;
                    break;
                }
                if (!serverLaunchRequestMonitor.isCanceled() && !monitor.isCanceled()) continue;
                if (Activator.getInstance().isDebugging()) {
                    System.out.println("startGdbServerJob run canceled read");
                }
                serverLaunchRequestMonitor.setStatus((IStatus)new Status(8, "ilg.gnuarmeclipse.debug.gdbjtag", -1, String.valueOf(this.getStartingServerJobName()) + " cancelled.", null));
                serverLaunchRequestMonitor.done();
                return false;
            }
            if (success) {
                try {
                    this.getExecutor().submit((Runnable)new DsfRunnable(){

                        public void run() {
                            if (Activator.getInstance().isDebugging()) {
                                System.out.println("startGdbServerJob run() State.STARTED");
                            }
                            GnuArmGdbServerBackend.this.fServerBackendState = IMIBackend.State.STARTED;
                            if (GnuArmGdbServerBackend.this.fGdbServerExitStatus == null) {
                                GnuArmGdbServerBackend.this.fGdbServerExitStatus = Status.OK_STATUS;
                            }
                        }
                    }).get();
                    return success;
                }
                catch (InterruptedException str3) {
                    return success;
                }
                catch (ExecutionException e) {
                    Activator.log((Throwable)e);
                    return success;
                }
            }
            if (Activator.getInstance().isDebugging()) {
                System.out.println("startGdbServerJob run() EOF stderr");
            }
            if (errorStream == null) return success;
            try {
                errorStream.close();
                return success;
            }
            catch (IOException e) {
                Activator.log((Throwable)e);
                return success;
            }
        }
        catch (IOException e) {
            success = false;
            serverLaunchRequestMonitor.setStatus((IStatus)new Status(4, "ilg.gnuarmeclipse.debug.gdbjtag", -1, "Error reading " + this.getServerName() + " stderr", (Throwable)e));
        }
        return success;
    }

    protected class GdbServerMonitorJob
    extends Job {
        boolean fMonitorExited;
        DsfRunnable fMonitorStarted;
        Process fProcess;

        public GdbServerMonitorJob(Process process, DsfRunnable monitorStarted) {
            super(GnuArmGdbServerBackend.this.getMonitorServerJobName());
            this.fMonitorExited = false;
            this.fProcess = process;
            this.fMonitorStarted = monitorStarted;
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            IStatus status = Status.OK_STATUS;
            Process process = this.fProcess;
            synchronized (process) {
                if (Activator.getInstance().isDebugging()) {
                    System.out.println("GdbServerMonitorJob.run() submit " + this.fMonitorStarted + " thread " + this.getThread());
                }
                try {
                    boolean mustNotify = false;
                    try {
                        GnuArmGdbServerBackend.this.fGdbServerExitValue = this.fProcess.exitValue();
                        mustNotify = true;
                    }
                    catch (IllegalThreadStateException e) {
                        GnuArmGdbServerBackend.this.getExecutor().submit((Runnable)this.fMonitorStarted);
                        this.fProcess.waitFor();
                        GnuArmGdbServerBackend.this.fGdbServerExitValue = this.fProcess.exitValue();
                    }
                    if (Activator.getInstance().isDebugging()) {
                        System.out.println("GdbServerMonitorJob.run() exitValue() " + GnuArmGdbServerBackend.this.fGdbServerExitValue);
                    }
                    if (GnuArmGdbServerBackend.this.fGdbServerExitValue != 0) {
                        final String message = GnuArmGdbServerBackend.this.prepareMessageBoxText(GnuArmGdbServerBackend.this.fGdbServerExitValue);
                        try {
                            GnuArmGdbServerBackend.this.getExecutor().submit((Runnable)new DsfRunnable(){

                                public void run() {
                                    if (Activator.getInstance().isDebugging()) {
                                        System.out.println("GdbServerMonitorJob.run() failed");
                                    }
                                    ((GdbServerMonitorJob)GdbServerMonitorJob.this).GnuArmGdbServerBackend.this.fGdbServerExitStatus = new Status(4, "ilg.gnuarmeclipse.debug.gdbjtag", message);
                                }
                            }).get();
                        }
                        catch (ExecutionException e) {
                            Activator.log((Throwable)e);
                        }
                    }
                    GnuArmGdbServerBackend.this.getExecutor().submit((Runnable)new DsfRunnable(){

                        public void run() {
                            if (Activator.getInstance().isDebugging()) {
                                System.out.println("GdbServerMonitorJob.run() run() thread " + GdbServerMonitorJob.this.getThread());
                            }
                            GdbServerMonitorJob.this.fProcess.destroy();
                            GnuArmGdbServerBackend.this.destroy();
                            if (Activator.getInstance().isDebugging()) {
                                System.out.println("GdbServerMonitorJob.run() run() State.TERMINATED");
                            }
                            if (((GdbServerMonitorJob)GdbServerMonitorJob.this).GnuArmGdbServerBackend.this.fGdbServerExitStatus == null) {
                                ((GdbServerMonitorJob)GdbServerMonitorJob.this).GnuArmGdbServerBackend.this.fGdbServerExitStatus = new Status(0, "ilg.gnuarmeclipse.debug.gdbjtag", "TERMINATED");
                            }
                            ((GdbServerMonitorJob)GdbServerMonitorJob.this).GnuArmGdbServerBackend.this.fServerBackendState = IMIBackend.State.TERMINATED;
                            if (Activator.getInstance().isDebugging()) {
                                System.out.println("GdbServerMonitorJob.run() run() dispatchEvent(ServerBackendStateChangedEvent, TERMINATED)");
                            }
                            GnuArmGdbServerBackend.this.getSession().dispatchEvent((Object)new IGdbServerBackendService.ServerBackendStateChangedEvent(GnuArmGdbServerBackend.this.getSession().getId(), GnuArmGdbServerBackend.this.getId(), IMIBackend.State.TERMINATED), GnuArmGdbServerBackend.this.getProperties());
                        }
                    });
                    if (mustNotify) {
                        GnuArmGdbServerBackend.this.getExecutor().submit((Runnable)this.fMonitorStarted);
                    }
                }
                catch (InterruptedException ie) {
                    Thread.interrupted();
                }
                if (Activator.getInstance().isDebugging()) {
                    System.out.println("GdbServerMonitorJob.run() fMonitorExited = true thread " + this.getThread());
                }
                this.fMonitorExited = true;
            }
            return status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void kill() {
            Process process = this.fProcess;
            synchronized (process) {
                if (!this.fMonitorExited) {
                    Thread thread = this.getThread();
                    if (thread != null) {
                        if (Activator.getInstance().isDebugging()) {
                            System.out.println("GdbServerMonitorJob.kill() interrupt " + thread.toString());
                        }
                        thread.interrupt();
                    } else {
                        Activator.log((String)"GdbServerMonitorJob.kill() null thread");
                    }
                }
            }
        }
    }

    protected class GdbServerMonitorStep
    extends GDBControl.InitializationShutdownStep {
        public GdbServerMonitorStep(GDBControl.InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        public void initialize(final RequestMonitor rm) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("GdbServerMonitorStep.initialize()");
            }
            GnuArmGdbServerBackend.this.fServerMonitorJob = new GdbServerMonitorJob(GnuArmGdbServerBackend.this.getServerProcess(), new DsfRunnable(){

                public void run() {
                    rm.done();
                }
            });
            GnuArmGdbServerBackend.this.fServerMonitorJob.schedule();
        }

        protected void shutdown(RequestMonitor rm) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("GdbServerMonitorStep.shutdown()");
            }
            if (GnuArmGdbServerBackend.this.fServerMonitorJob != null) {
                GnuArmGdbServerBackend.this.fServerMonitorJob.kill();
            }
            rm.done();
            if (Activator.getInstance().isDebugging()) {
                System.out.println("GdbServerMonitorStep.shutdown() done");
            }
        }
    }

    protected class GdbServerStep
    extends GDBControl.InitializationShutdownStep {
        public GdbServerStep(GDBControl.InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        public void initialize(final RequestMonitor rm) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("GdbServerStep.initialise()");
            }
            class ServerLaunchMonitor {
                boolean fIsTimeoutEnabled = true;
                boolean fWasTimeout = false;

                ServerLaunchMonitor() {
                }
            }
            final ServerLaunchMonitor fServerLaunchMonitor = new ServerLaunchMonitor();
            final RequestMonitor serverLaunchRequestMonitor = new RequestMonitor((Executor)GnuArmGdbServerBackend.this.getExecutor(), rm){
                {
                    super($anonymous0, $anonymous1);
                }

                protected void handleCompleted() {
                    if (Activator.getInstance().isDebugging()) {
                        System.out.println("GdbServerStep.initialise() handleCompleted()");
                    }
                    if (!fServerLaunchMonitor.fWasTimeout) {
                        fServerLaunchMonitor.fIsTimeoutEnabled = false;
                        if (!this.isSuccess()) {
                            rm.setStatus(this.getStatus());
                        }
                        rm.done();
                    }
                }
            };
            final Job startGdbServerJob = new Job(GnuArmGdbServerBackend.this.getStartingServerJobName()){
                {
                    super($anonymous0);
                    this.setSystem(true);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    if (Activator.getInstance().isDebugging()) {
                        System.out.println("GdbServerStep.initialise() Job run()");
                    }
                    if (serverLaunchRequestMonitor.isCanceled() || monitor.isCanceled()) {
                        if (Activator.getInstance().isDebugging()) {
                            System.out.println("startGdbServerJob run canceled");
                        }
                        serverLaunchRequestMonitor.setStatus((IStatus)new Status(8, "ilg.gnuarmeclipse.debug.gdbjtag", -1, String.valueOf(GnuArmGdbServerBackend.this.getStartingServerJobName()) + " cancelled.", null));
                        serverLaunchRequestMonitor.done();
                        return Status.OK_STATUS;
                    }
                    String[] commandLineArray = GnuArmGdbServerBackend.this.getServerCommandLineArray();
                    if (commandLineArray == null) {
                        serverLaunchRequestMonitor.setStatus((IStatus)new Status(4, "ilg.gnuarmeclipse.debug.gdbjtag", -1, String.valueOf(GnuArmGdbServerBackend.this.getStartingServerJobName()) + " failed, cannot get commnd line.", null));
                        serverLaunchRequestMonitor.done();
                        return Status.OK_STATUS;
                    }
                    try {
                        ((GdbServerStep)GdbServerStep.this).GnuArmGdbServerBackend.this.fServerProcess = GnuArmGdbServerBackend.this.launchGdbServerProcess(commandLineArray);
                    }
                    catch (CoreException e) {
                        serverLaunchRequestMonitor.setStatus((IStatus)new Status(4, "ilg.gnuarmeclipse.debug.gdbjtag", -1, e.getMessage(), (Throwable)e));
                        serverLaunchRequestMonitor.done();
                        return Status.OK_STATUS;
                    }
                    boolean success = false;
                    StringBuffer outBuffer = new StringBuffer();
                    StringBuffer errBuffer = new StringBuffer();
                    success = GnuArmGdbServerBackend.this.checkServer(serverLaunchRequestMonitor, monitor, outBuffer, errBuffer);
                    if (success || serverLaunchRequestMonitor.isSuccess()) {
                        ((GdbServerStep)GdbServerStep.this).GnuArmGdbServerBackend.this.fServerPipedProcess = new PushBackProcess(((GdbServerStep)GdbServerStep.this).GnuArmGdbServerBackend.this.fServerProcess, outBuffer, errBuffer);
                    }
                    if (!serverLaunchRequestMonitor.isCanceled()) {
                        serverLaunchRequestMonitor.done();
                    }
                    if (Activator.getInstance().isDebugging()) {
                        System.out.println("startGdbServerJob run completed");
                    }
                    return Status.OK_STATUS;
                }
            };
            GnuArmGdbServerBackend.this.fStartGdbServerJob = startGdbServerJob;
            startGdbServerJob.schedule();
            if (Activator.getInstance().isDebugging()) {
                System.out.println("GdbServerStep.initialise() after job schedule");
            }
            GnuArmGdbServerBackend.this.fTimeoutFuture = GnuArmGdbServerBackend.this.getExecutor().schedule(new Runnable(){
                {
                }

                @Override
                public void run() {
                    if (Activator.getInstance().isDebugging()) {
                        System.out.println("GdbServerStep.initialise() timeout run()");
                    }
                    if (fServerLaunchMonitor.fIsTimeoutEnabled) {
                        fServerLaunchMonitor.fWasTimeout = true;
                        Thread jobThread = startGdbServerJob.getThread();
                        if (jobThread != null) {
                            if (Activator.getInstance().isDebugging()) {
                                System.out.println("GdbServerStep.initialise() timeout interrupt thread " + jobThread);
                            }
                            jobThread.interrupt();
                        }
                        if (GnuArmGdbServerBackend.this.getServerProcess() != null) {
                            GnuArmGdbServerBackend.this.getServerProcess().destroy();
                        } else if (((GdbServerStep)GdbServerStep.this).GnuArmGdbServerBackend.this.fServerProcess != null) {
                            ((GdbServerStep)GdbServerStep.this).GnuArmGdbServerBackend.this.fServerProcess.destroy();
                        }
                        rm.setStatus((IStatus)new Status(4, "ilg.gnuarmeclipse.debug.gdbjtag", 5010, String.valueOf(GnuArmGdbServerBackend.this.getStartingServerJobName()) + " timed out.", null));
                        rm.done();
                    }
                }
            }, (long)GnuArmGdbServerBackend.this.getServerLaunchTimeoutSeconds(), TimeUnit.SECONDS);
            if (Activator.getInstance().isDebugging()) {
                System.out.println("GdbServerStep.initialise() return");
            }
        }

        protected void shutdown(final RequestMonitor rm) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("GdbServerStep.shutdown()");
            }
            if (GnuArmGdbServerBackend.this.fServerBackendState == IMIBackend.State.TERMINATED) {
                rm.done();
                return;
            }
            new Job(GnuArmGdbServerBackend.this.getTerminatingServerJobName()){
                {
                    super($anonymous0);
                    this.setSystem(true);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        if (Activator.getInstance().isDebugging()) {
                            System.out.println("GdbServerStep.shutdown() run()");
                        }
                        GnuArmGdbServerBackend.this.getExecutor().submit((Runnable)new DsfRunnable(){

                            public void run() {
                                if (Activator.getInstance().isDebugging()) {
                                    System.out.println("GdbServerStep.shutdown() run() run()");
                                }
                                GnuArmGdbServerBackend.this.destroy();
                                if (((GdbServerStep)(this).GdbServerStep.this).GnuArmGdbServerBackend.this.fServerMonitorJob != null && ((GdbServerStep)(this).GdbServerStep.this).GnuArmGdbServerBackend.this.fServerMonitorJob.fMonitorExited) {
                                    if (Activator.getInstance().isDebugging()) {
                                        System.out.println("GdbServerStep shutdown() run() run() State.TERMINATED");
                                    }
                                    ((GdbServerStep)(this).GdbServerStep.this).GnuArmGdbServerBackend.this.fServerBackendState = IMIBackend.State.TERMINATED;
                                    if (Activator.getInstance().isDebugging()) {
                                        System.out.println("GdbServerStep.shutdown() run() dispatchEvent(ServerBackendStateChangedEvent, TERMINATED)");
                                    }
                                    GnuArmGdbServerBackend.this.getSession().dispatchEvent((Object)new IGdbServerBackendService.ServerBackendStateChangedEvent(GnuArmGdbServerBackend.this.getSession().getId(), GnuArmGdbServerBackend.this.getId(), IMIBackend.State.TERMINATED), GnuArmGdbServerBackend.this.getProperties());
                                }
                            }
                        }).get();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (ExecutionException executionException) {
                        // empty catch block
                    }
                    if (Activator.getInstance().isDebugging()) {
                        System.out.println("GdbServerStep.shutdown() run() before getting exitValue");
                    }
                    int attempts = 0;
                    while (attempts < 10) {
                        try {
                            GnuArmGdbServerBackend.this.fGdbServerExitValue = ((GdbServerStep)GdbServerStep.this).GnuArmGdbServerBackend.this.fServerProcess.exitValue();
                            if (Activator.getInstance().isDebugging()) {
                                System.out.println("GdbServerStep shutdown() run() return");
                            }
                            rm.done();
                            return Status.OK_STATUS;
                        }
                        catch (IllegalThreadStateException illegalThreadStateException) {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            ++attempts;
                        }
                    }
                    if (Activator.getInstance().isDebugging()) {
                        System.out.println("GdbServerStep.shutdown() run() REQUEST_FAILED");
                    }
                    rm.setStatus((IStatus)new Status(4, "ilg.gnuarmeclipse.debug.gdbjtag", 10004, String.valueOf(GnuArmGdbServerBackend.this.getTerminatingServerJobName()) + " failed.", null));
                    rm.done();
                    return Status.OK_STATUS;
                }
            }.schedule();
            if (Activator.getInstance().isDebugging()) {
                System.out.println("GdbServerStep.shutdown() return");
            }
        }
    }

    protected class PushBackProcess
    extends Process {
        private Process fProcess;
        private PushbackInputStream fInput;
        private PushbackInputStream fError;

        public PushBackProcess(Process process, StringBuffer outBuffer, StringBuffer errBuffer) {
            byte[] b;
            if (Activator.getInstance().isDebugging()) {
                System.out.println("PushBackProcess(" + process + ")");
            }
            this.fProcess = process;
            if (outBuffer != null && outBuffer.length() > 0) {
                this.fInput = new PushbackInputStream(this.fProcess.getInputStream(), outBuffer.length() + 1);
                b = outBuffer.toString().getBytes();
                try {
                    this.fInput.unread(b);
                }
                catch (IOException e) {
                    Activator.log((Throwable)e);
                }
            }
            if (errBuffer != null && errBuffer.length() > 0) {
                this.fError = new PushbackInputStream(this.fProcess.getErrorStream(), errBuffer.length() + 1);
                b = errBuffer.toString().getBytes();
                try {
                    this.fError.unread(b);
                }
                catch (IOException e) {
                    Activator.log((Throwable)e);
                }
            }
        }

        @Override
        public void destroy() {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("PushBackProcess.destroy()");
            }
            this.fProcess.destroy();
        }

        @Override
        public int exitValue() {
            int intExit = this.fProcess.exitValue();
            if (EclipseUtils.isMacOSX() || EclipseUtils.isLinux()) {
                byte byteExit = (byte)intExit;
                intExit = byteExit;
            }
            return intExit;
        }

        @Override
        public InputStream getErrorStream() {
            if (this.fError != null) {
                return this.fError;
            }
            return this.fProcess.getErrorStream();
        }

        @Override
        public InputStream getInputStream() {
            if (this.fInput != null) {
                return this.fInput;
            }
            return this.fProcess.getInputStream();
        }

        @Override
        public OutputStream getOutputStream() {
            return this.fProcess.getOutputStream();
        }

        @Override
        public int waitFor() throws InterruptedException {
            return this.fProcess.waitFor();
        }
    }

    protected class RegisterStep
    extends GDBControl.InitializationShutdownStep {
        RegisterStep(GDBControl.InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        public void initialize(RequestMonitor rm) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("register " + GnuArmGdbServerBackend.this.getClass().getName());
            }
            GnuArmGdbServerBackend.this.register(new String[]{IGdbServerBackendService.class.getName(), GnuArmGdbServerBackend.this.getClass().getName()}, new Hashtable());
            GnuArmGdbServerBackend.this.getSession().addServiceEventListener((Object)GnuArmGdbServerBackend.this, null);
            GnuArmGdbServerBackend.this.getSession().dispatchEvent((Object)new IGdbServerBackendService.ServerBackendStateChangedEvent(GnuArmGdbServerBackend.this.getSession().getId(), GnuArmGdbServerBackend.this.getId(), IMIBackend.State.STARTED), GnuArmGdbServerBackend.this.getProperties());
            rm.done();
        }

        protected void shutdown(RequestMonitor rm) {
            GnuArmGdbServerBackend.this.unregister();
            GnuArmGdbServerBackend.this.getSession().removeServiceEventListener((Object)GnuArmGdbServerBackend.this);
            rm.done();
        }
    }
}

