/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.debug.gdbjtag.services;

import ilg.gnuarmeclipse.core.EclipseUtils;
import ilg.gnuarmeclipse.debug.gdbjtag.Activator;
import ilg.gnuarmeclipse.debug.gdbjtag.ILaunchConfigurationProvider;
import ilg.gnuarmeclipse.debug.gdbjtag.data.CProjectExtraDataManagerProxy;
import ilg.gnuarmeclipse.debug.gdbjtag.datamodel.IPeripheralDMContext;
import ilg.gnuarmeclipse.debug.gdbjtag.datamodel.PeripheralDMContext;
import ilg.gnuarmeclipse.debug.gdbjtag.datamodel.PeripheralDMNode;
import ilg.gnuarmeclipse.debug.gdbjtag.datamodel.SvdUtils;
import ilg.gnuarmeclipse.debug.gdbjtag.services.IPeripheralsService;
import ilg.gnuarmeclipse.packs.core.tree.Leaf;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.service.AbstractDsfService;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.osgi.framework.BundleContext;

public class PeripheralsService
extends AbstractDsfService
implements IPeripheralsService {
    private ICommandControlService fCommandControl;
    private PeripheralDMContext[] fPeripheralsDMContexts = null;

    public PeripheralsService(DsfSession session) {
        super(session);
    }

    public void initialize(final RequestMonitor rm) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("PeripheralsService.initialize()");
        }
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                PeripheralsService.this.doInitialize(rm);
            }
        });
    }

    private void doInitialize(RequestMonitor rm) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("PeripheralsService.doInitialize()");
        }
        this.fCommandControl = (ICommandControlService)this.getServicesTracker().getService(ICommandControlService.class);
        this.register(new String[]{IPeripheralsService.class.getName(), PeripheralsService.class.getName()}, new Hashtable());
        if (Activator.getInstance().isDebugging()) {
            System.out.println("PeripheralsService registered " + this);
        }
        rm.done();
    }

    public void shutdown(RequestMonitor rm) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("PeripheralsService.shutdown()");
        }
        this.unregister();
        super.shutdown(rm);
    }

    protected BundleContext getBundleContext() {
        return Activator.getInstance().getBundle().getBundleContext();
    }

    @Override
    public void getPeripherals(IRunControl.IContainerDMContext containerDMContext, DataRequestMonitor<IPeripheralDMContext[]> drm) {
        ILaunchConfiguration launchConfiguration;
        ICConfigurationDescription cConfigDescription;
        if (Activator.getInstance().isDebugging()) {
            System.out.println("PeripheralsService.getPeripherals()");
        }
        if (this.fPeripheralsDMContexts != null) {
            drm.setData((Object)this.fPeripheralsDMContexts);
            drm.done();
            return;
        }
        if (this.fCommandControl instanceof ILaunchConfigurationProvider && (cConfigDescription = EclipseUtils.getBuildConfigDescription((ILaunchConfiguration)(launchConfiguration = ((ILaunchConfigurationProvider)this.fCommandControl).getLaunchConfiguration()))) != null) {
            IConfiguration config = EclipseUtils.getConfigurationFromDescription((ICConfigurationDescription)cConfigDescription);
            if (Activator.getInstance().isDebugging()) {
                System.out.println(config);
            }
            try {
                String vendorId = null;
                String deviceName = null;
                CProjectExtraDataManagerProxy dataManager = CProjectExtraDataManagerProxy.getInstance();
                Map<String, String> propertiesMap = dataManager.getExtraProperties(config);
                if (propertiesMap != null) {
                    vendorId = propertiesMap.get("cmsis.device.vendor.id");
                    deviceName = propertiesMap.get("cmsis.device.name");
                }
                if (vendorId != null && deviceName != null) {
                    Leaf tree = SvdUtils.getTree(vendorId, deviceName);
                    List<Leaf> list = SvdUtils.getPeripherals(tree);
                    this.fPeripheralsDMContexts = this.createPeripheralsContexts((IDMContext)containerDMContext, list);
                    drm.setData((Object)this.fPeripheralsDMContexts);
                    drm.done();
                    return;
                }
                drm.setStatus((IStatus)new Status(4, "ilg.gnuarmeclipse.debug.gdbjtag", "There are no peripheral descriptions available, assign a device to the project."));
                drm.done();
                return;
            }
            catch (CoreException e) {
                drm.setStatus(e.getStatus());
                drm.done();
                return;
            }
        }
        drm.setStatus((IStatus)new Status(4, "ilg.gnuarmeclipse.debug.gdbjtag", "No peripherals available."));
        drm.done();
    }

    private PeripheralDMContext[] createPeripheralsContexts(IDMContext parentIDMContext, List<Leaf> list) {
        Object[] contexts = new PeripheralDMContext[list.size()];
        IDMContext[] parents = parentIDMContext != null ? new IDMContext[]{parentIDMContext} : new IDMContext[]{};
        int i = 0;
        for (Leaf child : list) {
            PeripheralDMNode node = new PeripheralDMNode(child);
            contexts[i] = new PeripheralDMContext(this.getSession(), parents, node);
            ++i;
        }
        Arrays.sort(contexts);
        return contexts;
    }
}

