/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.debug.gdbjtag.viewmodel.peripheral;

import ilg.gnuarmeclipse.debug.gdbjtag.Activator;
import ilg.gnuarmeclipse.debug.gdbjtag.datamodel.SvdDMNode;
import ilg.gnuarmeclipse.debug.gdbjtag.viewmodel.peripheral.PeripheralRegisterVMNode;
import ilg.gnuarmeclipse.debug.gdbjtag.viewmodel.peripheral.PeripheralTreeVMNode;
import java.math.BigInteger;
import java.util.ArrayList;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegister;
import org.eclipse.debug.core.model.IRegisterGroup;

public class PeripheralGroupVMNode
extends PeripheralTreeVMNode
implements IRegisterGroup {
    private ArrayList<PeripheralRegisterVMNode> fRegisters;

    public PeripheralGroupVMNode(PeripheralTreeVMNode parent, SvdDMNode dmNode) {
        super(parent, dmNode);
    }

    @Override
    protected void addChild(PeripheralTreeVMNode child) {
        super.addChild(child);
        if (child instanceof PeripheralRegisterVMNode) {
            if (this.fRegisters == null) {
                this.fRegisters = new ArrayList();
            }
            this.fRegisters.add((PeripheralRegisterVMNode)child);
        }
    }

    public void update() {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("update() unimplemented");
        }
    }

    public void update(String str) {
    }

    @Override
    public String getDisplayNodeType() {
        return "Group";
    }

    @Override
    public String getImageName() {
        return "registergroup_obj";
    }

    @Override
    public String getDisplaySize() {
        BigInteger bigSize = this.getBigSize();
        if (bigSize != null) {
            long size = bigSize.longValue();
            if (size == 1L) {
                return "1 byte";
            }
            if (size > 1L) {
                if (size < 65536L) {
                    return String.format("0x%04x bytes", size);
                }
                return String.format("0x%08x bytes", size);
            }
        }
        return null;
    }

    public IRegister[] getRegisters() throws DebugException {
        return this.fRegisters.toArray(new PeripheralRegisterVMNode[this.fRegisters.size()]);
    }

    public boolean hasRegisters() throws DebugException {
        return this.fRegisters != null && !this.fRegisters.isEmpty();
    }
}

