/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.graphing.ui.charts;

import org.eclipse.linuxtools.dataviewers.piechart.PieChart;
import org.eclipse.linuxtools.internal.systemtap.graphing.ui.charts.AbstractChartWithoutAxisBuilder;
import org.eclipse.linuxtools.internal.systemtap.graphing.ui.charts.listeners.PieChartMouseMoveListener;
import org.eclipse.linuxtools.systemtap.graphing.core.adapters.IAdapter;
import org.eclipse.swt.widgets.Composite;
import org.swtchart.IAxis;
import org.swtchart.Range;

public class PieChartBuilder
extends AbstractChartWithoutAxisBuilder {
    public static final String ID = "org.eclipse.linuxtools.systemtap.graphing.ui.charts.piechartbuilder";

    public PieChartBuilder(Composite parent, int style, String title, IAdapter adapter) {
        super(adapter, parent, style, title);
    }

    @Override
    protected void createChart() {
        this.chart = new PieChart((Composite)this, this.getStyle());
        ((PieChart)this.chart).setCustomColors(COLORS);
        this.chartMouseMoveListener = new PieChartMouseMoveListener((PieChart)this.chart, (Composite)this.chart);
    }

    @Override
    protected void buildXAxis() {
        String[] labels = this.adapter.getLabels();
        String[] seriesLabels = new String[labels.length - 1];
        int i = 0;
        while (i < seriesLabels.length) {
            seriesLabels[i] = labels[i + 1];
            ++i;
        }
        IAxis xAxis = this.chart.getAxisSet().getXAxis(0);
        xAxis.getTitle().setText(labels[0]);
        xAxis.setCategorySeries(seriesLabels);
    }

    @Override
    protected void buildXSeries() {
        Object[][] data = this.adapter.getData();
        if (data == null || data.length == 0) {
            return;
        }
        int start = 0;
        int len = Math.min(this.maxItems, data.length);
        int leny = data[0].length - 1;
        if (this.maxItems < data.length) {
            start = data.length - this.maxItems;
        }
        Double[][] all_values = new Double[len][leny];
        String[] all_labels = new String[len];
        int i = 0;
        while (i < all_labels.length) {
            Object label = data[start + i][0];
            if (label != null) {
                all_labels[i] = label.toString();
                int j = 1;
                while (j < data[start + i].length) {
                    Double val = this.getDoubleOrNullValue(data[start + i][j]);
                    all_values[i][j - 1] = val != null && val >= 0.0 ? val : Double.valueOf(0.0);
                    ++j;
                }
            }
            ++i;
        }
        double[][] values = new double[len][leny];
        String[] labels = new String[len];
        int len_trim = 0;
        int i2 = 0;
        while (i2 < len) {
            if (all_labels[i2] != null) {
                labels[len_trim] = all_labels[i2];
                int j = 0;
                while (j < leny) {
                    values[len_trim][j] = all_values[i2][j];
                    ++j;
                }
                ++len_trim;
            }
            ++i2;
        }
        double[][] values_trim = new double[len_trim][leny];
        String[] labels_trim = new String[len_trim];
        int i3 = 0;
        while (i3 < len_trim) {
            labels_trim[i3] = labels[i3];
            int j = 0;
            while (j < leny) {
                values_trim[i3][j] = values[i3][j];
                ++j;
            }
            ++i3;
        }
        ((PieChart)this.chart).addPieChartSeries(this.getUniqueNames(labels_trim), values_trim);
        this.applyCategoryRange(values_trim[0].length);
        this.chart.redraw();
    }

    private void applyCategoryRange(int numItems) {
        int itemRange = Math.max(1, (int)Math.ceil((double)numItems * this.scale));
        int lower = (int)Math.round((double)(numItems - itemRange) * this.scroll);
        this.chart.getAxisSet().getXAxis(0).setRange(new Range((double)lower, (double)(lower + itemRange - 1)));
    }

    @Override
    public void updateDataSet() {
        this.buildXSeries();
        this.chartMouseMoveListener.update();
    }

    @Override
    protected void buildYAxis() {
    }

    @Override
    protected void buildYSeries() {
    }
}

