/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.packs.ui.views;

import ilg.gnuarmeclipse.packs.core.Preferences;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CopyExampleDialog
extends Dialog {
    private TreeSelection fSelection;
    private Text fFolderText;
    private String fOutputFolder;
    private String fInputFolder;
    private Button fBrowseButton;

    public CopyExampleDialog(Shell parentShell, TreeSelection selection) {
        super(parentShell);
        this.fSelection = selection;
        String folderPath = Preferences.getPreferenceStore().getString("packs.folder.path");
        this.fOutputFolder = this.fInputFolder = new Path(folderPath).append("../Examples/").toOSString();
    }

    public String[] getData() {
        return new String[]{this.fOutputFolder};
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        String s = "Copy ";
        s = this.fSelection.size() == 1 ? String.valueOf(s) + "example" : String.valueOf(s) + this.fSelection.size() + " examples";
        s = String.valueOf(s) + " to folder";
        shell.setText(s);
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginTop = 10;
        layout.marginBottom = 10;
        layout.marginWidth = 11;
        comp.setLayout((Layout)layout);
        GridData layoutData = new GridData();
        layoutData.widthHint = 600;
        layoutData.verticalAlignment = 4;
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        comp.setLayoutData((Object)layoutData);
        Label folderLabel = new Label(comp, 16384);
        folderLabel.setText("Folder:");
        layoutData = new GridData();
        folderLabel.setLayoutData((Object)layoutData);
        this.fFolderText = new Text(comp, 2052);
        this.fFolderText.setText(this.fInputFolder);
        layoutData = new GridData();
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        this.fFolderText.setLayoutData((Object)layoutData);
        this.fBrowseButton = new Button(comp, 8);
        this.fBrowseButton.setText("Browse...");
        layoutData = new GridData();
        layoutData.verticalAlignment = 0x1000000;
        layoutData.grabExcessHorizontalSpace = false;
        layoutData.horizontalAlignment = 4;
        this.fBrowseButton.setLayoutData((Object)layoutData);
        this.fFolderText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CopyExampleDialog.this.fOutputFolder = CopyExampleDialog.this.fFolderText.getText().trim();
            }
        });
        this.fBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog dialog = new DirectoryDialog(CopyExampleDialog.this.getShell(), 8192);
                dialog.setText("Destination folder");
                String str = dialog.open();
                if (str != null) {
                    CopyExampleDialog.this.fFolderText.setText(str.trim());
                }
            }
        });
        return comp;
    }
}

