/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.packs.cmsis;

import ilg.gnuarmeclipse.packs.core.ConsoleStream;
import ilg.gnuarmeclipse.packs.data.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.console.MessageConsoleStream;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PdscParser {
    protected MessageConsoleStream fOut = ConsoleStream.getConsoleOut();
    protected IPath fPath;
    protected Document fDocument;

    public void setDocument(Document document) {
        this.fDocument = document;
    }

    public Document getDocument() {
        return this.fDocument;
    }

    protected String extendDescription(String description, String value) {
        return this.extendDescription(description, null, value);
    }

    protected String extendDescription(String description, String comment, String value) {
        if (value.length() > 0) {
            if (description.length() > 0) {
                description = String.valueOf(description) + "\n";
            }
            if (comment != null && comment.length() > 0) {
                description = String.valueOf(description) + comment + ": ";
            }
            description = String.valueOf(description) + value;
        }
        return description;
    }

    protected String extendName(String name, String value) {
        if (value.length() > 0) {
            if (name.length() > 0) {
                name = String.valueOf(name) + " / ";
            }
            name = String.valueOf(name) + value;
        }
        return name;
    }

    protected String updatePosixSeparators(String spath) {
        return spath.replace('\\', '/');
    }

    public Document parseXml(IPath path) throws ParserConfigurationException, SAXException, IOException {
        File file = path.toFile();
        if (file == null) {
            throw new FileNotFoundException(path.toFile().toString());
        }
        this.fPath = path;
        InputSource inputSource = new InputSource(new FileInputStream(file));
        DocumentBuilder xml = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        this.fDocument = xml.parse(inputSource);
        return this.fDocument;
    }

    public Document parseXml(File file) throws ParserConfigurationException, SAXException, IOException {
        this.fPath = new Path(file.getPath());
        InputSource inputSource = new InputSource(new FileInputStream(file));
        DocumentBuilder xml = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        this.fDocument = xml.parse(inputSource);
        return this.fDocument;
    }

    public Document parseXml(URL url) throws IOException, ParserConfigurationException, SAXException {
        long beginTime = System.currentTimeMillis();
        this.fOut.println("Fetching & parsing \"" + url + " ...");
        InputStream is = Utils.checkForUtf8BOM(url.openStream());
        InputSource inputSource = new InputSource(new InputStreamReader(is));
        DocumentBuilder xml = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        this.fDocument = xml.parse(inputSource);
        long endTime = System.currentTimeMillis();
        long duration = endTime - beginTime;
        if (duration == 0L) {
            duration = 1L;
        }
        this.fOut.println("Completed in " + duration + "ms.");
        return this.fDocument;
    }
}

