/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.linuxtools.internal.perf.IPerfData;
import org.eclipse.linuxtools.internal.perf.PerfPlugin;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class StatView
extends ViewPart {
    private StyledText text;

    public void createPartControl(Composite parent) {
        parent.setLayoutData((Object)new GridLayout(1, true));
        this.text = new StyledText(parent, 768);
        this.text.setEditable(false);
        IPerfData data = PerfPlugin.getDefault().getStatData();
        if (data != null) {
            this.setStyledText(data.getPerfData());
            this.setContentDescription(data.getTitle());
        }
    }

    public void setFocus() {
    }

    private void setStyledText(String input) {
        this.text.setText(input);
        this.text.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
    }

    private void updateData() {
        IPerfData data = PerfPlugin.getDefault().getStatData();
        if (data != null) {
            this.setStyledText(data.getPerfData());
            this.setContentDescription(data.getTitle());
        }
    }

    public static void refreshView() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    StatView view = (StatView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.linuxtools.perf.ui.StatView");
                    view.updateData();
                }
                catch (PartInitException e) {
                    Status status = new Status(4, "org.eclipse.linuxtools.perf", e.getMessage(), (Throwable)e);
                    PerfPlugin.getDefault().getLog().log((IStatus)status);
                }
            }
        });
    }
}

