/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.statesystem.backends.partial;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.tracecompass.internal.statesystem.core.AttributeTree;
import org.eclipse.tracecompass.internal.statesystem.core.StateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.backend.StateHistoryBackendFactory;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;

public class PartialStateSystem
extends StateSystem {
    private static final String ERR_MSG = "Partial state system should not modify the attribute tree!";
    private final CountDownLatch ssAssignedLatch = new CountDownLatch(1);
    private final Lock queryLock = new ReentrantLock();
    private StateSystem realStateSystem = null;

    public PartialStateSystem() {
        super(StateHistoryBackendFactory.createNullBackend((String)"partial"));
    }

    public void assignUpstream(StateSystem ss) {
        this.realStateSystem = ss;
        this.ssAssignedLatch.countDown();
    }

    ITmfStateSystem getUpstreamSS() {
        return this.realStateSystem;
    }

    public void replaceOngoingState(List<ITmfStateInterval> ongoingIntervals) {
        super.replaceOngoingState(ongoingIntervals);
    }

    public synchronized void dispose() {
        super.dispose();
    }

    public void takeQueryLock() {
        try {
            this.queryLock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void releaseQueryLock() {
        this.queryLock.unlock();
    }

    public AttributeTree getAttributeTree() {
        this.waitUntilReady();
        return this.realStateSystem.getAttributeTree();
    }

    public void addEmptyAttribute() {
        throw new RuntimeException(ERR_MSG);
    }

    public int getQuarkAbsoluteAndAdd(String ... attribute) {
        this.waitUntilReady();
        try {
            return this.realStateSystem.getQuarkAbsolute(attribute);
        }
        catch (AttributeNotFoundException e) {
            throw new RuntimeException(ERR_MSG);
        }
    }

    public int getQuarkRelativeAndAdd(int startingNodeQuark, String ... subPath) {
        this.waitUntilReady();
        try {
            return this.realStateSystem.getQuarkRelative(startingNodeQuark, subPath);
        }
        catch (AttributeNotFoundException e) {
            throw new RuntimeException(ERR_MSG);
        }
    }

    private void waitUntilReady() {
        try {
            this.ssAssignedLatch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

