/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.signal;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.tracecompass.tmf.core.component.ITmfComponent;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;

public class TmfSignalThrottler {
    private final ITmfComponent fComponent;
    private final long fDelay;
    private final Timer fTimer;
    private TimerTask fCurrentTask;

    public TmfSignalThrottler(ITmfComponent component, long delay) {
        this.fComponent = component;
        this.fDelay = delay;
        this.fTimer = new Timer();
        this.fCurrentTask = new TimerTask(){

            @Override
            public void run() {
            }
        };
    }

    public synchronized void queue(TmfSignal signal) {
        this.fCurrentTask.cancel();
        this.fCurrentTask = new BroadcastRequest(signal);
        this.fTimer.schedule(this.fCurrentTask, this.fDelay);
    }

    public synchronized void dispose() {
        this.fTimer.cancel();
        this.fTimer.purge();
    }

    private class BroadcastRequest
    extends TimerTask {
        private final TmfSignal signal;

        BroadcastRequest(TmfSignal signal) {
            this.signal = signal;
        }

        @Override
        public void run() {
            TmfSignalThrottler.this.fComponent.broadcast(this.signal);
        }
    }
}

