/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodRef;
import java.beans.NameGenerator;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.Transient;
import java.lang.ref.Reference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import sun.reflect.misc.ReflectUtil;

public class PropertyDescriptor
extends FeatureDescriptor {
    private Reference<? extends Class<?>> propertyTypeRef;
    private final MethodRef readMethodRef = new MethodRef();
    private final MethodRef writeMethodRef = new MethodRef();
    private Reference<? extends Class<?>> propertyEditorClassRef;
    private boolean bound;
    private boolean constrained;
    private String baseName;
    private String writeMethodName;
    private String readMethodName;

    public PropertyDescriptor(String propertyName, Class<?> beanClass) throws IntrospectionException {
        this(propertyName, beanClass, "is" + NameGenerator.capitalize(propertyName), "set" + NameGenerator.capitalize(propertyName));
    }

    public PropertyDescriptor(String propertyName, Class<?> beanClass, String readMethodName, String writeMethodName) throws IntrospectionException {
        if (beanClass == null) {
            throw new IntrospectionException("Target Bean class is null");
        }
        if (propertyName == null || propertyName.length() == 0) {
            throw new IntrospectionException("bad property name");
        }
        if ("".equals(readMethodName) || "".equals(writeMethodName)) {
            throw new IntrospectionException("read or write method name should not be the empty string");
        }
        this.setName(propertyName);
        this.setClass0(beanClass);
        this.readMethodName = readMethodName;
        if (readMethodName != null && this.getReadMethod() == null) {
            throw new IntrospectionException("Method not found: " + readMethodName);
        }
        this.writeMethodName = writeMethodName;
        if (writeMethodName != null && this.getWriteMethod() == null) {
            throw new IntrospectionException("Method not found: " + writeMethodName);
        }
        Class[] args = new Class[]{PropertyChangeListener.class};
        this.bound = null != Introspector.findMethod(beanClass, "addPropertyChangeListener", args.length, args);
    }

    public PropertyDescriptor(String propertyName, Method readMethod, Method writeMethod) throws IntrospectionException {
        if (propertyName == null || propertyName.length() == 0) {
            throw new IntrospectionException("bad property name");
        }
        this.setName(propertyName);
        this.setReadMethod(readMethod);
        this.setWriteMethod(writeMethod);
    }

    PropertyDescriptor(Class<?> bean, String base, Method read, Method write) throws IntrospectionException {
        if (bean == null) {
            throw new IntrospectionException("Target Bean class is null");
        }
        this.setClass0(bean);
        this.setName(Introspector.decapitalize(base));
        this.setReadMethod(read);
        this.setWriteMethod(write);
        this.baseName = base;
    }

    public synchronized Class<?> getPropertyType() {
        Class<?> type = this.getPropertyType0();
        if (type == null) {
            try {
                type = this.findPropertyType(this.getReadMethod(), this.getWriteMethod());
                this.setPropertyType(type);
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
        }
        return type;
    }

    private void setPropertyType(Class<?> type) {
        this.propertyTypeRef = PropertyDescriptor.getWeakReference(type);
    }

    private Class<?> getPropertyType0() {
        return this.propertyTypeRef != null ? this.propertyTypeRef.get() : null;
    }

    public synchronized Method getReadMethod() {
        Method readMethod = this.readMethodRef.get();
        if (readMethod == null) {
            Class<?> cls = this.getClass0();
            if (cls == null || this.readMethodName == null && !this.readMethodRef.isSet()) {
                return null;
            }
            String nextMethodName = "get" + this.getBaseName();
            if (this.readMethodName == null) {
                Class<?> type = this.getPropertyType0();
                this.readMethodName = type == Boolean.TYPE || type == null ? "is" + this.getBaseName() : nextMethodName;
            }
            if ((readMethod = Introspector.findMethod(cls, this.readMethodName, 0)) == null && !this.readMethodName.equals(nextMethodName)) {
                this.readMethodName = nextMethodName;
                readMethod = Introspector.findMethod(cls, this.readMethodName, 0);
            }
            try {
                this.setReadMethod(readMethod);
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
        }
        return readMethod;
    }

    public synchronized void setReadMethod(Method readMethod) throws IntrospectionException {
        this.readMethodRef.set(readMethod);
        if (readMethod == null) {
            this.readMethodName = null;
            return;
        }
        this.setPropertyType(this.findPropertyType(readMethod, this.writeMethodRef.get()));
        this.setClass0(readMethod.getDeclaringClass());
        this.readMethodName = readMethod.getName();
        this.setTransient(readMethod.getAnnotation(Transient.class));
    }

    public synchronized Method getWriteMethod() {
        Method writeMethod = this.writeMethodRef.get();
        if (writeMethod == null) {
            Class[] classArray;
            Class<?> cls = this.getClass0();
            if (cls == null || this.writeMethodName == null && !this.writeMethodRef.isSet()) {
                return null;
            }
            Class<?> type = this.getPropertyType0();
            if (type == null) {
                try {
                    type = this.findPropertyType(this.getReadMethod(), null);
                    this.setPropertyType(type);
                }
                catch (IntrospectionException ex) {
                    return null;
                }
            }
            if (this.writeMethodName == null) {
                this.writeMethodName = "set" + this.getBaseName();
            }
            if (type == null) {
                classArray = null;
            } else {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = type;
            }
            Class[] args = classArray;
            writeMethod = Introspector.findMethod(cls, this.writeMethodName, 1, args);
            if (writeMethod != null && !writeMethod.getReturnType().equals(Void.TYPE)) {
                writeMethod = null;
            }
            try {
                this.setWriteMethod(writeMethod);
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
        }
        return writeMethod;
    }

    public synchronized void setWriteMethod(Method writeMethod) throws IntrospectionException {
        this.writeMethodRef.set(writeMethod);
        if (writeMethod == null) {
            this.writeMethodName = null;
            return;
        }
        this.setPropertyType(this.findPropertyType(this.getReadMethod(), writeMethod));
        this.setClass0(writeMethod.getDeclaringClass());
        this.writeMethodName = writeMethod.getName();
        this.setTransient(writeMethod.getAnnotation(Transient.class));
    }

    @Override
    void setClass0(Class<?> clz) {
        if (this.getClass0() != null && clz.isAssignableFrom(this.getClass0())) {
            return;
        }
        super.setClass0(clz);
    }

    public boolean isBound() {
        return this.bound;
    }

    public void setBound(boolean bound) {
        this.bound = bound;
    }

    public boolean isConstrained() {
        return this.constrained;
    }

    public void setConstrained(boolean constrained) {
        this.constrained = constrained;
    }

    public void setPropertyEditorClass(Class<?> propertyEditorClass) {
        this.propertyEditorClassRef = PropertyDescriptor.getWeakReference(propertyEditorClass);
    }

    public Class<?> getPropertyEditorClass() {
        return this.propertyEditorClassRef != null ? this.propertyEditorClassRef.get() : null;
    }

    public PropertyEditor createPropertyEditor(Object bean) {
        Object editor = null;
        Class<?> cls = this.getPropertyEditorClass();
        if (cls != null && PropertyEditor.class.isAssignableFrom(cls) && ReflectUtil.isPackageAccessible(cls)) {
            Constructor<?> ctor = null;
            if (bean != null) {
                try {
                    ctor = cls.getConstructor(Object.class);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                editor = ctor == null ? cls.newInstance() : ctor.newInstance(bean);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return editor;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof PropertyDescriptor) {
            PropertyDescriptor other = (PropertyDescriptor)obj;
            Method otherReadMethod = other.getReadMethod();
            Method otherWriteMethod = other.getWriteMethod();
            if (!this.compareMethods(this.getReadMethod(), otherReadMethod)) {
                return false;
            }
            if (!this.compareMethods(this.getWriteMethod(), otherWriteMethod)) {
                return false;
            }
            if (this.getPropertyType() == other.getPropertyType() && this.getPropertyEditorClass() == other.getPropertyEditorClass() && this.bound == other.isBound() && this.constrained == other.isConstrained() && this.writeMethodName == other.writeMethodName && this.readMethodName == other.readMethodName) {
                return true;
            }
        }
        return false;
    }

    boolean compareMethods(Method a, Method b) {
        if (a == null != (b == null)) {
            return false;
        }
        return a == null || b == null || a.equals(b);
    }

    PropertyDescriptor(PropertyDescriptor x, PropertyDescriptor y) {
        super(x, y);
        this.baseName = y.baseName != null ? y.baseName : x.baseName;
        this.readMethodName = y.readMethodName != null ? y.readMethodName : x.readMethodName;
        this.writeMethodName = y.writeMethodName != null ? y.writeMethodName : x.writeMethodName;
        this.propertyTypeRef = y.propertyTypeRef != null ? y.propertyTypeRef : x.propertyTypeRef;
        Method xr = x.getReadMethod();
        Method yr = y.getReadMethod();
        try {
            if (this.isAssignable(xr, yr)) {
                this.setReadMethod(yr);
            } else {
                this.setReadMethod(xr);
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        if (xr != null && yr != null && xr.getDeclaringClass() == yr.getDeclaringClass() && PropertyDescriptor.getReturnType(this.getClass0(), xr) == Boolean.TYPE && PropertyDescriptor.getReturnType(this.getClass0(), yr) == Boolean.TYPE && xr.getName().indexOf("is") == 0 && yr.getName().indexOf("get") == 0) {
            try {
                this.setReadMethod(xr);
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
        }
        Method xw = x.getWriteMethod();
        Method yw = y.getWriteMethod();
        try {
            if (yw != null) {
                this.setWriteMethod(yw);
            } else {
                this.setWriteMethod(xw);
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        if (y.getPropertyEditorClass() != null) {
            this.setPropertyEditorClass(y.getPropertyEditorClass());
        } else {
            this.setPropertyEditorClass(x.getPropertyEditorClass());
        }
        this.bound = x.bound | y.bound;
        this.constrained = x.constrained | y.constrained;
    }

    PropertyDescriptor(PropertyDescriptor old) {
        super(old);
        this.propertyTypeRef = old.propertyTypeRef;
        this.readMethodRef.set(old.readMethodRef.get());
        this.writeMethodRef.set(old.writeMethodRef.get());
        this.propertyEditorClassRef = old.propertyEditorClassRef;
        this.writeMethodName = old.writeMethodName;
        this.readMethodName = old.readMethodName;
        this.baseName = old.baseName;
        this.bound = old.bound;
        this.constrained = old.constrained;
    }

    void updateGenericsFor(Class<?> type) {
        this.setClass0(type);
        try {
            this.setPropertyType(this.findPropertyType(this.readMethodRef.get(), this.writeMethodRef.get()));
        }
        catch (IntrospectionException exception) {
            this.setPropertyType(null);
        }
    }

    private Class<?> findPropertyType(Method readMethod, Method writeMethod) throws IntrospectionException {
        Class<?>[] params;
        Class<?> propertyType = null;
        if (readMethod != null) {
            params = PropertyDescriptor.getParameterTypes(this.getClass0(), readMethod);
            if (params.length != 0) {
                throw new IntrospectionException("bad read method arg count: " + readMethod);
            }
            propertyType = PropertyDescriptor.getReturnType(this.getClass0(), readMethod);
            if (propertyType == Void.TYPE) {
                throw new IntrospectionException("read method " + readMethod.getName() + " returns void");
            }
        }
        if (writeMethod != null) {
            params = PropertyDescriptor.getParameterTypes(this.getClass0(), writeMethod);
            if (params.length != 1) {
                throw new IntrospectionException("bad write method arg count: " + writeMethod);
            }
            if (propertyType != null && !params[0].isAssignableFrom(propertyType)) {
                throw new IntrospectionException("type mismatch between read and write methods");
            }
            propertyType = params[0];
        }
        return propertyType;
    }

    public int hashCode() {
        int result = 7;
        result = 37 * result + (this.getPropertyType() == null ? 0 : this.getPropertyType().hashCode());
        result = 37 * result + (this.getReadMethod() == null ? 0 : this.getReadMethod().hashCode());
        result = 37 * result + (this.getWriteMethod() == null ? 0 : this.getWriteMethod().hashCode());
        result = 37 * result + (this.getPropertyEditorClass() == null ? 0 : this.getPropertyEditorClass().hashCode());
        result = 37 * result + (this.writeMethodName == null ? 0 : this.writeMethodName.hashCode());
        result = 37 * result + (this.readMethodName == null ? 0 : this.readMethodName.hashCode());
        result = 37 * result + this.getName().hashCode();
        result = 37 * result + (!this.bound ? 0 : 1);
        result = 37 * result + (!this.constrained ? 0 : 1);
        return result;
    }

    String getBaseName() {
        if (this.baseName == null) {
            this.baseName = NameGenerator.capitalize(this.getName());
        }
        return this.baseName;
    }

    @Override
    void appendTo(StringBuilder sb) {
        PropertyDescriptor.appendTo(sb, "bound", this.bound);
        PropertyDescriptor.appendTo(sb, "constrained", this.constrained);
        PropertyDescriptor.appendTo(sb, "propertyEditorClass", this.propertyEditorClassRef);
        PropertyDescriptor.appendTo(sb, "propertyType", this.propertyTypeRef);
        PropertyDescriptor.appendTo(sb, "readMethod", this.readMethodRef.get());
        PropertyDescriptor.appendTo(sb, "writeMethod", this.writeMethodRef.get());
    }

    private boolean isAssignable(Method m1, Method m2) {
        Class<?>[] args2;
        Class<?> type2;
        if (m1 == null) {
            return true;
        }
        if (m2 == null) {
            return false;
        }
        if (!m1.getName().equals(m2.getName())) {
            return true;
        }
        Class<?> type1 = m1.getDeclaringClass();
        if (!type1.isAssignableFrom(type2 = m2.getDeclaringClass())) {
            return false;
        }
        type1 = PropertyDescriptor.getReturnType(this.getClass0(), m1);
        if (!type1.isAssignableFrom(type2 = PropertyDescriptor.getReturnType(this.getClass0(), m2))) {
            return false;
        }
        Class<?>[] args1 = PropertyDescriptor.getParameterTypes(this.getClass0(), m1);
        if (args1.length != (args2 = PropertyDescriptor.getParameterTypes(this.getClass0(), m2)).length) {
            return true;
        }
        for (int i = 0; i < args1.length; ++i) {
            if (args1[i].isAssignableFrom(args2[i])) continue;
            return false;
        }
        return true;
    }
}

