/*
 * Decompiled with CFR 0.152.
 */
package java.nio.file.attribute;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public final class FileTime
implements Comparable<FileTime> {
    private final TimeUnit unit;
    private final long value;
    private Instant instant;
    private String valueAsString;
    private static final long HOURS_PER_DAY = 24L;
    private static final long MINUTES_PER_HOUR = 60L;
    private static final long SECONDS_PER_MINUTE = 60L;
    private static final long SECONDS_PER_HOUR = 3600L;
    private static final long SECONDS_PER_DAY = 86400L;
    private static final long MILLIS_PER_SECOND = 1000L;
    private static final long MICROS_PER_SECOND = 1000000L;
    private static final long NANOS_PER_SECOND = 1000000000L;
    private static final int NANOS_PER_MILLI = 1000000;
    private static final int NANOS_PER_MICRO = 1000;
    private static final long MIN_SECOND = -31557014167219200L;
    private static final long MAX_SECOND = 31556889864403199L;
    private static final long DAYS_PER_10000_YEARS = 3652425L;
    private static final long SECONDS_PER_10000_YEARS = 315569520000L;
    private static final long SECONDS_0000_TO_1970 = 62167219200L;

    private FileTime(long value, TimeUnit unit, Instant instant) {
        this.value = value;
        this.unit = unit;
        this.instant = instant;
    }

    public static FileTime from(long value, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        return new FileTime(value, unit, null);
    }

    public static FileTime fromMillis(long value) {
        return new FileTime(value, TimeUnit.MILLISECONDS, null);
    }

    public static FileTime from(Instant instant) {
        Objects.requireNonNull(instant, "instant");
        return new FileTime(0L, null, instant);
    }

    public long to(TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        if (this.unit != null) {
            return unit.convert(this.value, this.unit);
        }
        long secs = unit.convert(this.instant.getEpochSecond(), TimeUnit.SECONDS);
        if (secs == Long.MIN_VALUE || secs == Long.MAX_VALUE) {
            return secs;
        }
        long nanos = unit.convert(this.instant.getNano(), TimeUnit.NANOSECONDS);
        long r = secs + nanos;
        if (((secs ^ r) & (nanos ^ r)) < 0L) {
            return secs < 0L ? Long.MIN_VALUE : Long.MAX_VALUE;
        }
        return r;
    }

    public long toMillis() {
        if (this.unit != null) {
            return this.unit.toMillis(this.value);
        }
        long secs = this.instant.getEpochSecond();
        int nanos = this.instant.getNano();
        long r = secs * 1000L;
        long ax = Math.abs(secs);
        if ((ax | 0x3E8L) >>> 31 != 0L && r / 1000L != secs) {
            return secs < 0L ? Long.MIN_VALUE : Long.MAX_VALUE;
        }
        return r + (long)(nanos / 1000000);
    }

    private static long scale(long d, long m, long over) {
        if (d > over) {
            return Long.MAX_VALUE;
        }
        if (d < -over) {
            return Long.MIN_VALUE;
        }
        return d * m;
    }

    public Instant toInstant() {
        if (this.instant == null) {
            long secs = 0L;
            int nanos = 0;
            switch (this.unit) {
                case DAYS: {
                    secs = FileTime.scale(this.value, 86400L, 106751991167300L);
                    break;
                }
                case HOURS: {
                    secs = FileTime.scale(this.value, 3600L, 2562047788015215L);
                    break;
                }
                case MINUTES: {
                    secs = FileTime.scale(this.value, 60L, 0x222222222222222L);
                    break;
                }
                case SECONDS: {
                    secs = this.value;
                    break;
                }
                case MILLISECONDS: {
                    secs = Math.floorDiv(this.value, 1000L);
                    nanos = (int)Math.floorMod(this.value, 1000L) * 1000000;
                    break;
                }
                case MICROSECONDS: {
                    secs = Math.floorDiv(this.value, 1000000L);
                    nanos = (int)Math.floorMod(this.value, 1000000L) * 1000;
                    break;
                }
                case NANOSECONDS: {
                    secs = Math.floorDiv(this.value, 1000000000L);
                    nanos = (int)Math.floorMod(this.value, 1000000000L);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Unit not handled");
                }
            }
            this.instant = secs <= -31557014167219200L ? Instant.MIN : (secs >= 31556889864403199L ? Instant.MAX : Instant.ofEpochSecond(secs, nanos));
        }
        return this.instant;
    }

    public boolean equals(Object obj) {
        return obj instanceof FileTime ? this.compareTo((FileTime)obj) == 0 : false;
    }

    public int hashCode() {
        return this.toInstant().hashCode();
    }

    private long toDays() {
        if (this.unit != null) {
            return this.unit.toDays(this.value);
        }
        return TimeUnit.SECONDS.toDays(this.toInstant().getEpochSecond());
    }

    private long toExcessNanos(long days) {
        if (this.unit != null) {
            return this.unit.toNanos(this.value - this.unit.convert(days, TimeUnit.DAYS));
        }
        return TimeUnit.SECONDS.toNanos(this.toInstant().getEpochSecond() - TimeUnit.DAYS.toSeconds(days));
    }

    @Override
    public int compareTo(FileTime other) {
        long daysOther;
        long secsOther;
        if (this.unit != null && this.unit == other.unit) {
            return Long.compare(this.value, other.value);
        }
        long secs = this.toInstant().getEpochSecond();
        int cmp = Long.compare(secs, secsOther = other.toInstant().getEpochSecond());
        if (cmp != 0) {
            return cmp;
        }
        cmp = Long.compare(this.toInstant().getNano(), other.toInstant().getNano());
        if (cmp != 0) {
            return cmp;
        }
        if (secs != 31556889864403199L && secs != -31557014167219200L) {
            return 0;
        }
        long days = this.toDays();
        if (days == (daysOther = other.toDays())) {
            return Long.compare(this.toExcessNanos(days), other.toExcessNanos(daysOther));
        }
        return Long.compare(days, daysOther);
    }

    private StringBuilder append(StringBuilder sb, int w, int d) {
        while (w > 0) {
            sb.append((char)(d / w + 48));
            d %= w;
            w /= 10;
        }
        return sb;
    }

    public String toString() {
        if (this.valueAsString == null) {
            LocalDateTime ldt;
            long lo;
            long hi;
            long zeroSecs;
            long secs = 0L;
            int nanos = 0;
            if (this.instant == null && this.unit.compareTo(TimeUnit.SECONDS) >= 0) {
                secs = this.unit.toSeconds(this.value);
            } else {
                secs = this.toInstant().getEpochSecond();
                nanos = this.toInstant().getNano();
            }
            int year = 0;
            if (secs >= -62167219200L) {
                zeroSecs = secs - 315569520000L + 62167219200L;
                hi = Math.floorDiv(zeroSecs, 315569520000L) + 1L;
                lo = Math.floorMod(zeroSecs, 315569520000L);
                ldt = LocalDateTime.ofEpochSecond(lo - 62167219200L, nanos, ZoneOffset.UTC);
                year = ldt.getYear() + (int)hi * 10000;
            } else {
                zeroSecs = secs + 62167219200L;
                hi = zeroSecs / 315569520000L;
                lo = zeroSecs % 315569520000L;
                ldt = LocalDateTime.ofEpochSecond(lo - 62167219200L, nanos, ZoneOffset.UTC);
                year = ldt.getYear() + (int)hi * 10000;
            }
            if (year <= 0) {
                --year;
            }
            int fraction = ldt.getNano();
            StringBuilder sb = new StringBuilder(64);
            sb.append(year < 0 ? "-" : "");
            year = Math.abs(year);
            if (year < 10000) {
                this.append(sb, 1000, Math.abs(year));
            } else {
                sb.append(String.valueOf(year));
            }
            sb.append('-');
            this.append(sb, 10, ldt.getMonthValue());
            sb.append('-');
            this.append(sb, 10, ldt.getDayOfMonth());
            sb.append('T');
            this.append(sb, 10, ldt.getHour());
            sb.append(':');
            this.append(sb, 10, ldt.getMinute());
            sb.append(':');
            this.append(sb, 10, ldt.getSecond());
            if (fraction != 0) {
                sb.append('.');
                int w = 100000000;
                while (fraction % 10 == 0) {
                    fraction /= 10;
                    w /= 10;
                }
                this.append(sb, w, fraction);
            }
            sb.append('Z');
            this.valueAsString = sb.toString();
        }
        return this.valueAsString;
    }
}

