/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.rmi;

import com.sun.jmx.remote.internal.RMIExporter;
import com.sun.jmx.remote.util.EnvHelp;
import java.io.IOException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteObject;
import java.rmi.server.UnicastRemoteObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.management.remote.rmi.RMIConnection;
import javax.management.remote.rmi.RMIConnectionImpl;
import javax.management.remote.rmi.RMIServerImpl;
import javax.security.auth.Subject;
import sun.misc.ObjectInputFilter;
import sun.reflect.misc.ReflectUtil;
import sun.rmi.server.UnicastServerRef;
import sun.rmi.server.UnicastServerRef2;
import sun.rmi.transport.LiveRef;

public class RMIJRMPServerImpl
extends RMIServerImpl {
    private final int port;
    private final RMIClientSocketFactory csf;
    private final RMIServerSocketFactory ssf;
    private final Map<String, ?> env;
    private final Set<String> allowedTypes;
    private final ObjectInputFilter jmxRmiFilter;
    private final ObjectInputFilter cFilter;

    public RMIJRMPServerImpl(int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf, Map<String, ?> env) throws IOException {
        super(env);
        if (port < 0) {
            throw new IllegalArgumentException("Negative port: " + port);
        }
        this.port = port;
        this.csf = csf;
        this.ssf = ssf;
        this.env = env == null ? Collections.emptyMap() : env;
        String[] credentialsTypes = (String[])this.env.get("jmx.remote.rmi.server.credential.types");
        String credentialsFilter = (String)this.env.get("jmx.remote.rmi.server.credentials.filter.pattern");
        if (credentialsFilter != null) {
            this.cFilter = ObjectInputFilter.Config.createFilter(credentialsFilter);
            this.allowedTypes = null;
        } else if (credentialsTypes != null) {
            this.allowedTypes = Arrays.stream(credentialsTypes).filter(s -> s != null).collect(Collectors.toSet());
            this.allowedTypes.stream().forEach(ReflectUtil::checkPackageAccess);
            this.cFilter = this::newClientCheckInput;
        } else {
            this.allowedTypes = null;
            this.cFilter = null;
        }
        String userJmxFilter = (String)this.env.get("jmx.remote.rmi.server.serial.filter.pattern");
        this.jmxRmiFilter = userJmxFilter != null && !userJmxFilter.isEmpty() ? ObjectInputFilter.Config.createFilter(userJmxFilter) : null;
    }

    @Override
    protected void export() throws IOException {
        this.export(this, this.cFilter);
    }

    private void export(Remote obj, ObjectInputFilter typeFilter) throws RemoteException {
        RMIExporter exporter = (RMIExporter)this.env.get("com.sun.jmx.remote.rmi.exporter");
        boolean daemon = EnvHelp.isServerDaemon(this.env);
        if (daemon && exporter != null) {
            throw new IllegalArgumentException("If jmx.remote.x.daemon is specified as true, com.sun.jmx.remote.rmi.exporter cannot be used to specify an exporter!");
        }
        if (exporter != null) {
            exporter.exportObject(obj, this.port, this.csf, this.ssf, typeFilter);
        } else if (this.csf == null && this.ssf == null) {
            new UnicastServerRef(new LiveRef(this.port), typeFilter).exportObject(obj, null, daemon);
        } else {
            new UnicastServerRef2(this.port, this.csf, this.ssf, typeFilter).exportObject(obj, null, daemon);
        }
    }

    private void unexport(Remote obj, boolean force) throws NoSuchObjectException {
        RMIExporter exporter = (RMIExporter)this.env.get("com.sun.jmx.remote.rmi.exporter");
        if (exporter == null) {
            UnicastRemoteObject.unexportObject(obj, force);
        } else {
            exporter.unexportObject(obj, force);
        }
    }

    @Override
    protected String getProtocol() {
        return "rmi";
    }

    @Override
    public Remote toStub() throws IOException {
        return RemoteObject.toStub(this);
    }

    @Override
    protected RMIConnection makeClient(String connectionId, Subject subject) throws IOException {
        if (connectionId == null) {
            throw new NullPointerException("Null connectionId");
        }
        RMIConnectionImpl client = new RMIConnectionImpl(this, connectionId, this.getDefaultClassLoader(), subject, this.env);
        this.export(client, this.jmxRmiFilter);
        return client;
    }

    @Override
    protected void closeClient(RMIConnection client) throws IOException {
        this.unexport(client, true);
    }

    @Override
    protected void closeServer() throws IOException {
        this.unexport(this, true);
    }

    ObjectInputFilter.Status newClientCheckInput(ObjectInputFilter.FilterInfo filterInfo) {
        ObjectInputFilter.Status status = ObjectInputFilter.Status.UNDECIDED;
        if (this.allowedTypes != null && filterInfo.serialClass() != null) {
            String type = filterInfo.serialClass().getName();
            status = this.allowedTypes.contains(type) ? ObjectInputFilter.Status.ALLOWED : ObjectInputFilter.Status.REJECTED;
        }
        return status;
    }
}

