/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.List;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.InvocationEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.VolatileImage;
import java.awt.peer.ListPeer;
import java.util.Objects;
import java.util.Vector;
import sun.awt.X11.ListHelper;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XEvent;
import sun.awt.X11.XHorizontalScrollbar;
import sun.awt.X11.XScrollbar;
import sun.awt.X11.XScrollbarClient;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XVerticalScrollbar;
import sun.util.logging.PlatformLogger;

class XListPeer
extends XComponentPeer
implements ListPeer,
XScrollbarClient {
    private static final PlatformLogger log = PlatformLogger.getLogger("sun.awt.X11.XListPeer");
    public static final int MARGIN = 2;
    public static final int SPACE = 1;
    public static final int SCROLLBAR_AREA = 17;
    public static final int SCROLLBAR_WIDTH = 13;
    public static final int NONE = -1;
    public static final int WINDOW = 0;
    public static final int VERSCROLLBAR = 1;
    public static final int HORSCROLLBAR = 2;
    public static final int DEFAULT_VISIBLE_ROWS = 4;
    public static final int HORIZ_SCROLL_AMT = 10;
    private static final int PAINT_VSCROLL = 2;
    private static final int PAINT_HSCROLL = 4;
    private static final int PAINT_ITEMS = 8;
    private static final int PAINT_FOCUS = 16;
    private static final int PAINT_BACKGROUND = 32;
    private static final int PAINT_HIDEFOCUS = 64;
    private static final int PAINT_ALL = 62;
    private static final int COPY_AREA = 128;
    XVerticalScrollbar vsb;
    XHorizontalScrollbar hsb;
    ListPainter painter;
    Vector items;
    boolean multipleSelections;
    int active = -1;
    int[] selected;
    int fontHeight;
    int fontAscent;
    int fontLeading;
    int currentIndex = -1;
    int eventIndex = -1;
    int eventType = -1;
    int focusIndex;
    int maxLength;
    boolean vsbVis;
    boolean hsbVis;
    int listWidth;
    int listHeight;
    private int firstTimeVisibleIndex = 0;
    boolean bgColorSet;
    boolean fgColorSet;
    boolean mouseDraggedOutHorizontally = false;
    boolean mouseDraggedOutVertically = false;
    boolean isScrollBarOriginated = false;
    boolean isMousePressed = false;

    XListPeer(List target) {
        super(target);
    }

    @Override
    public void preInit(XCreateWindowParams params) {
        super.preInit(params);
        this.items = new Vector();
        this.createVerScrollbar();
        this.createHorScrollbar();
        this.painter = new ListPainter();
        this.bgColorSet = this.target.isBackgroundSet();
        this.fgColorSet = this.target.isForegroundSet();
    }

    @Override
    public void postInit(XCreateWindowParams params) {
        super.postInit(params);
        this.initFontMetrics();
        List l = (List)this.target;
        int stop = l.getItemCount();
        for (int i = 0; i < stop; ++i) {
            this.items.addElement(l.getItem(i));
        }
        int index = l.getVisibleIndex();
        if (index >= 0) {
            this.vsb.setValues(index, 0, 0, this.items.size());
        }
        this.maxLength = this.maxLength();
        int[] sel = l.getSelectedIndexes();
        this.selected = new int[sel.length];
        for (int i = 0; i < sel.length; ++i) {
            this.selected[i] = sel[i];
        }
        if (sel.length > 0) {
            this.setFocusIndex(sel[sel.length - 1]);
        } else {
            this.setFocusIndex(0);
        }
        this.multipleSelections = l.isMultipleMode();
    }

    void createVerScrollbar() {
        this.vsb = new XVerticalScrollbar(this);
        this.vsb.setValues(0, 0, 0, 0, 1, 1);
    }

    void createHorScrollbar() {
        this.hsb = new XHorizontalScrollbar(this);
        this.hsb.setValues(0, 0, 0, 0, 10, 10);
    }

    @Override
    public void add(String item, int index) {
        this.addItem(item, index);
    }

    @Override
    public void removeAll() {
        this.clear();
        this.maxLength = 0;
    }

    @Override
    public void setMultipleMode(boolean b) {
        this.setMultipleSelections(b);
    }

    @Override
    public Dimension getPreferredSize(int rows) {
        return this.preferredSize(rows);
    }

    @Override
    public Dimension getMinimumSize(int rows) {
        return this.minimumSize(rows);
    }

    @Override
    public Dimension minimumSize() {
        return this.minimumSize(4);
    }

    public Dimension preferredSize(int v) {
        return this.minimumSize(v);
    }

    public Dimension minimumSize(int v) {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        this.initFontMetrics();
        return new Dimension(20 + fm.stringWidth("0123456789abcde"), this.getItemHeight() * v + 4);
    }

    void initFontMetrics() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        this.fontHeight = fm.getHeight();
        this.fontAscent = fm.getAscent();
        this.fontLeading = fm.getLeading();
    }

    int maxLength() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int m = 0;
        int end = this.items.size();
        for (int i = 0; i < end; ++i) {
            int l = fm.stringWidth((String)this.items.elementAt(i));
            m = Math.max(m, l);
        }
        return m;
    }

    int getItemWidth(int i) {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        return fm.stringWidth((String)this.items.elementAt(i));
    }

    int stringLength(String str) {
        FontMetrics fm = this.getFontMetrics(this.target.getFont());
        return fm.stringWidth(str);
    }

    @Override
    public void setForeground(Color c) {
        this.fgColorSet = true;
        super.setForeground(c);
    }

    @Override
    public void setBackground(Color c) {
        this.bgColorSet = true;
        super.setBackground(c);
    }

    private Color getListBackground(Color[] colors) {
        if (this.bgColorSet) {
            return colors[0];
        }
        return SystemColor.text;
    }

    private Color getListForeground(Color[] colors) {
        if (this.fgColorSet) {
            return colors[3];
        }
        return SystemColor.textText;
    }

    Rectangle getVScrollBarRec() {
        return new Rectangle(this.width - 13, 0, 14, this.height);
    }

    Rectangle getHScrollBarRec() {
        return new Rectangle(0, this.height - 13, this.width, 13);
    }

    int getFirstVisibleItem() {
        if (this.vsbVis) {
            return this.vsb.getValue();
        }
        return 0;
    }

    int getLastVisibleItem() {
        if (this.vsbVis) {
            return Math.min(this.items.size() - 1, this.vsb.getValue() + this.itemsInWindow() - 1);
        }
        return Math.min(this.items.size() - 1, this.itemsInWindow() - 1);
    }

    @Override
    public void repaintScrollbarRequest(XScrollbar scrollbar) {
        if (scrollbar == this.hsb) {
            this.repaint(4);
        } else if (scrollbar == this.vsb) {
            this.repaint(2);
        }
    }

    @Override
    public void repaint() {
        this.repaint(this.getFirstVisibleItem(), this.getLastVisibleItem(), 62);
    }

    private void repaint(int options) {
        this.repaint(this.getFirstVisibleItem(), this.getLastVisibleItem(), options);
    }

    private void repaint(int firstItem, int lastItem, int options) {
        this.repaint(firstItem, lastItem, options, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repaint(int firstItem, int lastItem, int options, Rectangle source, Point distance) {
        Graphics g = this.getGraphics();
        if (g != null) {
            try {
                this.painter.paint(g, firstItem, lastItem, options, source, distance);
                this.postPaintEvent(this.target, 0, 0, this.getWidth(), this.getHeight());
            }
            finally {
                g.dispose();
            }
        }
    }

    @Override
    void paintPeer(Graphics g) {
        this.painter.paint(g, this.getFirstVisibleItem(), this.getLastVisibleItem(), 62);
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    public void focusGained(FocusEvent e) {
        super.focusGained(e);
        this.repaint(16);
    }

    @Override
    public void focusLost(FocusEvent e) {
        super.focusLost(e);
        this.repaint(16);
    }

    @Override
    public void layout() {
        boolean vsbWasVisible;
        assert (this.target != null);
        int origVSBVal = this.vsb.getValue();
        int vis = this.itemsInWindow(false);
        int maximum = this.items.size() < vis ? vis : this.items.size();
        this.vsb.setValues(this.vsb.getValue(), vis, this.vsb.getMinimum(), maximum);
        this.vsbVis = vsbWasVisible = this.vsbIsVisible(false);
        this.listHeight = this.height;
        this.listWidth = this.getListWidth();
        vis = this.listWidth - 6;
        maximum = this.maxLength < vis ? vis : this.maxLength;
        this.hsb.setValues(this.hsb.getValue(), vis, this.hsb.getMinimum(), maximum);
        this.hsbVis = this.hsbIsVisible(this.vsbVis);
        if (this.hsbVis) {
            this.listHeight = this.height - 17;
            vis = this.itemsInWindow(true);
            maximum = this.items.size() < vis ? vis : this.items.size();
            this.vsb.setValues(origVSBVal, vis, this.vsb.getMinimum(), maximum);
            this.vsbVis = this.vsbIsVisible(true);
        }
        if (vsbWasVisible != this.vsbVis) {
            this.listWidth = this.getListWidth();
            vis = this.listWidth - 6;
            maximum = this.maxLength < vis ? 0 : this.maxLength;
            this.hsb.setValues(this.hsb.getValue(), vis, this.hsb.getMinimum(), maximum);
            this.hsbVis = this.hsbIsVisible(this.vsbVis);
        }
        this.vsb.setSize(13, this.listHeight);
        this.hsb.setSize(this.listWidth, 13);
        this.vsb.setBlockIncrement(this.itemsInWindow());
        this.hsb.setBlockIncrement(this.width - (6 + (this.vsbVis ? 17 : 0)));
    }

    int getItemWidth() {
        return this.width - (4 + (this.vsbVis ? 17 : 0));
    }

    int getItemHeight() {
        return this.fontHeight - this.fontLeading + 2;
    }

    int getItemX() {
        return 3;
    }

    int getItemY(int item) {
        return this.index2y(item);
    }

    int getFocusIndex() {
        return this.focusIndex;
    }

    void setFocusIndex(int value) {
        this.focusIndex = value;
    }

    Rectangle getFocusRect() {
        Rectangle focusRect = new Rectangle();
        focusRect.x = 1;
        focusRect.width = this.getListWidth() - 3;
        if (this.isIndexDisplayed(this.getFocusIndex())) {
            focusRect.y = this.index2y(this.getFocusIndex()) - 2;
            focusRect.height = this.getItemHeight() + 1;
        } else {
            focusRect.y = 1;
            focusRect.height = this.hsbVis ? this.height - 17 : this.height;
            focusRect.height -= 3;
        }
        return focusRect;
    }

    @Override
    public void handleConfigureNotifyEvent(XEvent xev) {
        super.handleConfigureNotifyEvent(xev);
        this.painter.invalidate();
    }

    @Override
    public boolean handlesWheelScrolling() {
        return true;
    }

    @Override
    void handleJavaMouseEvent(MouseEvent e) {
        super.handleJavaMouseEvent(e);
        int i = e.getID();
        switch (i) {
            case 501: {
                this.mousePressed(e);
                break;
            }
            case 502: {
                this.mouseReleased(e);
                break;
            }
            case 506: {
                this.mouseDragged(e);
            }
        }
    }

    @Override
    void handleJavaMouseWheelEvent(MouseWheelEvent e) {
        if (ListHelper.doWheelScroll(this.vsbVis ? this.vsb : null, this.hsbVis ? this.hsb : null, e)) {
            this.repaint();
        }
    }

    void mousePressed(MouseEvent mouseEvent) {
        if (log.isLoggable(PlatformLogger.Level.FINER)) {
            log.finer(mouseEvent.toString() + ", hsb " + this.hsbVis + ", vsb " + this.vsbVis);
        }
        if (this.isEnabled() && mouseEvent.getButton() == 1) {
            if (this.inWindow(mouseEvent.getX(), mouseEvent.getY())) {
                if (log.isLoggable(PlatformLogger.Level.FINE)) {
                    log.fine("Mouse press in items area");
                }
                this.active = 0;
                int i = this.y2index(mouseEvent.getY());
                if (i >= 0) {
                    if (this.multipleSelections) {
                        if (this.isSelected(i)) {
                            this.deselectItem(i);
                            this.eventIndex = i;
                            this.eventType = 2;
                        } else {
                            this.selectItem(i);
                            this.eventIndex = i;
                            this.eventType = 1;
                        }
                    } else {
                        this.selectItem(i);
                        this.eventIndex = i;
                        this.eventType = 1;
                    }
                    this.setFocusIndex(i);
                    this.repaint(16);
                } else {
                    this.currentIndex = -1;
                }
            } else if (this.inVerticalScrollbar(mouseEvent.getX(), mouseEvent.getY())) {
                if (log.isLoggable(PlatformLogger.Level.FINE)) {
                    log.fine("Mouse press in vertical scrollbar");
                }
                this.active = 1;
                this.vsb.handleMouseEvent(mouseEvent.getID(), mouseEvent.getModifiers(), mouseEvent.getX() - (this.width - 13), mouseEvent.getY());
            } else if (this.inHorizontalScrollbar(mouseEvent.getX(), mouseEvent.getY())) {
                if (log.isLoggable(PlatformLogger.Level.FINE)) {
                    log.fine("Mouse press in horizontal scrollbar");
                }
                this.active = 2;
                this.hsb.handleMouseEvent(mouseEvent.getID(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY() - (this.height - 13));
            }
            this.isMousePressed = true;
        }
    }

    void mouseReleased(MouseEvent mouseEvent) {
        if (this.isEnabled() && mouseEvent.getButton() == 1) {
            int clickCount = mouseEvent.getClickCount();
            if (this.active == 1) {
                this.vsb.handleMouseEvent(mouseEvent.getID(), mouseEvent.getModifiers(), mouseEvent.getX() - (this.width - 13), mouseEvent.getY());
            } else if (this.active == 2) {
                this.hsb.handleMouseEvent(mouseEvent.getID(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY() - (this.height - 13));
            } else if (this.currentIndex >= 0 && clickCount >= 2 && clickCount % 2 == 0) {
                this.postEvent(new ActionEvent(this.target, 1001, (String)this.items.elementAt(this.currentIndex), mouseEvent.getWhen(), mouseEvent.getModifiers()));
            } else if (this.active == 0) {
                this.trackMouseReleasedScroll();
                if (this.eventType == 2) {
                    assert (this.multipleSelections) : "Shouldn't get a deselect for a single-select List";
                    this.deselectItem(this.eventIndex);
                }
                if (this.eventType != -1) {
                    this.postEvent(new ItemEvent((List)this.target, 701, this.eventIndex, this.eventType));
                }
            }
            this.active = -1;
            this.eventIndex = -1;
            this.eventType = -1;
            this.isMousePressed = false;
        }
    }

    void mouseDragged(MouseEvent mouseEvent) {
        if (this.isEnabled() && (mouseEvent.getModifiersEx() & 0x400) != 0) {
            if (this.active == 1) {
                this.vsb.handleMouseEvent(mouseEvent.getID(), mouseEvent.getModifiers(), mouseEvent.getX() - (this.width - 13), mouseEvent.getY());
            } else if (this.active == 2) {
                this.hsb.handleMouseEvent(mouseEvent.getID(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY() - (this.height - 13));
            } else if (this.active == 0) {
                int i = this.y2index(mouseEvent.getY());
                if (this.multipleSelections) {
                    if (this.eventType == 2 && i != this.eventIndex) {
                        this.eventType = -1;
                        this.eventIndex = -1;
                    }
                } else if (this.eventType == 1) {
                    this.trackMouseDraggedScroll(mouseEvent);
                    if (i >= 0 && !this.isSelected(i)) {
                        int oldSel = this.eventIndex;
                        this.selectItem(i);
                        this.eventIndex = i;
                        this.repaint(oldSel, this.eventIndex, 8);
                    }
                }
                if (i >= 0) {
                    this.setFocusIndex(i);
                    this.repaint(16);
                }
            }
        }
    }

    void trackMouseDraggedScroll(MouseEvent mouseEvent) {
        if (this.vsb.beforeThumb(mouseEvent.getX(), mouseEvent.getY())) {
            this.vsb.setMode(2);
        } else {
            this.vsb.setMode(1);
        }
        if (mouseEvent.getY() < 0 || mouseEvent.getY() >= this.listHeight) {
            if (!this.mouseDraggedOutVertically) {
                this.mouseDraggedOutVertically = true;
                this.vsb.startScrollingInstance();
            }
        } else if (this.mouseDraggedOutVertically) {
            this.mouseDraggedOutVertically = false;
            this.vsb.stopScrollingInstance();
        }
        if (this.hsb.beforeThumb(mouseEvent.getX(), mouseEvent.getY())) {
            this.hsb.setMode(2);
        } else {
            this.hsb.setMode(1);
        }
        if (mouseEvent.getX() < 0 || mouseEvent.getX() >= this.listWidth) {
            if (!this.mouseDraggedOutHorizontally) {
                this.mouseDraggedOutHorizontally = true;
                this.hsb.startScrollingInstance();
            }
        } else if (this.mouseDraggedOutHorizontally) {
            this.mouseDraggedOutHorizontally = false;
            this.hsb.stopScrollingInstance();
        }
    }

    void trackMouseReleasedScroll() {
        if (this.mouseDraggedOutVertically) {
            this.mouseDraggedOutVertically = false;
            this.vsb.stopScrollingInstance();
        }
        if (this.mouseDraggedOutHorizontally) {
            this.mouseDraggedOutHorizontally = false;
            this.hsb.stopScrollingInstance();
        }
    }

    @Override
    void handleJavaKeyEvent(KeyEvent e) {
        switch (e.getID()) {
            case 401: {
                if (this.isMousePressed) break;
                this.keyPressed(e);
            }
        }
    }

    void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine(e.toString());
        }
        switch (keyCode) {
            case 38: 
            case 224: {
                if (this.getFocusIndex() <= 0) break;
                this.setFocusIndex(this.getFocusIndex() - 1);
                this.repaint(64);
                if (!this.multipleSelections) {
                    this.selectItem(this.getFocusIndex());
                    this.postEvent(new ItemEvent((List)this.target, 701, this.getFocusIndex(), 1));
                }
                if (this.isItemHidden(this.getFocusIndex())) {
                    this.makeVisible(this.getFocusIndex());
                    break;
                }
                this.repaint(16);
                break;
            }
            case 40: 
            case 225: {
                if (this.getFocusIndex() >= this.items.size() - 1) break;
                this.setFocusIndex(this.getFocusIndex() + 1);
                this.repaint(64);
                if (!this.multipleSelections) {
                    this.selectItem(this.getFocusIndex());
                    this.postEvent(new ItemEvent((List)this.target, 701, this.getFocusIndex(), 1));
                }
                if (this.isItemHidden(this.getFocusIndex())) {
                    this.makeVisible(this.getFocusIndex());
                    break;
                }
                this.repaint(16);
                break;
            }
            case 33: {
                int previousValue = this.vsb.getValue();
                this.vsb.setValue(this.vsb.getValue() - this.vsb.getBlockIncrement());
                int currentValue = this.vsb.getValue();
                if (previousValue != currentValue) {
                    this.setFocusIndex(Math.max(this.getFocusIndex() - this.itemsInWindow(), 0));
                    if (!this.multipleSelections) {
                        this.selectItem(this.getFocusIndex());
                        this.postEvent(new ItemEvent((List)this.target, 701, this.getFocusIndex(), 1));
                    }
                }
                this.repaint();
                break;
            }
            case 34: {
                int previousValue = this.vsb.getValue();
                this.vsb.setValue(this.vsb.getValue() + this.vsb.getBlockIncrement());
                int currentValue = this.vsb.getValue();
                if (previousValue != currentValue) {
                    this.setFocusIndex(Math.min(this.getFocusIndex() + this.itemsInWindow(), this.items.size() - 1));
                    if (!this.multipleSelections) {
                        this.selectItem(this.getFocusIndex());
                        this.postEvent(new ItemEvent((List)this.target, 701, this.getFocusIndex(), 1));
                    }
                }
                this.repaint();
                break;
            }
            case 37: 
            case 226: {
                if (!(this.hsbVis & this.hsb.getValue() > 0)) break;
                this.hsb.setValue(this.hsb.getValue() - 10);
                this.repaint();
                break;
            }
            case 39: 
            case 227: {
                if (!this.hsbVis) break;
                this.hsb.setValue(this.hsb.getValue() + 10);
                this.repaint();
                break;
            }
            case 36: {
                if (!e.isControlDown() || ((List)this.target).getItemCount() <= 0) break;
                if (this.vsbVis) {
                    this.vsb.setValue(this.vsb.getMinimum());
                }
                this.setFocusIndex(0);
                if (!this.multipleSelections) {
                    this.selectItem(this.getFocusIndex());
                    this.postEvent(new ItemEvent((List)this.target, 701, this.getFocusIndex(), 1));
                }
                this.repaint();
                break;
            }
            case 35: {
                if (!e.isControlDown() || ((List)this.target).getItemCount() <= 0) break;
                if (this.vsbVis) {
                    this.vsb.setValue(this.vsb.getMaximum());
                }
                this.setFocusIndex(this.items.size() - 1);
                if (!this.multipleSelections) {
                    this.selectItem(this.getFocusIndex());
                    this.postEvent(new ItemEvent((List)this.target, 701, this.getFocusIndex(), 1));
                }
                this.repaint();
                break;
            }
            case 32: {
                if (this.getFocusIndex() < 0 || ((List)this.target).getItemCount() <= 0) break;
                boolean isSelected = this.isSelected(this.getFocusIndex());
                if (this.multipleSelections && isSelected) {
                    this.deselectItem(this.getFocusIndex());
                    this.postEvent(new ItemEvent((List)this.target, 701, this.getFocusIndex(), 2));
                    break;
                }
                if (isSelected) break;
                this.selectItem(this.getFocusIndex());
                this.postEvent(new ItemEvent((List)this.target, 701, this.getFocusIndex(), 1));
                break;
            }
            case 10: {
                if (this.selected.length <= 0) break;
                this.postEvent(new ActionEvent((List)this.target, 1001, (String)this.items.elementAt(this.getFocusIndex()), e.getWhen(), e.getModifiers()));
            }
        }
    }

    @Override
    public void notifyValue(XScrollbar obj, int type, int v, boolean isAdjusting) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("Notify value changed on " + obj + " to " + v);
        }
        int value = obj.getValue();
        if (obj == this.vsb) {
            this.scrollVertical(v - value);
            int oldSel = this.eventIndex;
            int newSel = this.eventIndex + v - value;
            if (this.mouseDraggedOutVertically && !this.isSelected(newSel)) {
                this.selectItem(newSel);
                this.eventIndex = newSel;
                this.repaint(oldSel, this.eventIndex, 8);
                this.setFocusIndex(newSel);
                this.repaint(16);
            }
        } else if ((XHorizontalScrollbar)obj == this.hsb) {
            this.scrollHorizontal(v - value);
        }
    }

    private void deselectAllItems() {
        this.selected = new int[0];
        this.repaint(8);
    }

    public void setMultipleSelections(boolean v) {
        if (this.multipleSelections != v) {
            if (!v) {
                int selPos = this.isSelected(this.focusIndex) ? this.focusIndex : -1;
                this.deselectAllItems();
                if (selPos != -1) {
                    this.selectItem(selPos);
                }
            }
            this.multipleSelections = v;
        }
    }

    public void addItem(String item, int i) {
        int oldMaxLength = this.maxLength;
        boolean hsbWasVis = this.hsbVis;
        boolean vsbWasVis = this.vsbVis;
        int addedIndex = 0;
        if (i < 0 || i >= this.items.size()) {
            i = -1;
        }
        this.currentIndex = -1;
        if (i == -1) {
            this.items.addElement(item);
            i = 0;
            addedIndex = this.items.size() - 1;
        } else {
            this.items.insertElementAt(item, i);
            addedIndex = i;
            for (int j = 0; j < this.selected.length; ++j) {
                if (this.selected[j] < i) continue;
                int n = j;
                this.selected[n] = this.selected[n] + 1;
            }
        }
        if (log.isLoggable(PlatformLogger.Level.FINER)) {
            log.finer("Adding item '" + item + "' to " + addedIndex);
        }
        boolean repaintItems = !this.isItemHidden(addedIndex);
        this.maxLength = Math.max(this.maxLength, this.getItemWidth(addedIndex));
        this.layout();
        int options = 0;
        options = this.vsbVis != vsbWasVis || this.hsbVis != hsbWasVis ? 62 : (repaintItems ? 8 : 0) | (this.maxLength != oldMaxLength || hsbWasVis ^ this.hsbVis ? 4 : 0) | (this.vsb.needsRepaint() ? 2 : 0);
        if (log.isLoggable(PlatformLogger.Level.FINEST)) {
            log.finest("Last visible: " + this.getLastVisibleItem() + ", hsb changed : " + (hsbWasVis ^ this.hsbVis) + ", items changed " + repaintItems);
        }
        this.repaint(addedIndex, this.getLastVisibleItem(), options);
    }

    @Override
    public void delItems(int s, int e) {
        boolean hsbWasVisible = this.hsbVis;
        boolean vsbWasVisible = this.vsbVis;
        int oldLastDisplayed = this.lastItemDisplayed();
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("Deleting from " + s + " to " + e);
        }
        if (log.isLoggable(PlatformLogger.Level.FINEST)) {
            log.finest("Last displayed item: " + oldLastDisplayed + ", items in window " + this.itemsInWindow() + ", size " + this.items.size());
        }
        if (this.items.size() == 0) {
            return;
        }
        if (s > e) {
            int tmp = s;
            s = e;
            e = tmp;
        }
        if (s < 0) {
            s = 0;
        }
        if (e >= this.items.size()) {
            e = this.items.size() - 1;
        }
        boolean repaintNeeded = s >= this.getFirstVisibleItem() && s <= this.getLastVisibleItem();
        for (int i = s; i <= e; ++i) {
            this.items.removeElementAt(s);
            int j = this.posInSel(i);
            if (j == -1) continue;
            int[] newsel = new int[this.selected.length - 1];
            System.arraycopy(this.selected, 0, newsel, 0, j);
            System.arraycopy(this.selected, j + 1, newsel, j, this.selected.length - (j + 1));
            this.selected = newsel;
        }
        int diff = e - s + 1;
        for (int i = 0; i < this.selected.length; ++i) {
            if (this.selected[i] <= e) continue;
            int n = i;
            this.selected[n] = this.selected[n] - diff;
        }
        int options = 2;
        if (this.getFocusIndex() > e) {
            this.setFocusIndex(this.getFocusIndex() - (e - s + 1));
            options |= 0x10;
        } else if (this.getFocusIndex() >= s && this.getFocusIndex() <= e) {
            int focusBound = this.items.size() > 0 ? 0 : -1;
            this.setFocusIndex(Math.max(s - 1, focusBound));
            options |= 0x10;
        }
        if (log.isLoggable(PlatformLogger.Level.FINEST)) {
            log.finest("Multiple selections: " + this.multipleSelections);
        }
        if (this.vsb.getValue() >= s) {
            if (this.vsb.getValue() <= e) {
                this.vsb.setValue(e + 1 - diff);
            } else {
                this.vsb.setValue(this.vsb.getValue() - diff);
            }
        }
        int oldMaxLength = this.maxLength;
        this.maxLength = this.maxLength();
        if (this.maxLength != oldMaxLength) {
            options |= 4;
        }
        this.layout();
        if (repaintNeeded |= vsbWasVisible ^ this.vsbVis || hsbWasVisible ^ this.hsbVis) {
            options |= 0x3E;
        }
        this.repaint(s, oldLastDisplayed, options);
    }

    @Override
    public void select(int index) {
        this.setFocusIndex(index);
        this.repaint(16);
        this.selectItem(index);
    }

    void selectItem(int index) {
        this.currentIndex = index;
        if (this.isSelected(index)) {
            return;
        }
        if (!this.multipleSelections) {
            if (this.selected.length == 0) {
                this.selected = new int[1];
                this.selected[0] = index;
            } else {
                int oldSel = this.selected[0];
                this.selected[0] = index;
                if (!this.isItemHidden(oldSel)) {
                    this.repaint(oldSel, oldSel, 8);
                }
            }
        } else {
            int i;
            int[] newsel = new int[this.selected.length + 1];
            for (i = 0; i < this.selected.length && index > this.selected[i]; ++i) {
                newsel[i] = this.selected[i];
            }
            newsel[i] = index;
            System.arraycopy(this.selected, i, newsel, i + 1, this.selected.length - i);
            this.selected = newsel;
        }
        if (!this.isItemHidden(index)) {
            this.repaint(index, index, 8);
        }
    }

    @Override
    public void deselect(int index) {
        this.deselectItem(index);
    }

    void deselectItem(int index) {
        if (!this.isSelected(index)) {
            return;
        }
        if (!this.multipleSelections) {
            this.selected = new int[0];
        } else {
            int i = this.posInSel(index);
            int[] newsel = new int[this.selected.length - 1];
            System.arraycopy(this.selected, 0, newsel, 0, i);
            System.arraycopy(this.selected, i + 1, newsel, i, this.selected.length - (i + 1));
            this.selected = newsel;
        }
        this.currentIndex = index;
        if (!this.isItemHidden(index)) {
            this.repaint(index, index, 8);
        }
    }

    @Override
    public void makeVisible(int index) {
        if (index < 0 || index >= this.items.size()) {
            return;
        }
        if (this.isItemHidden(index)) {
            if (index < this.vsb.getValue()) {
                this.scrollVertical(index - this.vsb.getValue());
            } else if (index > this.lastItemDisplayed()) {
                int val = index - this.lastItemDisplayed();
                this.scrollVertical(val);
            }
        }
    }

    public void clear() {
        this.selected = new int[0];
        this.items = new Vector();
        this.currentIndex = -1;
        this.setFocusIndex(-1);
        this.vsb.setValue(0);
        this.maxLength = 0;
        this.layout();
        this.repaint();
    }

    @Override
    public int[] getSelectedIndexes() {
        return this.selected;
    }

    int index2y(int index) {
        int h = this.getItemHeight();
        return 2 + (index - this.vsb.getValue()) * h + 1;
    }

    boolean validY(int y) {
        int shown = this.itemsDisplayed();
        int lastY = shown * this.getItemHeight() + 2;
        if (shown == this.itemsInWindow()) {
            lastY += 2;
        }
        return y >= 0 && y < lastY;
    }

    int posInSel(int index) {
        for (int i = 0; i < this.selected.length; ++i) {
            if (index != this.selected[i]) continue;
            return i;
        }
        return -1;
    }

    boolean isIndexDisplayed(int idx) {
        int lastDisplayed = this.lastItemDisplayed();
        return idx <= lastDisplayed && idx >= Math.max(0, lastDisplayed - this.itemsInWindow() + 1);
    }

    int lastItemDisplayed() {
        int n = this.itemsInWindow();
        return Math.min(this.items.size() - 1, this.vsb.getValue() + n - 1);
    }

    boolean isItemHidden(int index) {
        return index < this.vsb.getValue() || index >= this.vsb.getValue() + this.itemsInWindow();
    }

    int getListWidth() {
        return this.vsbVis ? this.width - 17 : this.width;
    }

    int itemsDisplayed() {
        return Math.min(this.items.size() - this.vsb.getValue(), this.itemsInWindow());
    }

    void scrollVertical(int y) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("Scrolling vertically by " + y);
        }
        int itemsInWin = this.itemsInWindow();
        int h = this.getItemHeight();
        int pixelsToScroll = y * h;
        if (this.vsb.getValue() < -y) {
            y = -this.vsb.getValue();
        }
        this.vsb.setValue(this.vsb.getValue() + y);
        Rectangle source = null;
        Point distance = null;
        int firstItem = 0;
        int lastItem = 0;
        int options = 90;
        if (y > 0) {
            if (y < itemsInWin) {
                source = new Rectangle(2, 2 + pixelsToScroll, this.width - 17, h * (itemsInWin - y - 1) - 1);
                distance = new Point(0, -pixelsToScroll);
                options |= 0x80;
            }
            firstItem = this.vsb.getValue() + itemsInWin - y - 1;
            lastItem = this.vsb.getValue() + itemsInWin - 1;
        } else if (y < 0) {
            if (y + this.itemsInWindow() > 0) {
                source = new Rectangle(2, 2, this.width - 17, h * (itemsInWin + y));
                distance = new Point(0, -pixelsToScroll);
                options |= 0x80;
            }
            firstItem = this.vsb.getValue();
            lastItem = Math.min(this.getLastVisibleItem(), this.vsb.getValue() + -y);
        }
        this.repaint(firstItem, lastItem, options, source, distance);
    }

    void scrollHorizontal(int x) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("Scrolling horizontally by " + this.y);
        }
        int w = this.getListWidth();
        w -= 6;
        int h = this.height - 21;
        this.hsb.setValue(this.hsb.getValue() + x);
        int options = 12;
        Rectangle source = null;
        Point distance = null;
        if (x < 0) {
            source = new Rectangle(3, 2, w + x, h);
            distance = new Point(-x, 0);
            options |= 0x80;
        } else if (x > 0) {
            source = new Rectangle(3 + x, 2, w - x, h);
            distance = new Point(-x, 0);
            options |= 0x80;
        }
        this.repaint(this.vsb.getValue(), this.lastItemDisplayed(), options, source, distance);
    }

    int y2index(int y) {
        int last;
        if (!this.validY(y)) {
            return -1;
        }
        int i = (y - 2) / this.getItemHeight() + this.vsb.getValue();
        if (i > (last = this.lastItemDisplayed())) {
            i = last;
        }
        return i;
    }

    boolean isSelected(int index) {
        if (this.eventType == 1 && index == this.eventIndex) {
            return true;
        }
        for (int i = 0; i < this.selected.length; ++i) {
            if (this.selected[i] != index) continue;
            return true;
        }
        return false;
    }

    int itemsInWindow(boolean scrollbarVisible) {
        int h = scrollbarVisible ? this.height - 21 : this.height - 4;
        return h / this.getItemHeight();
    }

    int itemsInWindow() {
        return this.itemsInWindow(this.hsbVis);
    }

    boolean inHorizontalScrollbar(int x, int y) {
        int w = this.getListWidth();
        int h = this.height - 13;
        return this.hsbVis && x >= 0 && x <= w && y > h;
    }

    boolean inVerticalScrollbar(int x, int y) {
        int w = this.width - 13;
        int h = this.hsbVis ? this.height - 17 : this.height;
        return this.vsbVis && x > w && y >= 0 && y <= h;
    }

    boolean inWindow(int x, int y) {
        int w = this.getListWidth();
        int h = this.hsbVis ? this.height - 17 : this.height;
        return x >= 0 && x <= w && y >= 0 && y <= h;
    }

    boolean vsbIsVisible(boolean hsbVisible) {
        return this.items.size() > this.itemsInWindow(hsbVisible);
    }

    boolean hsbIsVisible(boolean vsbVisible) {
        int w = this.width - (6 + (vsbVisible ? 17 : 0));
        return this.maxLength > w;
    }

    @Override
    boolean prePostEvent(AWTEvent e) {
        if (e instanceof MouseEvent) {
            return this.prePostMouseEvent((MouseEvent)e);
        }
        return super.prePostEvent(e);
    }

    boolean prePostMouseEvent(MouseEvent me) {
        if (this.getToplevelXWindow().isModalBlocked()) {
            return false;
        }
        int eventId = me.getID();
        if (eventId != 503) {
            if ((eventId == 506 || eventId == 502) && this.isScrollBarOriginated) {
                if (eventId == 502) {
                    this.isScrollBarOriginated = false;
                }
                this.handleJavaMouseEventOnEDT(me);
                return true;
            }
            if ((eventId == 501 || eventId == 500) && (this.inVerticalScrollbar(me.getX(), me.getY()) || this.inHorizontalScrollbar(me.getX(), me.getY()))) {
                if (eventId == 501) {
                    this.isScrollBarOriginated = true;
                }
                this.handleJavaMouseEventOnEDT(me);
                return true;
            }
        }
        return false;
    }

    void handleJavaMouseEventOnEDT(final MouseEvent me) {
        InvocationEvent ev = new InvocationEvent((Object)this.target, new Runnable(){

            @Override
            public void run() {
                XListPeer.this.handleJavaMouseEvent(me);
            }
        });
        this.postEvent(ev);
    }

    @Override
    public void setFont(Font f) {
        if (!Objects.equals(this.getFont(), f)) {
            super.setFont(f);
            this.initFontMetrics();
            this.layout();
            this.repaint();
        }
    }

    class ListPainter {
        VolatileImage buffer;
        Color[] colors;
        private Rectangle prevFocusRect;

        ListPainter() {
        }

        private Color getListForeground() {
            if (XListPeer.this.fgColorSet) {
                return this.colors[3];
            }
            return SystemColor.textText;
        }

        private Color getListBackground() {
            if (XListPeer.this.bgColorSet) {
                return this.colors[0];
            }
            return SystemColor.text;
        }

        private Color getDisabledColor() {
            Color backgroundColor = this.getListBackground();
            Color foregroundColor = this.getListForeground();
            return backgroundColor.equals(Color.BLACK) ? foregroundColor.darker() : backgroundColor.darker();
        }

        private boolean createBuffer() {
            VolatileImage localBuffer = null;
            XToolkit.awtLock();
            try {
                localBuffer = this.buffer;
            }
            finally {
                XToolkit.awtUnlock();
            }
            if (localBuffer == null) {
                if (log.isLoggable(PlatformLogger.Level.FINE)) {
                    log.fine("Creating buffer " + XListPeer.this.width + "x" + XListPeer.this.height);
                }
                localBuffer = XListPeer.this.graphicsConfig.createCompatibleVolatileImage(XListPeer.this.width + 1, XListPeer.this.height + 1);
            }
            XToolkit.awtLock();
            try {
                if (this.buffer == null) {
                    this.buffer = localBuffer;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                XToolkit.awtUnlock();
            }
            return false;
        }

        public void invalidate() {
            XToolkit.awtLock();
            try {
                if (this.buffer != null) {
                    this.buffer.flush();
                }
                this.buffer = null;
            }
            finally {
                XToolkit.awtUnlock();
            }
        }

        private void paint(Graphics listG, int firstItem, int lastItem, int options) {
            this.paint(listG, firstItem, lastItem, options, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void paint(Graphics listG, int firstItem, int lastItem, int options, Rectangle source, Point distance) {
            if (log.isLoggable(PlatformLogger.Level.FINER)) {
                log.finer("Repaint from " + firstItem + " to " + lastItem + " options " + options);
            }
            if (firstItem > lastItem) {
                int t = lastItem;
                lastItem = firstItem;
                firstItem = t;
            }
            if (firstItem < 0) {
                firstItem = 0;
            }
            this.colors = XListPeer.this.getGUIcolors();
            VolatileImage localBuffer = null;
            block10: do {
                XToolkit.awtLock();
                try {
                    if (this.createBuffer()) {
                        options = 62;
                    }
                    localBuffer = this.buffer;
                }
                finally {
                    XToolkit.awtUnlock();
                }
                switch (localBuffer.validate(XListPeer.this.getGraphicsConfiguration())) {
                    case 2: {
                        this.invalidate();
                        options = 62;
                        break;
                    }
                    case 1: {
                        options = 62;
                    }
                    default: {
                        Graphics2D g = localBuffer.createGraphics();
                        try {
                            g.setFont(XListPeer.this.getFont());
                            if ((options & 0x40) != 0) {
                                this.paintFocus(g, 64);
                            }
                            if ((options & 0x80) != 0) {
                                g.copyArea(source.x, source.y, source.width, source.height, distance.x, distance.y);
                            }
                            if ((options & 0x20) != 0) {
                                this.paintBackground(g);
                                firstItem = XListPeer.this.getFirstVisibleItem();
                                lastItem = XListPeer.this.getLastVisibleItem();
                            }
                            if ((options & 8) != 0) {
                                this.paintItems(g, firstItem, lastItem, options);
                            }
                            if ((options & 2) != 0 && XListPeer.this.vsbVis) {
                                g.setClip(XListPeer.this.getVScrollBarRec());
                                this.paintVerScrollbar(g, true);
                            }
                            if ((options & 4) != 0 && XListPeer.this.hsbVis) {
                                g.setClip(XListPeer.this.getHScrollBarRec());
                                this.paintHorScrollbar(g, true);
                            }
                            if ((options & 0x10) == 0) continue block10;
                            this.paintFocus(g, 16);
                            continue block10;
                        }
                        finally {
                            g.dispose();
                        }
                    }
                }
            } while (localBuffer.contentsLost());
            listG.drawImage(localBuffer, 0, 0, null);
        }

        private void paintBackground(Graphics g) {
            g.setColor(SystemColor.window);
            g.fillRect(0, 0, XListPeer.this.width, XListPeer.this.height);
            g.setColor(this.getListBackground());
            g.fillRect(0, 0, XListPeer.this.listWidth, XListPeer.this.listHeight);
            XListPeer.this.draw3DRect(g, XComponentPeer.getSystemColors(), 0, 0, XListPeer.this.listWidth - 1, XListPeer.this.listHeight - 1, false);
        }

        private void paintItems(Graphics g, int firstItem, int lastItem, int options) {
            if (log.isLoggable(PlatformLogger.Level.FINER)) {
                log.finer("Painting items from " + firstItem + " to " + lastItem + ", focused " + XListPeer.this.focusIndex + ", first " + XListPeer.this.getFirstVisibleItem() + ", last " + XListPeer.this.getLastVisibleItem());
            }
            if ((firstItem = Math.max(XListPeer.this.getFirstVisibleItem(), firstItem)) > lastItem) {
                int t = lastItem;
                lastItem = firstItem;
                firstItem = t;
            }
            firstItem = Math.max(XListPeer.this.getFirstVisibleItem(), firstItem);
            lastItem = Math.min(lastItem, XListPeer.this.items.size() - 1);
            if (log.isLoggable(PlatformLogger.Level.FINER)) {
                log.finer("Actually painting items from " + firstItem + " to " + lastItem + ", items in window " + XListPeer.this.itemsInWindow());
            }
            for (int i = firstItem; i <= lastItem; ++i) {
                this.paintItem(g, i);
            }
        }

        private void paintItem(Graphics g, int index) {
            if (log.isLoggable(PlatformLogger.Level.FINEST)) {
                log.finest("Painting item " + index);
            }
            if (!XListPeer.this.isItemHidden(index)) {
                Shape clip = g.getClip();
                int w = XListPeer.this.getItemWidth();
                int h = XListPeer.this.getItemHeight();
                int y = XListPeer.this.getItemY(index);
                int x = XListPeer.this.getItemX();
                if (log.isLoggable(PlatformLogger.Level.FINEST)) {
                    log.finest("Setting clip " + new Rectangle(x, y, w - 2, h - 2));
                }
                g.setClip(x, y, w - 2, h - 2);
                if (XListPeer.this.isSelected(index)) {
                    if (log.isLoggable(PlatformLogger.Level.FINEST)) {
                        log.finest("Painted item is selected");
                    }
                    g.setColor(this.getListForeground());
                } else {
                    g.setColor(this.getListBackground());
                }
                if (log.isLoggable(PlatformLogger.Level.FINEST)) {
                    log.finest("Filling " + new Rectangle(x, y, w, h));
                }
                g.fillRect(x, y, w, h);
                if (index <= XListPeer.this.getLastVisibleItem() && index < XListPeer.this.items.size()) {
                    if (!XListPeer.this.isEnabled()) {
                        g.setColor(this.getDisabledColor());
                    } else if (XListPeer.this.isSelected(index)) {
                        g.setColor(this.getListBackground());
                    } else {
                        g.setColor(this.getListForeground());
                    }
                    String str = (String)XListPeer.this.items.elementAt(index);
                    g.drawString(str, x - XListPeer.this.hsb.getValue(), y + XListPeer.this.fontAscent);
                } else {
                    g.setClip(x, y, XListPeer.this.listWidth, h);
                    g.setColor(this.getListBackground());
                    g.fillRect(x, y, XListPeer.this.listWidth, h);
                }
                g.setClip(clip);
            }
        }

        void paintScrollBar(XScrollbar scr, Graphics g, int x, int y, int width, int height, boolean paintAll) {
            if (log.isLoggable(PlatformLogger.Level.FINEST)) {
                log.finest("Painting scrollbar " + scr + " width " + width + " height " + height + ", paintAll " + paintAll);
            }
            g.translate(x, y);
            scr.paint(g, XComponentPeer.getSystemColors(), paintAll);
            g.translate(-x, -y);
        }

        void paintHorScrollbar(Graphics g, boolean paintAll) {
            int w = XListPeer.this.getListWidth();
            this.paintScrollBar(XListPeer.this.hsb, g, 0, XListPeer.this.height - 13, w, 13, paintAll);
        }

        void paintVerScrollbar(Graphics g, boolean paintAll) {
            int h = XListPeer.this.height - (XListPeer.this.hsbVis ? 15 : 0);
            this.paintScrollBar(XListPeer.this.vsb, g, XListPeer.this.width - 13, 0, 11, h, paintAll);
        }

        private void paintFocus(Graphics g, int options) {
            boolean paintFocus;
            boolean bl = paintFocus = (options & 0x10) != 0;
            if (paintFocus && !XListPeer.this.hasFocus()) {
                paintFocus = false;
            }
            if (log.isLoggable(PlatformLogger.Level.FINE)) {
                log.fine("Painting focus, focus index " + XListPeer.this.getFocusIndex() + ", focus is " + (XListPeer.this.isItemHidden(XListPeer.this.getFocusIndex()) ? "invisible" : "visible") + ", paint focus is " + paintFocus);
            }
            Shape clip = g.getClip();
            g.setClip(0, 0, XListPeer.this.listWidth, XListPeer.this.listHeight);
            if (log.isLoggable(PlatformLogger.Level.FINEST)) {
                log.finest("Setting focus clip " + new Rectangle(0, 0, XListPeer.this.listWidth, XListPeer.this.listHeight));
            }
            Rectangle rect = XListPeer.this.getFocusRect();
            if (this.prevFocusRect != null) {
                if (log.isLoggable(PlatformLogger.Level.FINEST)) {
                    log.finest("Erasing previous focus rect " + this.prevFocusRect);
                }
                g.setColor(this.getListBackground());
                g.drawRect(this.prevFocusRect.x, this.prevFocusRect.y, this.prevFocusRect.width, this.prevFocusRect.height);
                this.prevFocusRect = null;
            }
            if (paintFocus) {
                if (log.isLoggable(PlatformLogger.Level.FINEST)) {
                    log.finest("Painting focus rect " + rect);
                }
                g.setColor(this.getListForeground());
                g.drawRect(rect.x, rect.y, rect.width, rect.height);
                this.prevFocusRect = rect;
            }
            g.setClip(clip);
        }
    }
}

