/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import sun.awt.image.ImageDecoder;
import sun.awt.image.ImageFormatException;
import sun.awt.image.InputStreamImageSource;

public class JPEGImageDecoder
extends ImageDecoder {
    private static ColorModel RGBcolormodel;
    private static ColorModel ARGBcolormodel;
    private static ColorModel Graycolormodel;
    private static final Class InputStreamClass;
    private ColorModel colormodel;
    Hashtable props = new Hashtable();
    private static final int hintflags = 22;

    private static native void initIDs(Class var0);

    private native void readImage(InputStream var1, byte[] var2) throws ImageFormatException, IOException;

    public JPEGImageDecoder(InputStreamImageSource src, InputStream is) {
        super(src, is);
    }

    private static void error(String s1) throws ImageFormatException {
        throw new ImageFormatException(s1);
    }

    public boolean sendHeaderInfo(int width, int height, boolean gray, boolean hasalpha, boolean multipass) {
        this.setDimensions(width, height);
        this.setProperties(this.props);
        this.colormodel = gray ? Graycolormodel : (hasalpha ? ARGBcolormodel : RGBcolormodel);
        this.setColorModel(this.colormodel);
        int flags = 22;
        if (!multipass) {
            flags |= 8;
        }
        this.setHints(22);
        this.headerComplete();
        return true;
    }

    public boolean sendPixels(int[] pixels, int y) {
        int count = this.setPixels(0, y, pixels.length, 1, this.colormodel, pixels, 0, pixels.length);
        if (count <= 0) {
            this.aborted = true;
        }
        return !this.aborted;
    }

    public boolean sendPixels(byte[] pixels, int y) {
        int count = this.setPixels(0, y, pixels.length, 1, this.colormodel, pixels, 0, pixels.length);
        if (count <= 0) {
            this.aborted = true;
        }
        return !this.aborted;
    }

    @Override
    public void produceImage() throws IOException, ImageFormatException {
        try {
            this.readImage(this.input, new byte[1024]);
            if (!this.aborted) {
                this.imageComplete(3, true);
            }
        }
        catch (IOException e) {
            if (!this.aborted) {
                throw e;
            }
        }
        finally {
            this.close();
        }
    }

    static {
        InputStreamClass = InputStream.class;
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("javajpeg");
                return null;
            }
        });
        JPEGImageDecoder.initIDs(InputStreamClass);
        RGBcolormodel = new DirectColorModel(24, 0xFF0000, 65280, 255);
        ARGBcolormodel = ColorModel.getRGBdefault();
        byte[] g = new byte[256];
        for (int i = 0; i < 256; ++i) {
            g[i] = (byte)i;
        }
        Graycolormodel = new IndexColorModel(8, 256, g, g, g);
    }
}

