/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.io.File;
import java.io.OutputStream;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import sun.awt.AppContext;
import sun.misc.ThreadGroupUtils;

public class CreatedFontTracker {
    public static final int MAX_FILE_SIZE = 0x2000000;
    public static final int MAX_TOTAL_BYTES = 0x14000000;
    static CreatedFontTracker tracker;
    int numBytes = 0;

    public static synchronized CreatedFontTracker getTracker() {
        if (tracker == null) {
            tracker = new CreatedFontTracker();
        }
        return tracker;
    }

    private CreatedFontTracker() {
    }

    public synchronized int getNumBytes() {
        return this.numBytes;
    }

    public synchronized void addBytes(int sz) {
        this.numBytes += sz;
    }

    public synchronized void subBytes(int sz) {
        this.numBytes -= sz;
    }

    private static synchronized Semaphore getCS() {
        AppContext appContext = AppContext.getAppContext();
        Semaphore cs = (Semaphore)appContext.get(CreatedFontTracker.class);
        if (cs == null) {
            cs = new Semaphore(5, true);
            appContext.put(CreatedFontTracker.class, cs);
        }
        return cs;
    }

    public boolean acquirePermit() throws InterruptedException {
        return CreatedFontTracker.getCS().tryAcquire(120L, TimeUnit.SECONDS);
    }

    public void releasePermit() {
        CreatedFontTracker.getCS().release();
    }

    public void add(File file) {
        TempFileDeletionHook.add(file);
    }

    public void set(File file, OutputStream os) {
        TempFileDeletionHook.set(file, os);
    }

    public void remove(File file) {
        TempFileDeletionHook.remove(file);
    }

    private static class TempFileDeletionHook {
        private static HashMap<File, OutputStream> files = new HashMap();
        private static Thread t = null;

        static void init() {
            if (t == null) {
                AccessController.doPrivileged(() -> {
                    ThreadGroup rootTG = ThreadGroupUtils.getRootThreadGroup();
                    t = new Thread(rootTG, TempFileDeletionHook::runHooks);
                    t.setContextClassLoader(null);
                    Runtime.getRuntime().addShutdownHook(t);
                    return null;
                });
            }
        }

        private TempFileDeletionHook() {
        }

        static synchronized void add(File file) {
            TempFileDeletionHook.init();
            files.put(file, null);
        }

        static synchronized void set(File file, OutputStream os) {
            files.put(file, os);
        }

        static synchronized void remove(File file) {
            files.remove(file);
        }

        static synchronized void runHooks() {
            if (files.isEmpty()) {
                return;
            }
            for (Map.Entry<File, OutputStream> entry : files.entrySet()) {
                try {
                    if (entry.getValue() != null) {
                        entry.getValue().close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                entry.getKey().delete();
            }
        }
    }
}

