/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.nio.ByteBuffer;
import java.util.Locale;
import sun.font.CMap;
import sun.font.CharToGlyphMapper;
import sun.font.FontUtilities;
import sun.font.SunFontManager;
import sun.font.TrueTypeFont;

public class TrueTypeGlyphMapper
extends CharToGlyphMapper {
    static final char REVERSE_SOLIDUS = '\\';
    static final char JA_YEN = '\u00a5';
    static final char JA_FULLWIDTH_TILDE_CHAR = '\uff5e';
    static final char JA_WAVE_DASH_CHAR = '\u301c';
    static final boolean isJAlocale = Locale.JAPAN.equals(Locale.getDefault());
    private final boolean needsJAremapping;
    private boolean remapJAWaveDash;
    TrueTypeFont font;
    CMap cmap;
    int numGlyphs;

    public TrueTypeGlyphMapper(TrueTypeFont font) {
        this.font = font;
        try {
            this.cmap = CMap.initialize(font);
        }
        catch (Exception e) {
            this.cmap = null;
        }
        if (this.cmap == null) {
            this.handleBadCMAP();
        }
        this.missingGlyph = 0;
        ByteBuffer buffer = font.getTableBuffer(1835104368);
        if (buffer != null && buffer.capacity() >= 6) {
            this.numGlyphs = buffer.getChar(4);
        } else {
            this.handleBadCMAP();
        }
        if (FontUtilities.isSolaris && isJAlocale && font.supportsJA()) {
            this.needsJAremapping = true;
            if (FontUtilities.isSolaris8 && this.getGlyphFromCMAP(12316) == this.missingGlyph) {
                this.remapJAWaveDash = true;
            }
        } else {
            this.needsJAremapping = false;
        }
    }

    @Override
    public int getNumGlyphs() {
        return this.numGlyphs;
    }

    private char getGlyphFromCMAP(int charCode) {
        try {
            char glyphCode = this.cmap.getGlyph(charCode);
            if (glyphCode < this.numGlyphs || glyphCode >= '\ufffe') {
                return glyphCode;
            }
            if (FontUtilities.isLogging()) {
                FontUtilities.getLogger().warning(this.font + " out of range glyph id=" + Integer.toHexString(glyphCode) + " for char " + Integer.toHexString(charCode));
            }
            return (char)this.missingGlyph;
        }
        catch (Exception e) {
            this.handleBadCMAP();
            return (char)this.missingGlyph;
        }
    }

    private void handleBadCMAP() {
        if (FontUtilities.isLogging()) {
            FontUtilities.getLogger().severe("Null Cmap for " + this.font + "substituting for this font");
        }
        SunFontManager.getInstance().deRegisterBadFont(this.font);
        this.cmap = CMap.theNullCmap;
    }

    private final char remapJAChar(char unicode) {
        switch (unicode) {
            case '\\': {
                return '\u00a5';
            }
            case '\u301c': {
                if (!this.remapJAWaveDash) break;
                return '\uff5e';
            }
        }
        return unicode;
    }

    private final int remapJAIntChar(int unicode) {
        switch (unicode) {
            case 92: {
                return 165;
            }
            case 12316: {
                if (!this.remapJAWaveDash) break;
                return 65374;
            }
        }
        return unicode;
    }

    @Override
    public int charToGlyph(char unicode) {
        if (this.needsJAremapping) {
            unicode = this.remapJAChar(unicode);
        }
        char glyph = this.getGlyphFromCMAP(unicode);
        if (this.font.checkUseNatives() && glyph < this.font.glyphToCharMap.length) {
            this.font.glyphToCharMap[glyph] = unicode;
        }
        return glyph;
    }

    @Override
    public int charToGlyph(int unicode) {
        if (this.needsJAremapping) {
            unicode = this.remapJAIntChar(unicode);
        }
        char glyph = this.getGlyphFromCMAP(unicode);
        if (this.font.checkUseNatives() && glyph < this.font.glyphToCharMap.length) {
            this.font.glyphToCharMap[glyph] = (char)unicode;
        }
        return glyph;
    }

    @Override
    public void charsToGlyphs(int count, int[] unicodes, int[] glyphs) {
        for (int i = 0; i < count; ++i) {
            glyphs[i] = this.needsJAremapping ? (int)this.getGlyphFromCMAP(this.remapJAIntChar(unicodes[i])) : (int)this.getGlyphFromCMAP(unicodes[i]);
            if (!this.font.checkUseNatives() || glyphs[i] >= this.font.glyphToCharMap.length) continue;
            this.font.glyphToCharMap[glyphs[i]] = (char)unicodes[i];
        }
    }

    @Override
    public void charsToGlyphs(int count, char[] unicodes, int[] glyphs) {
        for (int i = 0; i < count; ++i) {
            char low;
            int code = this.needsJAremapping ? this.remapJAChar(unicodes[i]) : unicodes[i];
            if (code >= 55296 && code <= 56319 && i < count - 1 && (low = unicodes[i + 1]) >= '\udc00' && low <= '\udfff') {
                code = (code - 55296) * 1024 + low - 56320 + 65536;
                glyphs[i] = this.getGlyphFromCMAP(code);
                glyphs[++i] = 65535;
                continue;
            }
            glyphs[i] = this.getGlyphFromCMAP(code);
            if (!this.font.checkUseNatives() || glyphs[i] >= this.font.glyphToCharMap.length) continue;
            this.font.glyphToCharMap[glyphs[i]] = (char)code;
        }
    }

    @Override
    public boolean charsToGlyphsNS(int count, char[] unicodes, int[] glyphs) {
        for (int i = 0; i < count; ++i) {
            char low;
            int code = this.needsJAremapping ? this.remapJAChar(unicodes[i]) : unicodes[i];
            if (code >= 55296 && code <= 56319 && i < count - 1 && (low = unicodes[i + 1]) >= '\udc00' && low <= '\udfff') {
                code = (code - 55296) * 1024 + low - 56320 + 65536;
                glyphs[i + 1] = 65535;
            }
            glyphs[i] = this.getGlyphFromCMAP(code);
            if (this.font.checkUseNatives() && glyphs[i] < this.font.glyphToCharMap.length) {
                this.font.glyphToCharMap[glyphs[i]] = (char)code;
            }
            if (code < 768) continue;
            if (FontUtilities.isComplexCharCode(code)) {
                return true;
            }
            if (code < 65536) continue;
            ++i;
        }
        return false;
    }

    boolean hasSupplementaryChars() {
        return this.cmap instanceof CMap.CMapFormat8 || this.cmap instanceof CMap.CMapFormat10 || this.cmap instanceof CMap.CMapFormat12;
    }
}

