/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProviderException;
import java.security.SecureRandomSpi;
import java.util.Arrays;
import sun.security.provider.SecureRandom;
import sun.security.provider.SunEntries;
import sun.security.util.Debug;

public final class NativePRNG
extends SecureRandomSpi {
    private static final long serialVersionUID = -6599091113397072932L;
    private static final Debug debug = Debug.getInstance("provider");
    private static final String NAME_RANDOM = "/dev/random";
    private static final String NAME_URANDOM = "/dev/urandom";
    private static final RandomIO INSTANCE = NativePRNG.initIO(Variant.MIXED);

    private static URL getEgdUrl() {
        URL egdUrl;
        block5: {
            String egdSource = SunEntries.getSeedSource();
            if (egdSource.length() != 0) {
                if (debug != null) {
                    debug.println("NativePRNG egdUrl: " + egdSource);
                }
                try {
                    egdUrl = new URL(egdSource);
                    if (!egdUrl.getProtocol().equalsIgnoreCase("file")) {
                        return null;
                    }
                    break block5;
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }
            egdUrl = null;
        }
        return egdUrl;
    }

    private static RandomIO initIO(final Variant v) {
        return AccessController.doPrivileged(new PrivilegedAction<RandomIO>(){

            @Override
            public RandomIO run() {
                File nextFile;
                File seedFile;
                switch (v) {
                    case MIXED: {
                        File egdFile = null;
                        URL egdUrl = NativePRNG.getEgdUrl();
                        if (egdUrl != null) {
                            try {
                                egdFile = SunEntries.getDeviceFile(egdUrl);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        seedFile = egdFile != null && egdFile.canRead() ? egdFile : new File(NativePRNG.NAME_RANDOM);
                        nextFile = new File(NativePRNG.NAME_URANDOM);
                        break;
                    }
                    case BLOCKING: {
                        seedFile = new File(NativePRNG.NAME_RANDOM);
                        nextFile = new File(NativePRNG.NAME_RANDOM);
                        break;
                    }
                    case NONBLOCKING: {
                        seedFile = new File(NativePRNG.NAME_URANDOM);
                        nextFile = new File(NativePRNG.NAME_URANDOM);
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                if (debug != null) {
                    debug.println("NativePRNG." + (Object)((Object)v) + " seedFile: " + seedFile + " nextFile: " + nextFile);
                }
                if (!seedFile.canRead() || !nextFile.canRead()) {
                    if (debug != null) {
                        debug.println("NativePRNG." + (Object)((Object)v) + " Couldn't read Files.");
                    }
                    return null;
                }
                try {
                    return new RandomIO(seedFile, nextFile);
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
    }

    static boolean isAvailable() {
        return INSTANCE != null;
    }

    public NativePRNG() {
        if (INSTANCE == null) {
            throw new AssertionError((Object)"NativePRNG not available");
        }
    }

    @Override
    protected void engineSetSeed(byte[] seed) {
        NativePRNG.INSTANCE.implSetSeed(seed);
    }

    @Override
    protected void engineNextBytes(byte[] bytes) {
        NativePRNG.INSTANCE.implNextBytes(bytes);
    }

    @Override
    protected byte[] engineGenerateSeed(int numBytes) {
        return NativePRNG.INSTANCE.implGenerateSeed(numBytes);
    }

    static /* synthetic */ RandomIO access$600(Variant x0) {
        return NativePRNG.initIO(x0);
    }

    private static class RandomIO {
        private static final long MAX_BUFFER_TIME = 100L;
        private static final int MAX_BUFFER_SIZE = 65536;
        private static final int MIN_BUFFER_SIZE = 32;
        private int bufferSize = 256;
        File seedFile;
        private final InputStream seedIn;
        private final InputStream nextIn;
        private OutputStream seedOut;
        private boolean seedOutInitialized;
        private volatile SecureRandom mixRandom;
        private byte[] nextBuffer;
        private int buffered;
        private long lastRead;
        private int change_buffer = 0;
        private static final int REQ_LIMIT_INC = 1000;
        private static final int REQ_LIMIT_DEC = -100;
        private final Object LOCK_GET_BYTES = new Object();
        private final Object LOCK_GET_SEED = new Object();
        private final Object LOCK_SET_SEED = new Object();

        private RandomIO(File seedFile, File nextFile) throws IOException {
            this.seedFile = seedFile;
            this.seedIn = new FileInputStream(seedFile);
            this.nextIn = new FileInputStream(nextFile);
            this.nextBuffer = new byte[this.bufferSize];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SecureRandom getMixRandom() {
            SecureRandom r = this.mixRandom;
            if (r == null) {
                Object object = this.LOCK_GET_BYTES;
                synchronized (object) {
                    r = this.mixRandom;
                    if (r == null) {
                        r = new SecureRandom();
                        try {
                            byte[] b = new byte[20];
                            RandomIO.readFully(this.nextIn, b);
                            r.engineSetSeed(b);
                        }
                        catch (IOException e) {
                            throw new ProviderException("init failed", e);
                        }
                        this.mixRandom = r;
                    }
                }
            }
            return r;
        }

        private static void readFully(InputStream in, byte[] data) throws IOException {
            int len;
            int k;
            int ofs = 0;
            for (len = data.length; len > 0; len -= k) {
                k = in.read(data, ofs, len);
                if (k <= 0) {
                    throw new EOFException("File(s) closed?");
                }
                ofs += k;
            }
            if (len > 0) {
                throw new IOException("Could not read from file(s)");
            }
        }

        private byte[] implGenerateSeed(int numBytes) {
            Object object = this.LOCK_GET_SEED;
            synchronized (object) {
                try {
                    byte[] b = new byte[numBytes];
                    RandomIO.readFully(this.seedIn, b);
                    return b;
                }
                catch (IOException e) {
                    throw new ProviderException("generateSeed() failed", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void implSetSeed(byte[] seed) {
            Object object = this.LOCK_SET_SEED;
            synchronized (object) {
                if (!this.seedOutInitialized) {
                    this.seedOutInitialized = true;
                    this.seedOut = AccessController.doPrivileged(new PrivilegedAction<OutputStream>(){

                        @Override
                        public OutputStream run() {
                            try {
                                return new FileOutputStream(seedFile, true);
                            }
                            catch (Exception e) {
                                return null;
                            }
                        }
                    });
                }
                if (this.seedOut != null) {
                    try {
                        this.seedOut.write(seed);
                    }
                    catch (IOException e) {
                        throw new ProviderException("setSeed() failed", e);
                    }
                }
                this.getMixRandom().engineSetSeed(seed);
            }
        }

        private void ensureBufferValid() throws IOException {
            long time = System.currentTimeMillis();
            int new_buffer_size = 0;
            if (this.buffered > 0) {
                if (time - this.lastRead < 100L) {
                    return;
                }
                --this.change_buffer;
            } else {
                ++this.change_buffer;
            }
            if (this.change_buffer > 1000) {
                new_buffer_size = this.nextBuffer.length * 2;
            } else if (this.change_buffer < -100) {
                new_buffer_size = this.nextBuffer.length / 2;
            }
            if (new_buffer_size > 0) {
                if (new_buffer_size <= 65536 && new_buffer_size >= 32) {
                    this.nextBuffer = new byte[new_buffer_size];
                    if (debug != null) {
                        debug.println("Buffer size changed to " + new_buffer_size);
                    }
                } else if (debug != null) {
                    debug.println("Buffer reached limit: " + this.nextBuffer.length);
                }
                this.change_buffer = 0;
            }
            this.lastRead = time;
            RandomIO.readFully(this.nextIn, this.nextBuffer);
            this.buffered = this.nextBuffer.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void implNextBytes(byte[] data) {
            try {
                int len;
                this.getMixRandom().engineNextBytes(data);
                int ofs = 0;
                for (int data_len = data.length; data_len > 0; data_len -= len) {
                    byte[] localBuffer;
                    Object object = this.LOCK_GET_BYTES;
                    synchronized (object) {
                        this.ensureBufferValid();
                        int buf_pos = this.nextBuffer.length - this.buffered;
                        if (data_len > this.buffered) {
                            len = this.buffered;
                            this.buffered = 0;
                        } else {
                            len = data_len;
                            this.buffered -= len;
                        }
                        localBuffer = Arrays.copyOfRange(this.nextBuffer, buf_pos, buf_pos + len);
                    }
                    for (int localofs = 0; len > localofs; ++localofs) {
                        int n = ofs++;
                        data[n] = (byte)(data[n] ^ localBuffer[localofs]);
                    }
                }
            }
            catch (IOException e) {
                throw new ProviderException("nextBytes() failed", e);
            }
        }
    }

    public static final class NonBlocking
    extends SecureRandomSpi {
        private static final long serialVersionUID = -1102062982994105487L;
        private static final RandomIO INSTANCE = NativePRNG.access$600(Variant.NONBLOCKING);

        static boolean isAvailable() {
            return INSTANCE != null;
        }

        public NonBlocking() {
            if (INSTANCE == null) {
                throw new AssertionError((Object)"NativePRNG$NonBlocking not available");
            }
        }

        @Override
        protected void engineSetSeed(byte[] seed) {
            NonBlocking.INSTANCE.implSetSeed(seed);
        }

        @Override
        protected void engineNextBytes(byte[] bytes) {
            NonBlocking.INSTANCE.implNextBytes(bytes);
        }

        @Override
        protected byte[] engineGenerateSeed(int numBytes) {
            return NonBlocking.INSTANCE.implGenerateSeed(numBytes);
        }
    }

    public static final class Blocking
    extends SecureRandomSpi {
        private static final long serialVersionUID = -6396183145759983347L;
        private static final RandomIO INSTANCE = NativePRNG.access$600(Variant.BLOCKING);

        static boolean isAvailable() {
            return INSTANCE != null;
        }

        public Blocking() {
            if (INSTANCE == null) {
                throw new AssertionError((Object)"NativePRNG$Blocking not available");
            }
        }

        @Override
        protected void engineSetSeed(byte[] seed) {
            Blocking.INSTANCE.implSetSeed(seed);
        }

        @Override
        protected void engineNextBytes(byte[] bytes) {
            Blocking.INSTANCE.implNextBytes(bytes);
        }

        @Override
        protected byte[] engineGenerateSeed(int numBytes) {
            return Blocking.INSTANCE.implGenerateSeed(numBytes);
        }
    }

    private static enum Variant {
        MIXED,
        BLOCKING,
        NONBLOCKING;

    }
}

