/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale.provider;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.spi.NumberFormatProvider;
import java.util.Currency;
import java.util.Locale;
import java.util.Set;
import sun.util.locale.provider.AvailableLanguageTags;
import sun.util.locale.provider.LocaleProviderAdapter;

public class NumberFormatProviderImpl
extends NumberFormatProvider
implements AvailableLanguageTags {
    private static final int NUMBERSTYLE = 0;
    private static final int CURRENCYSTYLE = 1;
    private static final int PERCENTSTYLE = 2;
    private static final int SCIENTIFICSTYLE = 3;
    private static final int INTEGERSTYLE = 4;
    private final LocaleProviderAdapter.Type type;
    private final Set<String> langtags;

    public NumberFormatProviderImpl(LocaleProviderAdapter.Type type, Set<String> langtags) {
        this.type = type;
        this.langtags = langtags;
    }

    @Override
    public Locale[] getAvailableLocales() {
        return LocaleProviderAdapter.forType(this.type).getAvailableLocales();
    }

    @Override
    public boolean isSupportedLocale(Locale locale) {
        return LocaleProviderAdapter.isSupportedLocale(locale, this.type, this.langtags);
    }

    @Override
    public NumberFormat getCurrencyInstance(Locale locale) {
        return this.getInstance(locale, 1);
    }

    @Override
    public NumberFormat getIntegerInstance(Locale locale) {
        return this.getInstance(locale, 4);
    }

    @Override
    public NumberFormat getNumberInstance(Locale locale) {
        return this.getInstance(locale, 0);
    }

    @Override
    public NumberFormat getPercentInstance(Locale locale) {
        return this.getInstance(locale, 2);
    }

    private NumberFormat getInstance(Locale locale, int choice) {
        if (locale == null) {
            throw new NullPointerException();
        }
        LocaleProviderAdapter adapter = LocaleProviderAdapter.forType(this.type);
        String[] numberPatterns = adapter.getLocaleResources(locale).getNumberPatterns();
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
        int entry = choice == 4 ? 0 : choice;
        DecimalFormat format = new DecimalFormat(numberPatterns[entry], symbols);
        if (choice == 4) {
            format.setMaximumFractionDigits(0);
            format.setDecimalSeparatorAlwaysShown(false);
            format.setParseIntegerOnly(true);
        } else if (choice == 1) {
            NumberFormatProviderImpl.adjustForCurrencyDefaultFractionDigits(format, symbols);
        }
        return format;
    }

    private static void adjustForCurrencyDefaultFractionDigits(DecimalFormat format, DecimalFormatSymbols symbols) {
        int digits;
        Currency currency = symbols.getCurrency();
        if (currency == null) {
            try {
                currency = Currency.getInstance(symbols.getInternationalCurrencySymbol());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (currency != null && (digits = currency.getDefaultFractionDigits()) != -1) {
            int oldMinDigits = format.getMinimumFractionDigits();
            if (oldMinDigits == format.getMaximumFractionDigits()) {
                format.setMinimumFractionDigits(digits);
                format.setMaximumFractionDigits(digits);
            } else {
                format.setMinimumFractionDigits(Math.min(digits, oldMinDigits));
                format.setMaximumFractionDigits(digits);
            }
        }
    }

    @Override
    public Set<String> getAvailableLanguageTags() {
        return this.langtags;
    }
}

