/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.debug.gdbjtag.datamodel;

import ilg.gnuarmeclipse.debug.gdbjtag.Activator;
import ilg.gnuarmeclipse.debug.gdbjtag.datamodel.SvdDerivedFromPath;
import ilg.gnuarmeclipse.debug.gdbjtag.datamodel.SvdEnumeratedValueDMNode;
import ilg.gnuarmeclipse.debug.gdbjtag.datamodel.SvdObjectDMNode;
import ilg.gnuarmeclipse.packs.core.tree.AbstractTreePreOrderIterator;
import ilg.gnuarmeclipse.packs.core.tree.Leaf;
import ilg.gnuarmeclipse.packs.core.tree.Node;
import java.util.LinkedList;

public class SvdEnumerationDMNode
extends SvdObjectDMNode {
    private String fUsage = null;
    private SvdEnumeratedValueDMNode fDefaultEnumerationNode = null;

    public SvdEnumerationDMNode(Leaf node) {
        super(node);
        this.getChildren();
    }

    @Override
    public void dispose() {
        this.fUsage = null;
        if (this.fDefaultEnumerationNode != null) {
            this.fDefaultEnumerationNode.dispose();
            this.fDefaultEnumerationNode = null;
        }
        super.dispose();
    }

    @Override
    protected SvdObjectDMNode[] prepareChildren(Leaf node) {
        if (node == null) {
            return null;
        }
        Leaf startNode = this.getDerivedFromNode();
        if (startNode == null) {
            startNode = node;
        }
        if (!startNode.hasChildren()) {
            return null;
        }
        LinkedList<SvdEnumeratedValueDMNode> list = new LinkedList<SvdEnumeratedValueDMNode>();
        for (Leaf child : ((Node)startNode).getChildren()) {
            if (!child.isType("enumeratedValue")) continue;
            SvdEnumeratedValueDMNode enumeratedValue = new SvdEnumeratedValueDMNode(child);
            String value = enumeratedValue.getValue();
            if (!value.isEmpty()) {
                list.add(enumeratedValue);
                continue;
            }
            if (!enumeratedValue.isDefault()) continue;
            if (this.fDefaultEnumerationNode == null) {
                this.fDefaultEnumerationNode = enumeratedValue;
                continue;
            }
            Activator.log((String)("duplicate isDefault enumeratedValue " + enumeratedValue.getName()));
        }
        SvdObjectDMNode[] array = list.toArray(new SvdObjectDMNode[list.size()]);
        return array;
    }

    @Override
    protected Leaf findDerivedFromNode() {
        String derivedFromName = this.getNode().getPropertyOrNull("derivedFrom");
        final SvdDerivedFromPath path = SvdDerivedFromPath.createEnumerationPath(derivedFromName);
        if (path == null) {
            return null;
        }
        Node root = this.getNode().getParent();
        while (!root.isType("device")) {
            root = root.getParent();
        }
        AbstractTreePreOrderIterator peripheralNodes = new AbstractTreePreOrderIterator(){

            public boolean isIterable(Leaf node) {
                if (node.isType("peripherals")) {
                    return true;
                }
                if (node.isType("peripheral")) {
                    if (path.peripheralName == null) {
                        return true;
                    }
                    return path.peripheralName.equals(node.getProperty("name"));
                }
                if (node.isType("registers")) {
                    return true;
                }
                if (node.isType("cluster")) {
                    return true;
                }
                if (node.isType("register")) {
                    if (path.registerName == null) {
                        return true;
                    }
                    return path.registerName.equals(node.getProperty("name"));
                }
                if (node.isType("fields")) {
                    return true;
                }
                if (node.isType("field")) {
                    if (path.fieldName == null) {
                        return true;
                    }
                    return path.fieldName.equals(node.getProperty("name"));
                }
                if (node.isType("enumeratedValues")) {
                    if (path.enumerationName == null) {
                        return true;
                    }
                    return path.enumerationName.equals(node.getProperty("name"));
                }
                return false;
            }

            public boolean isLeaf(Leaf node) {
                return node.isType("enumeratedValues");
            }
        };
        peripheralNodes.setTreeNode((Leaf)root);
        Leaf ret = null;
        for (Leaf node : peripheralNodes) {
            if (!node.isType("enumeratedValues")) continue;
            if (ret == null) {
                ret = node;
                continue;
            }
            Activator.log((String)("Non unique SVD path " + path));
        }
        return ret;
    }

    public SvdEnumeratedValueDMNode getDefaultEnumerationNode() {
        return this.fDefaultEnumerationNode;
    }

    public String getUsage() {
        if (this.fUsage == null) {
            this.fUsage = this.getNode().getProperty("usage");
        }
        if (this.fUsage.isEmpty()) {
            this.fUsage = "read-write";
        }
        return this.fUsage;
    }

    public boolean isUsageRead() {
        return "read".equals(this.getUsage()) || "read-write".equals(this.getUsage());
    }

    public boolean isUsageWrite() {
        return "write".equals(this.getUsage()) || "read-write".equals(this.getUsage());
    }

    @Override
    public String toString() {
        if (this.getName().isEmpty()) {
            return "[" + this.getClass().getSimpleName() + ": \"" + this.getDescription() + "\"]";
        }
        return "[" + this.getClass().getSimpleName() + ": " + this.getName() + ", \"" + this.getDescription() + "\"]";
    }
}

