/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTMacroExpansionLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTReferenceOperator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTypeParameter;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVariableReadWriteFlags;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.rewrite.util.ASTNodes;
import org.eclipse.cdt.internal.corext.refactoring.code.flow.FlowContext;
import org.eclipse.cdt.internal.corext.refactoring.code.flow.FlowInfo;
import org.eclipse.cdt.internal.corext.refactoring.code.flow.InputFlowAnalyzer;
import org.eclipse.cdt.internal.corext.refactoring.code.flow.Selection;
import org.eclipse.cdt.internal.ui.refactoring.NameInformation;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.PreferenceConstants;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IPreferencesService;

public class NodeContainer {
    private final List<IASTNode> nodes = new ArrayList<IASTNode>();
    private List<NameInformation> names;
    private List<NameInformation> interfaceNames;

    public final int size() {
        return this.nodes.size();
    }

    public final boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public void add(IASTNode node) {
        this.nodes.add(node);
    }

    private void findAllNames() {
        if (this.names != null) {
            return;
        }
        this.names = new ArrayList<NameInformation>();
        final int startOffset = this.getStartOffset();
        final int endOffset = this.getEndOffset();
        IPreferencesService preferences = Platform.getPreferencesService();
        final boolean passOutputByPointer = preferences.getBoolean("org.eclipse.cdt.ui", "function_pass_output_parameters_by_pointer", false, PreferenceConstants.getPreferenceScopes(this.getProject()));
        for (IASTNode node : this.nodes) {
            node.accept(new ASTVisitor(){
                {
                    this.shouldVisitNames = true;
                }

                public int visit(IASTName name) {
                    if (name.getPropertyInParent() != IASTFieldReference.FIELD_NAME) {
                        IBinding binding = name.resolveBinding();
                        if (binding instanceof ICPPBinding && !(binding instanceof ICPPTemplateTypeParameter)) {
                            ICPPBinding cppBinding = (ICPPBinding)binding;
                            try {
                                if (!cppBinding.isGloballyQualified()) {
                                    IASTName[] refs;
                                    NameInformation nameInfo = new NameInformation(name);
                                    nameInfo.setPassOutputByPointer(passOutputByPointer);
                                    IASTName[] iASTNameArray = refs = name.getTranslationUnit().getReferences(binding);
                                    int n = refs.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        IASTName ref = iASTNameArray[n2];
                                        nameInfo.addReference(ref, startOffset, endOffset);
                                        ++n2;
                                    }
                                    NodeContainer.this.names.add(nameInfo);
                                }
                            }
                            catch (DOMException e) {
                                Status status = new Status(2, "org.eclipse.cdt.ui", e.getMessage(), (Throwable)e);
                                CUIPlugin.log((IStatus)status);
                            }
                        } else if (binding instanceof IVariable) {
                            IASTName[] refs;
                            NameInformation nameInformation = new NameInformation(name);
                            IASTName[] iASTNameArray = refs = name.getTranslationUnit().getReferences(binding);
                            int n = refs.length;
                            int n3 = 0;
                            while (n3 < n) {
                                IASTName ref = iASTNameArray[n3];
                                nameInformation.addReference(ref, startOffset, endOffset);
                                ++n3;
                            }
                            NodeContainer.this.names.add(nameInformation);
                        }
                    }
                    return super.visit(name);
                }
            });
        }
        for (NameInformation nameInfo : this.names) {
            IASTName name = nameInfo.getName();
            IASTTranslationUnit ast = name.getTranslationUnit();
            IASTName[] nameDeclarations = ast.getDeclarationsInAST(name.resolveBinding());
            if (nameDeclarations.length == 0) continue;
            nameInfo.setDeclarationName(nameDeclarations[nameDeclarations.length - 1]);
        }
    }

    private IProject getProject() {
        ITranslationUnit tu;
        IProject project = null;
        if (this.nodes.isEmpty() && (tu = this.nodes.get(0).getTranslationUnit().getOriginatingTranslationUnit()) != null) {
            project = tu.getCProject().getProject();
        }
        return project;
    }

    private List<NameInformation> getInterfaceNames() {
        if (this.interfaceNames == null) {
            this.findAllNames();
            Set<IVariable> externalReads = this.getVariablesReadOutside();
            HashSet<IASTName> declarations = new HashSet<IASTName>();
            this.interfaceNames = new ArrayList<NameInformation>();
            for (NameInformation nameInfo : this.names) {
                IASTName declarationName = nameInfo.getDeclarationName();
                if (!declarations.add(declarationName)) continue;
                if (this.isDeclaredInSelection(nameInfo)) {
                    if (!externalReads.contains(nameInfo.getName().resolveBinding())) continue;
                    nameInfo.setMustBeReturnValue(true);
                    this.interfaceNames.add(nameInfo);
                    continue;
                }
                IASTDeclarator declarator = (IASTDeclarator)declarationName.getParent();
                if (!NodeContainer.hasReferenceOperator(declarator)) {
                    for (NameInformation n2 : this.names) {
                        int flag;
                        if (n2.getDeclarationName() != declarationName || ((flag = CPPVariableReadWriteFlags.getReadWriteFlags((IASTName)n2.getName())) & 0x40) == 0) continue;
                        nameInfo.setWriteAccess(true);
                        break;
                    }
                    if (nameInfo.isWriteAccess() && externalReads.contains(nameInfo.getName().resolveBinding())) {
                        nameInfo.setOutput(true);
                    }
                }
                this.interfaceNames.add(nameInfo);
            }
        }
        return this.interfaceNames;
    }

    private Set<IVariable> getVariablesReadOutside() {
        if (this.nodes.isEmpty()) {
            return Collections.emptySet();
        }
        IASTNode firstNode = this.nodes.get(0);
        IASTFunctionDefinition enclosingFunction = (IASTFunctionDefinition)CPPVisitor.findAncestorWithType((IASTNode)firstNode, IASTFunctionDefinition.class);
        FlowContext flowContext = new FlowContext(enclosingFunction);
        flowContext.setConsiderAccessMode(true);
        flowContext.setComputeMode(FlowContext.ARGUMENTS);
        Selection selection = Selection.createFromStartEnd(ASTNodes.offset((IASTNode)firstNode), ASTNodes.endOffset((IASTNode)this.nodes.get(this.nodes.size() - 1)));
        InputFlowAnalyzer analyzer = new InputFlowAnalyzer(flowContext, selection, true);
        FlowInfo argInfo = analyzer.perform(enclosingFunction);
        Set<IVariable> variables = argInfo.get(flowContext, 38);
        Iterator<IVariable> iter = variables.iterator();
        while (iter.hasNext()) {
            IVariable var = iter.next();
            try {
                IASTNode scopeNode = ASTInternal.getPhysicalNodeOfScope((IScope)var.getScope());
                if (!selection.covers(scopeNode)) continue;
                iter.remove();
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
        return variables;
    }

    public static boolean hasReferenceOperator(IASTDeclarator declarator) {
        IASTPointerOperator[] operators = declarator.getPointerOperators();
        return operators.length != 0 && operators[operators.length - 1] instanceof ICPPASTReferenceOperator;
    }

    public boolean isDeclaredInSelection(NameInformation nameInfo) {
        IASTName declaration = nameInfo.getDeclarationName();
        if (declaration != null && declaration.toCharArray().length > 0) {
            int declOffset = declaration.getFileLocation().getNodeOffset();
            return declOffset >= this.getStartOffset() && declOffset <= this.getEndOffset();
        }
        return true;
    }

    private List<NameInformation> getInterfaceNames(boolean isReturnValue) {
        List<NameInformation> selectedNames = null;
        for (NameInformation nameInfo : this.getInterfaceNames()) {
            if (nameInfo.mustBeReturnValue() != isReturnValue) continue;
            if (selectedNames == null) {
                selectedNames = new ArrayList<NameInformation>();
            }
            selectedNames.add(nameInfo);
        }
        if (selectedNames == null) {
            selectedNames = Collections.emptyList();
        }
        return selectedNames;
    }

    public List<NameInformation> getParameterCandidates() {
        return this.getInterfaceNames(false);
    }

    public List<NameInformation> getReturnValueCandidates() {
        return this.getInterfaceNames(true);
    }

    public List<IASTNode> getNodesToWrite() {
        return this.nodes;
    }

    public int getStartOffset() {
        return this.getOffset(false);
    }

    public int getStartOffsetIncludingComments() {
        return this.getOffset(true);
    }

    private int getOffset(boolean includeComments) {
        int start = Integer.MAX_VALUE;
        for (IASTNode node : this.nodes) {
            int nodeStart = Integer.MAX_VALUE;
            IASTNodeLocation[] nodeLocations = node.getNodeLocations();
            if (nodeLocations.length != 1) {
                IASTNodeLocation[] iASTNodeLocationArray = nodeLocations;
                int n = nodeLocations.length;
                int n2 = 0;
                while (n2 < n) {
                    int nodeOffset;
                    IASTNodeLocation location = iASTNodeLocationArray[n2];
                    if (location instanceof IASTMacroExpansionLocation) {
                        IASTMacroExpansionLocation macroLoc = (IASTMacroExpansionLocation)location;
                        nodeOffset = macroLoc.asFileLocation().getNodeOffset();
                    } else {
                        nodeOffset = node.getFileLocation().getNodeOffset();
                    }
                    if (nodeOffset < nodeStart) {
                        nodeStart = nodeOffset;
                    }
                    ++n2;
                }
            } else {
                nodeStart = node.getFileLocation().getNodeOffset();
            }
            if (nodeStart >= start) continue;
            start = nodeStart;
        }
        return start;
    }

    public int getEndOffset() {
        return this.getEndOffset(false);
    }

    public int getEndOffsetIncludingComments() {
        return this.getEndOffset(true);
    }

    private int getEndOffset(boolean includeComments) {
        int end = 0;
        for (IASTNode node : this.nodes) {
            IASTNodeLocation[] nodeLocations;
            int fileOffset = 0;
            int length = 0;
            IASTNodeLocation[] iASTNodeLocationArray = nodeLocations = node.getNodeLocations();
            int n = nodeLocations.length;
            int n2 = 0;
            while (n2 < n) {
                int nodeLength;
                int nodeOffset;
                IASTNodeLocation location = iASTNodeLocationArray[n2];
                if (location instanceof IASTMacroExpansionLocation) {
                    IASTMacroExpansionLocation macroLoc = (IASTMacroExpansionLocation)location;
                    nodeOffset = macroLoc.asFileLocation().getNodeOffset();
                    nodeLength = macroLoc.asFileLocation().getNodeLength();
                } else {
                    nodeOffset = location.getNodeOffset();
                    nodeLength = location.getNodeLength();
                }
                if (fileOffset < nodeOffset) {
                    fileOffset = nodeOffset;
                    length = nodeLength;
                }
                ++n2;
            }
            int endNode = fileOffset + length;
            if (endNode <= end) continue;
            end = endNode;
        }
        return end;
    }

    public String toString() {
        return this.nodes.toString();
    }

    public List<NameInformation> getNames() {
        this.findAllNames();
        return this.names;
    }
}

