/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.EScopeKind;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.model.ASTCache;
import org.eclipse.cdt.internal.ui.editor.ASTProvider;
import org.eclipse.cdt.internal.ui.search.CSearchQuery;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.ITextSelection;

public class CSearchTextSelectionQuery
extends CSearchQuery {
    private ITranslationUnit tu;
    private ITextSelection selection;
    private String label;

    public CSearchTextSelectionQuery(ICElement[] scope, ITranslationUnit tu, ITextSelection selection, int flags) {
        super(scope, flags | 8);
        this.tu = tu;
        this.selection = selection;
        this.label = selection.getText();
    }

    @Override
    protected IStatus runWithIndex(final IIndex index, IProgressMonitor monitor) {
        return ASTProvider.getASTProvider().runOnAST((ICElement)this.tu, ASTProvider.WAIT_ACTIVE_ONLY, monitor, new ASTCache.ASTRunnable(){

            public IStatus runOnAST(ILanguage language, IASTTranslationUnit ast) throws CoreException {
                IASTName searchName;
                if (ast != null && (searchName = ast.getNodeSelector(null).findEnclosingName(CSearchTextSelectionQuery.this.selection.getOffset(), CSearchTextSelectionQuery.this.selection.getLength())) != null) {
                    CSearchTextSelectionQuery.this.label = searchName.toString();
                    IBinding binding = searchName.resolveBinding();
                    if (!(binding instanceof IProblemBinding)) {
                        if (binding != null) {
                            IScope scope = null;
                            try {
                                scope = binding.getScope();
                            }
                            catch (DOMException dOMException) {
                                // empty catch block
                            }
                            if (scope != null && scope.getKind() == EScopeKind.eLocal) {
                                CSearchTextSelectionQuery.this.createLocalMatches(ast, binding);
                                return Status.OK_STATUS;
                            }
                        }
                        binding = ast.getIndex().findBinding((IName)searchName);
                        if ((binding = CPPTemplates.findDeclarationForSpecialization((IBinding)binding)) != null) {
                            CSearchTextSelectionQuery.this.label = CSearchTextSelectionQuery.this.labelForBinding(index, binding, CSearchTextSelectionQuery.this.label);
                            CSearchTextSelectionQuery.this.createMatches(index, binding, (IASTNode)searchName);
                            return Status.OK_STATUS;
                        }
                    }
                }
                return Status.OK_STATUS;
            }
        });
    }

    @Override
    public String getResultLabel(int numMatches) {
        return this.getResultLabel(this.label, numMatches);
    }
}

