/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search.actions;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.actions.OpenActionUtil;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.search.actions.OpenDeclarationsJob;
import org.eclipse.cdt.internal.ui.search.actions.SelectionParseAction;
import org.eclipse.cdt.internal.ui.text.CWordFinder;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;

public class OpenDeclarationsAction
extends SelectionParseAction {
    public static boolean sDisallowAmbiguousInput = false;
    ITextSelection fTextSelection;
    private static final ITargetDisambiguator sDefaultDisambiguator = new DialogTargetDisambiguator();

    public OpenDeclarationsAction(CEditor editor) {
        super(editor);
        this.setText(CEditorMessages.OpenDeclarations_label);
        this.setToolTipText(CEditorMessages.OpenDeclarations_tooltip);
        this.setDescription(CEditorMessages.OpenDeclarations_description);
    }

    public void run() {
        OpenDeclarationsJob job = this.createJob(sDefaultDisambiguator);
        if (job != null) {
            job.schedule();
        }
    }

    public void runSync() throws CoreException {
        OpenDeclarationsJob job = this.createJob(sDefaultDisambiguator);
        if (job != null) {
            job.performNavigation((IProgressMonitor)new NullProgressMonitor());
        }
    }

    public void runSync(ITargetDisambiguator targetDisambiguator) throws CoreException {
        OpenDeclarationsJob job = this.createJob(targetDisambiguator);
        if (job != null) {
            job.performNavigation((IProgressMonitor)new NullProgressMonitor());
        }
    }

    private OpenDeclarationsJob createJob(ITargetDisambiguator targetDisambiguator) {
        String text = this.computeSelectedWord();
        OpenDeclarationsJob job = null;
        IWorkingCopy elem = this.fEditor.getInputCElement();
        if (elem instanceof ITranslationUnit && this.fTextSelection != null) {
            job = new OpenDeclarationsJob(this, (ITranslationUnit)elem, this.fTextSelection, text, targetDisambiguator);
        }
        return job;
    }

    private String computeSelectedWord() {
        this.fTextSelection = this.getSelectedStringFromEditor();
        String text = null;
        if (this.fTextSelection != null) {
            if (this.fTextSelection.getLength() > 0) {
                text = this.fTextSelection.getText();
            } else {
                IDocument document = this.fEditor.getDocumentProvider().getDocument((Object)this.fEditor.getEditorInput());
                IRegion reg = CWordFinder.findWord(document, this.fTextSelection.getOffset());
                if (reg != null && reg.getLength() > 0) {
                    try {
                        text = document.get(reg.getOffset(), reg.getLength());
                    }
                    catch (BadLocationException e) {
                        CUIPlugin.log(e);
                    }
                }
            }
        }
        return text;
    }

    private static class DialogTargetDisambiguator
    implements ITargetDisambiguator {
        private DialogTargetDisambiguator() {
        }

        @Override
        public ICElement disambiguateTargets(ICElement[] targets, SelectionParseAction action) {
            return OpenActionUtil.selectCElement(targets, action.getSite().getShell(), CEditorMessages.OpenDeclarationsAction_dialog_title, CEditorMessages.OpenDeclarationsAction_selectMessage, 2182096929L, 0);
        }
    }

    public static interface ITargetDisambiguator {
        public ICElement disambiguateTargets(ICElement[] var1, SelectionParseAction var2);
    }
}

