/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

class SharedTextColors
implements ISharedTextColors {
    private Map fDisplayTable;

    public Color getColor(RGB rgb) {
        Color color;
        Display display;
        HashMap<RGB, Color> colorTable;
        if (rgb == null) {
            return null;
        }
        if (this.fDisplayTable == null) {
            this.fDisplayTable = new HashMap(2);
        }
        if ((colorTable = (HashMap<RGB, Color>)this.fDisplayTable.get(display = Display.getCurrent())) == null) {
            colorTable = new HashMap<RGB, Color>(10);
            this.fDisplayTable.put(display, colorTable);
            display.disposeExec(new Runnable(){

                public void run() {
                    SharedTextColors.this.dispose(display);
                }
            });
        }
        if ((color = (Color)colorTable.get(rgb)) == null) {
            color = new Color((Device)display, rgb);
            colorTable.put(rgb, color);
        }
        return color;
    }

    public void dispose() {
        if (this.fDisplayTable == null) {
            return;
        }
        Iterator iter = this.fDisplayTable.values().iterator();
        while (iter.hasNext()) {
            this.dispose((Map)iter.next());
        }
        this.fDisplayTable = null;
    }

    private void dispose(Display display) {
        if (this.fDisplayTable != null) {
            this.dispose((Map)this.fDisplayTable.remove(display));
        }
    }

    private void dispose(Map colorTable) {
        if (colorTable == null) {
            return;
        }
        Iterator iter = colorTable.values().iterator();
        while (iter.hasNext()) {
            ((Color)iter.next()).dispose();
        }
        colorTable.clear();
    }
}

