/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.core.opxml.sessions;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.linuxtools.internal.oprofile.core.OprofileCorePlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SessionManager {
    public static final String PLUGIN_LOC = OprofileCorePlugin.getDefault().getStateLocation().toOSString();
    public static final String SESSIONS = "sessions";
    public static final String EVENT = "event";
    public static final String SESSION = "session";
    public static final String NAME = "name";
    public static final String CURRENT = "current";
    public static final String OPXML_PREFIX = String.valueOf(PLUGIN_LOC) + "/opxml_";
    public static final String SESSION_LOCATION = String.valueOf(OPXML_PREFIX) + "sessions";
    public static final String MODEL_DATA = "model-data";
    public Document doc;
    public Element root;
    public String absfilePath;

    public SessionManager(String filePath) {
        this(new File(filePath));
        this.absfilePath = filePath;
        this.write();
    }

    public SessionManager(File file) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            if (!file.exists()) {
                file.createNewFile();
                this.doc = builder.newDocument();
                this.root = this.doc.createElement(SESSIONS);
                this.doc.appendChild(this.root);
            } else {
                Element elem;
                FileInputStream is = new FileInputStream(file);
                this.doc = builder.parse(is);
                this.root = elem = (Element)this.doc.getElementsByTagName(SESSIONS).item(0);
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
        }
    }

    public void addSession(String sessionName, String eventName) {
        Element event = null;
        Element session = this.find(this.root, SESSION, NAME, sessionName);
        if (session == null) {
            session = this.doc.createElement(SESSION);
            session.setAttribute(NAME, sessionName);
            this.root.appendChild(session);
        } else {
            event = this.find(session, EVENT, NAME, eventName);
        }
        if (event == null) {
            event = this.doc.createElement(EVENT);
            event.setAttribute(NAME, eventName);
            session.appendChild(event);
        }
    }

    public boolean existsSession(String sessionName) {
        return this.find(this.root, SESSION, NAME, sessionName) != null;
    }

    private Element find(Element elem, String tagName, String attName, String attVal) {
        NodeList list = elem.getElementsByTagName(tagName);
        int i = 0;
        while (i < list.getLength()) {
            Element e;
            if (list.item(i) instanceof Element && (e = (Element)list.item(i)).getAttribute(attName).equals(attVal)) {
                return e;
            }
            ++i;
        }
        return null;
    }

    public void removeAllCurrentSessions() {
        NodeList sessionList = this.root.getElementsByTagName(SESSION);
        int i = 0;
        while (i < sessionList.getLength()) {
            Element session = (Element)sessionList.item(i);
            String sessionName = session.getAttribute(NAME);
            if (CURRENT.equals(sessionName)) {
                NodeList eventList = session.getElementsByTagName(EVENT);
                int j = 0;
                while (j < eventList.getLength()) {
                    Element event = (Element)eventList.item(j);
                    String eventName = event.getAttribute(NAME);
                    session.removeChild(event);
                    File file = new File(String.valueOf(OPXML_PREFIX) + MODEL_DATA + eventName + CURRENT);
                    file.delete();
                    if (sessionList.getLength() == 0) {
                        this.root.removeChild(session);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public void removeSession(String sessionName, String eventName) {
        NodeList list = this.root.getElementsByTagName(SESSION);
        int i = 0;
        while (i < list.getLength()) {
            Element event;
            Element session;
            if (list.item(i) instanceof Element && (session = (Element)list.item(i)).getAttribute(NAME).equals(sessionName) && (event = this.find((Element)list.item(i), EVENT, NAME, eventName)) != null) {
                this.removeSessionHelper(sessionName, event);
            }
            ++i;
        }
    }

    private void removeSessionHelper(String sessionName, Element elem) {
        NodeList list = this.root.getElementsByTagName(SESSION);
        int i = 0;
        while (i < list.getLength()) {
            Element e;
            if (list.item(i) instanceof Element && (e = (Element)list.item(i)).getAttribute(NAME).equals(sessionName)) {
                NodeList events = e.getElementsByTagName(EVENT);
                int j = 0;
                while (j < events.getLength()) {
                    Element event = (Element)events.item(j);
                    if (event.getAttribute(NAME).equals(elem.getAttribute(NAME))) {
                        e.removeChild(event);
                    }
                    if (events.getLength() == 0) {
                        this.root.removeChild(e);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public ArrayList<String> getSessionEvents(String sessionName) {
        ArrayList<String> ret = new ArrayList<String>();
        NodeList eventList = this.root.getElementsByTagName(SESSION);
        int i = 0;
        while (i < eventList.getLength()) {
            Element event;
            if (eventList.item(i) instanceof Element && (event = (Element)eventList.item(i)).getAttribute(NAME).equals(sessionName)) {
                NodeList sessionList = event.getElementsByTagName(EVENT);
                int j = 0;
                while (j < sessionList.getLength()) {
                    if (sessionList.item(j) instanceof Element) {
                        Element session = (Element)sessionList.item(j);
                        ret.add(session.getAttribute(NAME));
                    }
                    ++j;
                }
            }
            ++i;
        }
        return ret;
    }

    public void write() {
        this.writeToFile(this.absfilePath);
    }

    private void writeToFile(String filePath) {
        DOMSource source = new DOMSource(this.doc);
        StreamResult result = new StreamResult(new File(filePath));
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            Transformer xformer = factory.newTransformer();
            xformer.transform(source, result);
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }
}

