/*
 * Decompiled with CFR 0.152.
 */
package jdk.net;

import jdk.Exported;

@Exported
public class SocketFlow {
    private static final int UNSET = -1;
    public static final int NORMAL_PRIORITY = 1;
    public static final int HIGH_PRIORITY = 2;
    private int priority = 1;
    private long bandwidth = -1L;
    private Status status = Status.NO_STATUS;

    private SocketFlow() {
    }

    public static SocketFlow create() {
        return new SocketFlow();
    }

    public SocketFlow priority(int priority) {
        if (priority != 1 && priority != 2) {
            throw new IllegalArgumentException("invalid priority");
        }
        this.priority = priority;
        return this;
    }

    public SocketFlow bandwidth(long bandwidth) {
        if (bandwidth < 0L) {
            throw new IllegalArgumentException("invalid bandwidth");
        }
        this.bandwidth = bandwidth;
        return this;
    }

    public int priority() {
        return this.priority;
    }

    public long bandwidth() {
        return this.bandwidth;
    }

    public Status status() {
        return this.status;
    }

    @Exported
    public static enum Status {
        NO_STATUS,
        OK,
        NO_PERMISSION,
        NOT_CONNECTED,
        NOT_SUPPORTED,
        ALREADY_CREATED,
        IN_PROGRESS,
        OTHER;

    }
}

