/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.SingleByte;
import sun.nio.cs.Surrogate;
import sun.nio.cs.ext.JIS_X_0201;

public class X11JIS0201
extends Charset {
    private static Charset jis0201 = new JIS_X_0201();
    private static SingleByte.Encoder enc = (SingleByte.Encoder)jis0201.newEncoder();

    public X11JIS0201() {
        super("X11JIS0201", null);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    @Override
    public CharsetDecoder newDecoder() {
        return jis0201.newDecoder();
    }

    @Override
    public boolean contains(Charset cs) {
        return cs instanceof X11JIS0201;
    }

    private class Encoder
    extends CharsetEncoder {
        private Surrogate.Parser sgp;

        public Encoder(Charset cs) {
            super(cs, 1.0f, 1.0f);
        }

        @Override
        public boolean canEncode(char c) {
            return c >= '\uff61' && c <= '\uff9f' || c == '\u203e' || c == '\u00a5';
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected CoderResult encodeLoop(CharBuffer src, ByteBuffer dst) {
            char[] sa = src.array();
            int sp = src.arrayOffset() + src.position();
            int sl = src.arrayOffset() + src.limit();
            byte[] da = dst.array();
            int dp = dst.arrayOffset() + dst.position();
            int dl = dst.arrayOffset() + dst.limit();
            CoderResult cr = CoderResult.UNDERFLOW;
            if (dl - dp < sl - sp) {
                sl = sp + (dl - dp);
                cr = CoderResult.OVERFLOW;
            }
            try {
                while (sp < sl) {
                    char c = sa[sp];
                    int b = enc.encode(c);
                    if (b == 65533) {
                        if (Character.isSurrogate(c)) {
                            if (this.sgp == null) {
                                this.sgp = new Surrogate.Parser();
                            }
                            if (this.sgp.parse(c, sa, sp, sl) >= 0) {
                                CoderResult coderResult = CoderResult.unmappableForLength(2);
                                return coderResult;
                            }
                        }
                        CoderResult coderResult = CoderResult.unmappableForLength(1);
                        return coderResult;
                    }
                    da[dp++] = (byte)b;
                    ++sp;
                }
                CoderResult coderResult = cr;
                return coderResult;
            }
            finally {
                src.position(sp - src.arrayOffset());
                dst.position(dp - dst.arrayOffset());
            }
        }
    }
}

