/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.security.AccessController;
import java.util.HashMap;
import sun.net.www.HeaderParser;
import sun.net.www.protocol.http.AuthCacheValue;
import sun.net.www.protocol.http.AuthScheme;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.security.action.GetBooleanAction;

public abstract class AuthenticationInfo
extends AuthCacheValue
implements Cloneable {
    static final long serialVersionUID = -2588378268010453259L;
    public static final char SERVER_AUTHENTICATION = 's';
    public static final char PROXY_AUTHENTICATION = 'p';
    static final boolean serializeAuth = AccessController.doPrivileged(new GetBooleanAction("http.auth.serializeRequests"));
    protected transient PasswordAuthentication pw;
    private static HashMap<String, Thread> requests = new HashMap();
    char type;
    AuthScheme authScheme;
    String protocol;
    String host;
    int port;
    String realm;
    String path;
    String s1;
    String s2;

    @Override
    public PasswordAuthentication credentials() {
        return this.pw;
    }

    @Override
    public AuthCacheValue.Type getAuthType() {
        return this.type == 's' ? AuthCacheValue.Type.Server : AuthCacheValue.Type.Proxy;
    }

    @Override
    AuthScheme getAuthScheme() {
        return this.authScheme;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getProtocolScheme() {
        return this.protocol;
    }

    protected boolean useAuthCache() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean requestIsInProgress(String key) {
        if (!serializeAuth) {
            return false;
        }
        HashMap<String, Thread> hashMap = requests;
        synchronized (hashMap) {
            Thread c = Thread.currentThread();
            Thread t = requests.get(key);
            if (t == null) {
                requests.put(key, c);
                return false;
            }
            if (t == c) {
                return false;
            }
            while (requests.containsKey(key)) {
                try {
                    requests.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void requestCompleted(String key) {
        HashMap<String, Thread> hashMap = requests;
        synchronized (hashMap) {
            Thread thread = requests.get(key);
            if (thread != null && thread == Thread.currentThread()) {
                boolean waspresent;
                boolean bl = waspresent = requests.remove(key) != null;
                assert (waspresent);
            }
            requests.notifyAll();
        }
    }

    public AuthenticationInfo(char type, AuthScheme authScheme, String host, int port, String realm) {
        this.type = type;
        this.authScheme = authScheme;
        this.protocol = "";
        this.host = host.toLowerCase();
        this.port = port;
        this.realm = realm;
        this.path = null;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public AuthenticationInfo(char type, AuthScheme authScheme, URL url, String realm) {
        this.type = type;
        this.authScheme = authScheme;
        this.protocol = url.getProtocol().toLowerCase();
        this.host = url.getHost().toLowerCase();
        this.port = url.getPort();
        if (this.port == -1) {
            this.port = url.getDefaultPort();
        }
        this.realm = realm;
        String urlPath = url.getPath();
        this.path = urlPath.length() == 0 ? urlPath : AuthenticationInfo.reducePath(urlPath);
    }

    static String reducePath(String urlPath) {
        int sepIndex = urlPath.lastIndexOf(47);
        int targetSuffixIndex = urlPath.lastIndexOf(46);
        if (sepIndex != -1) {
            if (sepIndex < targetSuffixIndex) {
                return urlPath.substring(0, sepIndex + 1);
            }
            return urlPath;
        }
        return urlPath;
    }

    static AuthenticationInfo getServerAuth(URL url) {
        int port = url.getPort();
        if (port == -1) {
            port = url.getDefaultPort();
        }
        String key = "s:" + url.getProtocol().toLowerCase() + ":" + url.getHost().toLowerCase() + ":" + port;
        return AuthenticationInfo.getAuth(key, url);
    }

    static String getServerAuthKey(URL url, String realm, AuthScheme scheme) {
        int port = url.getPort();
        if (port == -1) {
            port = url.getDefaultPort();
        }
        String key = "s:" + (Object)((Object)scheme) + ":" + url.getProtocol().toLowerCase() + ":" + url.getHost().toLowerCase() + ":" + port + ":" + realm;
        return key;
    }

    static AuthenticationInfo getServerAuth(String key) {
        AuthenticationInfo cached = AuthenticationInfo.getAuth(key, null);
        if (cached == null && AuthenticationInfo.requestIsInProgress(key)) {
            cached = AuthenticationInfo.getAuth(key, null);
        }
        return cached;
    }

    static AuthenticationInfo getAuth(String key, URL url) {
        if (url == null) {
            return (AuthenticationInfo)cache.get(key, null);
        }
        return (AuthenticationInfo)cache.get(key, url.getPath());
    }

    static AuthenticationInfo getProxyAuth(String host, int port) {
        String key = "p::" + host.toLowerCase() + ":" + port;
        AuthenticationInfo result = (AuthenticationInfo)cache.get(key, null);
        return result;
    }

    static String getProxyAuthKey(String host, int port, String realm, AuthScheme scheme) {
        String key = "p:" + (Object)((Object)scheme) + "::" + host.toLowerCase() + ":" + port + ":" + realm;
        return key;
    }

    static AuthenticationInfo getProxyAuth(String key) {
        AuthenticationInfo cached = (AuthenticationInfo)cache.get(key, null);
        if (cached == null && AuthenticationInfo.requestIsInProgress(key)) {
            cached = (AuthenticationInfo)cache.get(key, null);
        }
        return cached;
    }

    void addToCache() {
        String key = this.cacheKey(true);
        if (this.useAuthCache()) {
            cache.put(key, this);
            if (this.supportsPreemptiveAuthorization()) {
                cache.put(this.cacheKey(false), this);
            }
        }
        AuthenticationInfo.endAuthRequest(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void endAuthRequest(String key) {
        if (!serializeAuth) {
            return;
        }
        HashMap<String, Thread> hashMap = requests;
        synchronized (hashMap) {
            AuthenticationInfo.requestCompleted(key);
        }
    }

    void removeFromCache() {
        cache.remove(this.cacheKey(true), this);
        if (this.supportsPreemptiveAuthorization()) {
            cache.remove(this.cacheKey(false), this);
        }
    }

    public abstract boolean supportsPreemptiveAuthorization();

    public String getHeaderName() {
        if (this.type == 's') {
            return "Authorization";
        }
        return "Proxy-authorization";
    }

    public abstract String getHeaderValue(URL var1, String var2);

    public abstract boolean setHeaders(HttpURLConnection var1, HeaderParser var2, String var3);

    public abstract boolean isAuthorizationStale(String var1);

    String cacheKey(boolean includeRealm) {
        if (includeRealm) {
            return this.type + ":" + (Object)((Object)this.authScheme) + ":" + this.protocol + ":" + this.host + ":" + this.port + ":" + this.realm;
        }
        return this.type + ":" + this.protocol + ":" + this.host + ":" + this.port;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.pw = new PasswordAuthentication(this.s1, this.s2.toCharArray());
        this.s1 = null;
        this.s2 = null;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        this.s1 = this.pw.getUserName();
        this.s2 = new String(this.pw.getPassword());
        s.defaultWriteObject();
    }
}

