/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http.ntlm;

import com.sun.security.ntlm.Client;
import com.sun.security.ntlm.NTLMException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.PrivilegedAction;
import java.util.Base64;
import java.util.Random;
import sun.net.www.HeaderParser;
import sun.net.www.protocol.http.AuthScheme;
import sun.net.www.protocol.http.AuthenticationInfo;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.net.www.protocol.http.ntlm.NTLMAuthenticationCallback;
import sun.security.action.GetPropertyAction;

public class NTLMAuthentication
extends AuthenticationInfo {
    private static final long serialVersionUID = 170L;
    private static final NTLMAuthenticationCallback NTLMAuthCallback = NTLMAuthenticationCallback.getNTLMAuthenticationCallback();
    private String hostname;
    private static String defaultDomain = AccessController.doPrivileged(new GetPropertyAction("http.auth.ntlm.domain", ""));
    private static final boolean ntlmCache;
    PasswordAuthentication pw;
    Client client;

    public static boolean supportsTransparentAuth() {
        return false;
    }

    public static boolean isTrustedSite(URL url) {
        return NTLMAuthCallback.isTrustedSite(url);
    }

    private void init0() {
        this.hostname = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String localhost;
                try {
                    localhost = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException e) {
                    localhost = "localhost";
                }
                return localhost;
            }
        });
    }

    public NTLMAuthentication(boolean isProxy, URL url, PasswordAuthentication pw) {
        super(isProxy ? (char)'p' : 's', AuthScheme.NTLM, url, "");
        this.init(pw);
    }

    private void init(PasswordAuthentication pw) {
        String ntdomain;
        String username;
        this.pw = pw;
        String s = pw.getUserName();
        int i = s.indexOf(92);
        if (i == -1) {
            username = s;
            ntdomain = defaultDomain;
        } else {
            ntdomain = s.substring(0, i).toUpperCase();
            username = s.substring(i + 1);
        }
        char[] password = pw.getPassword();
        this.init0();
        try {
            this.client = new Client(System.getProperty("ntlm.version"), this.hostname, username, ntdomain, password);
        }
        catch (NTLMException ne) {
            try {
                this.client = new Client(null, this.hostname, username, ntdomain, password);
            }
            catch (NTLMException ne2) {
                throw new AssertionError((Object)"Really?");
            }
        }
    }

    public NTLMAuthentication(boolean isProxy, String host, int port, PasswordAuthentication pw) {
        super(isProxy ? (char)'p' : 's', AuthScheme.NTLM, host, port, "");
        this.init(pw);
    }

    @Override
    protected boolean useAuthCache() {
        return ntlmCache && super.useAuthCache();
    }

    @Override
    public boolean supportsPreemptiveAuthorization() {
        return false;
    }

    @Override
    public String getHeaderValue(URL url, String method) {
        throw new RuntimeException("getHeaderValue not supported");
    }

    @Override
    public boolean isAuthorizationStale(String header) {
        return false;
    }

    @Override
    public synchronized boolean setHeaders(HttpURLConnection conn, HeaderParser p, String raw) {
        try {
            String response;
            if (raw.length() < 6) {
                response = this.buildType1Msg();
            } else {
                String msg = raw.substring(5);
                response = this.buildType3Msg(msg);
            }
            conn.setAuthenticationProperty(this.getHeaderName(), response);
            return true;
        }
        catch (IOException e) {
            return false;
        }
        catch (GeneralSecurityException e) {
            return false;
        }
    }

    private String buildType1Msg() {
        byte[] msg = this.client.type1();
        String result = "NTLM " + Base64.getEncoder().encodeToString(msg);
        return result;
    }

    private String buildType3Msg(String challenge) throws GeneralSecurityException, IOException {
        byte[] type2 = Base64.getDecoder().decode(challenge);
        byte[] nonce = new byte[8];
        new Random().nextBytes(nonce);
        byte[] msg = this.client.type3(type2, nonce);
        String result = "NTLM " + Base64.getEncoder().encodeToString(msg);
        return result;
    }

    static {
        String ntlmCacheProp = AccessController.doPrivileged(new GetPropertyAction("jdk.ntlm.cache", "true"));
        ntlmCache = Boolean.parseBoolean(ntlmCacheProp);
    }
}

