/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.nio.fs.NativeBuffer;
import sun.nio.fs.NativeBuffers;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixMountEntry;
import sun.nio.fs.UnixNativeDispatcher;

class LinuxNativeDispatcher
extends UnixNativeDispatcher {
    private LinuxNativeDispatcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long setmntent(byte[] filename, byte[] type) throws UnixException {
        NativeBuffer pathBuffer = NativeBuffers.asNativeBuffer(filename);
        NativeBuffer typeBuffer = NativeBuffers.asNativeBuffer(type);
        try {
            long l = LinuxNativeDispatcher.setmntent0(pathBuffer.address(), typeBuffer.address());
            return l;
        }
        finally {
            typeBuffer.release();
            pathBuffer.release();
        }
    }

    private static native long setmntent0(long var0, long var2) throws UnixException;

    static native int getmntent(long var0, UnixMountEntry var2) throws UnixException;

    static native void endmntent(long var0) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int fgetxattr(int filedes, byte[] name, long valueAddress, int valueLen) throws UnixException {
        NativeBuffer buffer = NativeBuffers.asNativeBuffer(name);
        try {
            int n = LinuxNativeDispatcher.fgetxattr0(filedes, buffer.address(), valueAddress, valueLen);
            return n;
        }
        finally {
            buffer.release();
        }
    }

    private static native int fgetxattr0(int var0, long var1, long var3, int var5) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fsetxattr(int filedes, byte[] name, long valueAddress, int valueLen) throws UnixException {
        NativeBuffer buffer = NativeBuffers.asNativeBuffer(name);
        try {
            LinuxNativeDispatcher.fsetxattr0(filedes, buffer.address(), valueAddress, valueLen);
        }
        finally {
            buffer.release();
        }
    }

    private static native void fsetxattr0(int var0, long var1, long var3, int var5) throws UnixException;

    static void fremovexattr(int filedes, byte[] name) throws UnixException {
        NativeBuffer buffer = NativeBuffers.asNativeBuffer(name);
        try {
            LinuxNativeDispatcher.fremovexattr0(filedes, buffer.address());
        }
        finally {
            buffer.release();
        }
    }

    private static native void fremovexattr0(int var0, long var1) throws UnixException;

    static native int flistxattr(int var0, long var1, int var3) throws UnixException;

    private static native void init();

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("nio");
                return null;
            }
        });
        LinuxNativeDispatcher.init();
    }
}

