/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.debug.gdbjtag.viewmodel.peripheral;

import ilg.gnuarmeclipse.debug.gdbjtag.Activator;
import ilg.gnuarmeclipse.debug.gdbjtag.datamodel.SvdClusterDMNode;
import ilg.gnuarmeclipse.debug.gdbjtag.datamodel.SvdDMNode;
import ilg.gnuarmeclipse.debug.gdbjtag.datamodel.SvdFieldDMNode;
import ilg.gnuarmeclipse.debug.gdbjtag.datamodel.SvdObjectDMNode;
import ilg.gnuarmeclipse.debug.gdbjtag.datamodel.SvdPeripheralDMNode;
import ilg.gnuarmeclipse.debug.gdbjtag.datamodel.SvdRegisterDMNode;
import ilg.gnuarmeclipse.debug.gdbjtag.viewmodel.peripheral.PeripheralClusterArrayElementVMNode;
import ilg.gnuarmeclipse.debug.gdbjtag.viewmodel.peripheral.PeripheralClusterArrayVMNode;
import ilg.gnuarmeclipse.debug.gdbjtag.viewmodel.peripheral.PeripheralClusterVMNode;
import ilg.gnuarmeclipse.debug.gdbjtag.viewmodel.peripheral.PeripheralGroupVMNode;
import ilg.gnuarmeclipse.debug.gdbjtag.viewmodel.peripheral.PeripheralPath;
import ilg.gnuarmeclipse.debug.gdbjtag.viewmodel.peripheral.PeripheralRegisterArrayElementVMNode;
import ilg.gnuarmeclipse.debug.gdbjtag.viewmodel.peripheral.PeripheralRegisterArrayVMNode;
import ilg.gnuarmeclipse.debug.gdbjtag.viewmodel.peripheral.PeripheralRegisterFieldVMNode;
import ilg.gnuarmeclipse.debug.gdbjtag.viewmodel.peripheral.PeripheralRegisterVMNode;
import ilg.gnuarmeclipse.debug.gdbjtag.viewmodel.peripheral.PeripheralTopVMNode;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IRegister;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IValue;

public abstract class PeripheralTreeVMNode
implements IRegister,
Comparable<PeripheralTreeVMNode> {
    protected PeripheralGroupVMNode fPeripheral;
    protected PeripheralTreeVMNode fParent;
    protected ArrayList<PeripheralTreeVMNode> fChildren;
    protected SvdDMNode fDMNode;
    protected PeripheralPath fPath;
    protected String fName;
    private boolean fHasChanged;
    protected int fFadingLevel;

    public PeripheralTreeVMNode(PeripheralTreeVMNode parent, SvdDMNode dmNode) {
        this.fParent = parent;
        if (this.fParent != null) {
            this.fParent.addChild(this);
        }
        this.fChildren = null;
        this.fDMNode = dmNode;
        assert (this.fDMNode != null);
        this.fPath = null;
        this.fHasChanged = false;
        this.fFadingLevel = 0;
        this.fName = this.fDMNode.getDisplayName();
        assert (this.fName != null);
        PeripheralTreeVMNode node = this;
        while (node.getParent() != null) {
            node = (PeripheralTreeVMNode)node.getParent();
        }
        this.fPeripheral = (PeripheralGroupVMNode)node;
        assert (this.fPeripheral != null);
    }

    public void dispose() {
        this.fParent = null;
        this.fChildren = null;
        if (this.fDMNode != null) {
            this.fDMNode.dispose();
            this.fDMNode = null;
        }
        this.fPath = null;
    }

    protected void addChild(PeripheralTreeVMNode child) {
        if (this.fChildren == null) {
            this.fChildren = new ArrayList();
        }
        this.fChildren.add(child);
    }

    public Object[] getChildren() {
        if (this.fChildren == null) {
            this.prepareChildren();
        }
        Object[] children = this.fChildren.toArray(new PeripheralTreeVMNode[this.fChildren.size()]);
        Arrays.sort(children);
        return children;
    }

    public Object getParent() {
        return this.fParent;
    }

    public boolean hasChildren() {
        if (this.fChildren == null) {
            this.prepareChildren();
        }
        return !this.fChildren.isEmpty();
    }

    public String getModelIdentifier() {
        return null;
    }

    public IDebugTarget getDebugTarget() {
        return null;
    }

    public ILaunch getLaunch() {
        return null;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public IValue getValue() throws DebugException {
        return null;
    }

    public String getReferenceTypeName() throws DebugException {
        return null;
    }

    public boolean hasValueChanged() throws DebugException {
        return this.fHasChanged;
    }

    public void setValue(String expression) throws DebugException {
    }

    public void setValue(IValue value) throws DebugException {
    }

    public boolean supportsValueModification() {
        return !this.isReadOnly();
    }

    public boolean verifyValue(String expression) throws DebugException {
        return false;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return false;
    }

    public IRegisterGroup getRegisterGroup() throws DebugException {
        return this.fPeripheral;
    }

    public String getName() throws DebugException {
        return this.fName;
    }

    public boolean isField() {
        return this.fDMNode instanceof SvdFieldDMNode;
    }

    public boolean isRegister() {
        return this.fDMNode instanceof SvdRegisterDMNode;
    }

    public boolean isCluster() {
        return this.fDMNode instanceof SvdClusterDMNode;
    }

    public boolean isPeripheral() {
        return this.fDMNode instanceof SvdPeripheralDMNode;
    }

    public PeripheralPath getPath() {
        if (this.fPath == null) {
            PeripheralTreeVMNode parent = (PeripheralTreeVMNode)this.getParent();
            if (parent != null) {
                return new PeripheralPath(parent.getPath(), new PeripheralPath(this.fName));
            }
            return new PeripheralPath(this.fName);
        }
        return this.fPath;
    }

    public String getQualifiedName() {
        return this.getPath().toString();
    }

    public String getDescription() {
        return this.fDMNode.getDescription();
    }

    public BigInteger getThisBigAddressOffset() {
        return this.fDMNode.getBigAddressOffset();
    }

    public BigInteger getPeripheralBigAddressOffset() {
        BigInteger offset = this.getThisBigAddressOffset();
        PeripheralTreeVMNode parent = (PeripheralTreeVMNode)this.getParent();
        if (parent != null) {
            offset = offset.add(parent.getPeripheralBigAddressOffset());
        }
        return offset;
    }

    public BigInteger getBigAbsoluteAddress() {
        BigInteger peripheralBaseAddress;
        try {
            peripheralBaseAddress = ((PeripheralTopVMNode)this.getRegisterGroup()).getBigAbsoluteAddress();
        }
        catch (DebugException e) {
            peripheralBaseAddress = BigInteger.ZERO;
        }
        BigInteger offset = this.getPeripheralBigAddressOffset();
        return peripheralBaseAddress.add(offset);
    }

    public BigInteger getBigSize() {
        return this.fDMNode.getBigSizeBytes();
    }

    public abstract String getDisplayNodeType();

    public abstract String getImageName();

    public String getAccess() {
        return this.fDMNode.getAccess();
    }

    public String getReadAction() {
        return this.fDMNode.getReadAction();
    }

    public boolean isWriteOnly() {
        return this.fDMNode.isWriteOnly();
    }

    public boolean isReadOnly() {
        return this.fDMNode.isReadOnly();
    }

    public boolean isReadAllowed() {
        return this.fDMNode.isReadAllowed();
    }

    public boolean hasReadAction() {
        return this.fDMNode.hasReadAction();
    }

    public String getDisplayAddress() {
        BigInteger bigAddress = this.getBigAbsoluteAddress();
        if (bigAddress != null) {
            return String.format("0x%08X", bigAddress.longValue());
        }
        return null;
    }

    public String getDisplayOffset() {
        long value = this.getPeripheralBigAddressOffset().longValue();
        if (value < 65536L) {
            return String.format("0x%04X", value);
        }
        return String.format("0x%08X", value);
    }

    public abstract String getDisplaySize();

    public String getDisplayValue() {
        return null;
    }

    protected PeripheralTopVMNode getPeripheral() {
        try {
            return (PeripheralTopVMNode)this.getRegisterGroup();
        }
        catch (DebugException debugException) {
            return null;
        }
    }

    public boolean isArray() {
        return this.fDMNode.isArray();
    }

    private void prepareChildren() {
        if (this.fChildren != null) {
            return;
        }
        this.fChildren = new ArrayList();
        SvdObjectDMNode[] svdChildren = this.fDMNode.getChildren();
        assert (svdChildren != null);
        int i = 0;
        while (i < svdChildren.length) {
            SvdObjectDMNode child = svdChildren[i];
            if (this instanceof PeripheralGroupVMNode) {
                this.processDimGroup((SvdDMNode)child);
            } else if (this instanceof PeripheralRegisterVMNode) {
                if (child instanceof SvdFieldDMNode) {
                    new PeripheralRegisterFieldVMNode(this, (SvdFieldDMNode)child);
                } else {
                    Activator.log((String)(String.valueOf(child.getClass().getSimpleName()) + " not processed"));
                }
            } else {
                Activator.log((String)(String.valueOf(this.getClass().getSimpleName()) + " not processed"));
            }
            ++i;
        }
    }

    private void processDimGroup(SvdDMNode child) {
        boolean isArray = child.isArray();
        if (!isArray) {
            if (child instanceof SvdClusterDMNode) {
                new PeripheralClusterVMNode(this, child);
            } else if (child instanceof SvdRegisterDMNode) {
                new PeripheralRegisterVMNode(this, child);
            } else {
                Activator.log((String)(String.valueOf(child.getClass().getSimpleName()) + " not processed"));
            }
            return;
        }
        BigInteger increment = child.getBigIntegerArrayAddressIncrement();
        String[] indices = child.getArrayIndices();
        if (child instanceof SvdClusterDMNode) {
            PeripheralClusterArrayVMNode arrayNode = new PeripheralClusterArrayVMNode(this, child);
            arrayNode.substituteIndex("");
            BigInteger offset = BigInteger.ZERO;
            int i = 0;
            while (i < indices.length) {
                new PeripheralClusterArrayElementVMNode(arrayNode, child, indices[i], offset);
                offset = offset.add(increment);
                ++i;
            }
        } else if (child instanceof SvdRegisterDMNode) {
            PeripheralRegisterArrayVMNode arrayNode = new PeripheralRegisterArrayVMNode(this, child);
            arrayNode.substituteIndex("");
            BigInteger offset = BigInteger.ZERO;
            int i = 0;
            while (i < indices.length) {
                new PeripheralRegisterArrayElementVMNode(arrayNode, child, indices[i], offset);
                offset = offset.add(increment);
                ++i;
            }
        } else {
            Activator.log((String)(String.valueOf(child.getClass().getSimpleName()) + " not processed"));
        }
    }

    protected void substituteIndex(String index) {
        if (this.fName.indexOf("%s") >= 0) {
            if (index.isEmpty() && this.fName.indexOf("[%s]") < 0) {
                index = "[]";
            }
            this.fName = String.format(this.fName, index);
        }
    }

    public void setChanged(boolean hasChanged) {
        this.fHasChanged = hasChanged;
        if (this.fHasChanged) {
            this.setFadingLevel(3);
        }
    }

    public int getFadingLevel() {
        return this.fFadingLevel;
    }

    public void setFadingLevel(int level) {
        this.fFadingLevel = level;
        if (this.fFadingLevel > 0 && Activator.getInstance().isDebugging()) {
            System.out.println("PeripheralTreeVMNode.setFadingLevel() " + this.fName + " " + this.fFadingLevel);
        }
    }

    public void decrementFadingLevel() {
        if (this.fFadingLevel > 0) {
            this.setFadingLevel(this.fFadingLevel - 1);
        }
        if (this.fChildren != null) {
            for (PeripheralTreeVMNode node : this.fChildren) {
                node.decrementFadingLevel();
            }
        }
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + ": " + this.getDisplayNodeType() + ":" + this.getQualifiedName() + "]";
    }

    @Override
    public int compareTo(PeripheralTreeVMNode comp) {
        return this.fDMNode.compareTo(comp.fDMNode);
    }
}

