/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.TMSchema;
import com.sun.java.swing.plaf.windows.WindowsCheckBoxMenuItemUI;
import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import com.sun.java.swing.plaf.windows.WindowsMenuItemUI;
import com.sun.java.swing.plaf.windows.WindowsMenuItemUIAccessor;
import com.sun.java.swing.plaf.windows.WindowsMenuUI;
import com.sun.java.swing.plaf.windows.WindowsRadioButtonMenuItemUI;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.UIResource;
import sun.swing.MenuItemCheckIconFactory;

public class WindowsIconFactory
implements Serializable {
    private static Icon frame_closeIcon;
    private static Icon frame_iconifyIcon;
    private static Icon frame_maxIcon;
    private static Icon frame_minIcon;
    private static Icon frame_resizeIcon;
    private static Icon checkBoxIcon;
    private static Icon radioButtonIcon;
    private static Icon checkBoxMenuItemIcon;
    private static Icon radioButtonMenuItemIcon;
    private static Icon menuItemCheckIcon;
    private static Icon menuItemArrowIcon;
    private static Icon menuArrowIcon;
    private static VistaMenuItemCheckIconFactory menuItemCheckIconFactory;

    public static Icon getMenuItemCheckIcon() {
        if (menuItemCheckIcon == null) {
            menuItemCheckIcon = new MenuItemCheckIcon();
        }
        return menuItemCheckIcon;
    }

    public static Icon getMenuItemArrowIcon() {
        if (menuItemArrowIcon == null) {
            menuItemArrowIcon = new MenuItemArrowIcon();
        }
        return menuItemArrowIcon;
    }

    public static Icon getMenuArrowIcon() {
        if (menuArrowIcon == null) {
            menuArrowIcon = new MenuArrowIcon();
        }
        return menuArrowIcon;
    }

    public static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    public static Icon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new RadioButtonIcon();
        }
        return radioButtonIcon;
    }

    public static Icon getCheckBoxMenuItemIcon() {
        if (checkBoxMenuItemIcon == null) {
            checkBoxMenuItemIcon = new CheckBoxMenuItemIcon();
        }
        return checkBoxMenuItemIcon;
    }

    public static Icon getRadioButtonMenuItemIcon() {
        if (radioButtonMenuItemIcon == null) {
            radioButtonMenuItemIcon = new RadioButtonMenuItemIcon();
        }
        return radioButtonMenuItemIcon;
    }

    static synchronized VistaMenuItemCheckIconFactory getMenuItemCheckIconFactory() {
        if (menuItemCheckIconFactory == null) {
            menuItemCheckIconFactory = new VistaMenuItemCheckIconFactory();
        }
        return menuItemCheckIconFactory;
    }

    public static Icon createFrameCloseIcon() {
        if (frame_closeIcon == null) {
            frame_closeIcon = new FrameButtonIcon(TMSchema.Part.WP_CLOSEBUTTON);
        }
        return frame_closeIcon;
    }

    public static Icon createFrameIconifyIcon() {
        if (frame_iconifyIcon == null) {
            frame_iconifyIcon = new FrameButtonIcon(TMSchema.Part.WP_MINBUTTON);
        }
        return frame_iconifyIcon;
    }

    public static Icon createFrameMaximizeIcon() {
        if (frame_maxIcon == null) {
            frame_maxIcon = new FrameButtonIcon(TMSchema.Part.WP_MAXBUTTON);
        }
        return frame_maxIcon;
    }

    public static Icon createFrameMinimizeIcon() {
        if (frame_minIcon == null) {
            frame_minIcon = new FrameButtonIcon(TMSchema.Part.WP_RESTOREBUTTON);
        }
        return frame_minIcon;
    }

    public static Icon createFrameResizeIcon() {
        if (frame_resizeIcon == null) {
            frame_resizeIcon = new ResizeIcon();
        }
        return frame_resizeIcon;
    }

    static class VistaMenuItemCheckIconFactory
    implements MenuItemCheckIconFactory {
        private static final int OFFSET = 3;

        VistaMenuItemCheckIconFactory() {
        }

        @Override
        public Icon getIcon(JMenuItem component) {
            return new VistaMenuItemCheckIcon(component);
        }

        @Override
        public boolean isCompatible(Object icon, String prefix) {
            return icon instanceof VistaMenuItemCheckIcon && ((VistaMenuItemCheckIcon)icon).type == VistaMenuItemCheckIconFactory.getType(prefix);
        }

        public Icon getIcon(String type) {
            return new VistaMenuItemCheckIcon(type);
        }

        static int getIconWidth() {
            XPStyle xp = XPStyle.getXP();
            return (xp != null ? xp.getSkin(null, TMSchema.Part.MP_POPUPCHECK).getWidth() : 16) + 6;
        }

        private static Class<? extends JMenuItem> getType(Component c) {
            Class rv = null;
            if (c instanceof JCheckBoxMenuItem) {
                rv = JCheckBoxMenuItem.class;
            } else if (c instanceof JRadioButtonMenuItem) {
                rv = JRadioButtonMenuItem.class;
            } else if (c instanceof JMenu) {
                rv = JMenu.class;
            } else if (c instanceof JMenuItem) {
                rv = JMenuItem.class;
            }
            return rv;
        }

        private static Class<? extends JMenuItem> getType(String type) {
            Class rv = null;
            rv = type == "CheckBoxMenuItem" ? JCheckBoxMenuItem.class : (type == "RadioButtonMenuItem" ? JRadioButtonMenuItem.class : (type == "Menu" ? JMenu.class : (type == "MenuItem" ? JMenuItem.class : JMenuItem.class)));
            return rv;
        }

        private static class VistaMenuItemCheckIcon
        implements Icon,
        UIResource,
        Serializable {
            private final JMenuItem menuItem;
            private final Class<? extends JMenuItem> type;

            VistaMenuItemCheckIcon(JMenuItem menuItem) {
                this.type = VistaMenuItemCheckIconFactory.getType(menuItem);
                this.menuItem = menuItem;
            }

            VistaMenuItemCheckIcon(String type) {
                this.type = VistaMenuItemCheckIconFactory.getType(type);
                this.menuItem = null;
            }

            @Override
            public int getIconHeight() {
                Icon lafIcon = this.getLaFIcon();
                if (lafIcon != null) {
                    return lafIcon.getIconHeight();
                }
                Icon icon = this.getIcon();
                int height = 0;
                if (icon != null) {
                    height = icon.getIconHeight();
                } else {
                    XPStyle xp = XPStyle.getXP();
                    if (xp != null) {
                        XPStyle.Skin skin = xp.getSkin(null, TMSchema.Part.MP_POPUPCHECK);
                        height = skin.getHeight();
                    } else {
                        height = 16;
                    }
                }
                return height += 6;
            }

            @Override
            public int getIconWidth() {
                Icon lafIcon = this.getLaFIcon();
                if (lafIcon != null) {
                    return lafIcon.getIconWidth();
                }
                Icon icon = this.getIcon();
                int width = 0;
                width = icon != null ? icon.getIconWidth() + 6 : VistaMenuItemCheckIconFactory.getIconWidth();
                return width;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                AbstractButton b;
                Icon lafIcon = this.getLaFIcon();
                if (lafIcon != null) {
                    lafIcon.paintIcon(c, g, x, y);
                    return;
                }
                assert (this.menuItem == null || c == this.menuItem);
                Icon icon = this.getIcon();
                if ((this.type == JCheckBoxMenuItem.class || this.type == JRadioButtonMenuItem.class) && (b = (AbstractButton)c).isSelected()) {
                    TMSchema.State state;
                    TMSchema.State backgroundState;
                    TMSchema.Part backgroundPart = TMSchema.Part.MP_POPUPCHECKBACKGROUND;
                    TMSchema.Part part = TMSchema.Part.MP_POPUPCHECK;
                    if (VistaMenuItemCheckIcon.isEnabled(c, null)) {
                        backgroundState = icon != null ? TMSchema.State.BITMAP : TMSchema.State.NORMAL;
                        state = this.type == JRadioButtonMenuItem.class ? TMSchema.State.BULLETNORMAL : TMSchema.State.CHECKMARKNORMAL;
                    } else {
                        backgroundState = TMSchema.State.DISABLEDPUSHED;
                        state = this.type == JRadioButtonMenuItem.class ? TMSchema.State.BULLETDISABLED : TMSchema.State.CHECKMARKDISABLED;
                    }
                    XPStyle xp = XPStyle.getXP();
                    if (xp != null) {
                        XPStyle.Skin skin = xp.getSkin(c, backgroundPart);
                        skin.paintSkin(g, x, y, this.getIconWidth(), this.getIconHeight(), backgroundState);
                        if (icon == null) {
                            skin = xp.getSkin(c, part);
                            skin.paintSkin(g, x + 3, y + 3, state);
                        }
                    }
                }
                if (icon != null) {
                    icon.paintIcon(c, g, x + 3, y + 3);
                }
            }

            private static WindowsMenuItemUIAccessor getAccessor(JMenuItem menuItem) {
                ButtonUI uiObject;
                WindowsMenuItemUIAccessor rv = null;
                ButtonUI buttonUI = uiObject = menuItem != null ? menuItem.getUI() : null;
                if (uiObject instanceof WindowsMenuItemUI) {
                    rv = ((WindowsMenuItemUI)uiObject).accessor;
                } else if (uiObject instanceof WindowsMenuUI) {
                    rv = ((WindowsMenuUI)uiObject).accessor;
                } else if (uiObject instanceof WindowsCheckBoxMenuItemUI) {
                    rv = ((WindowsCheckBoxMenuItemUI)uiObject).accessor;
                } else if (uiObject instanceof WindowsRadioButtonMenuItemUI) {
                    rv = ((WindowsRadioButtonMenuItemUI)uiObject).accessor;
                }
                return rv;
            }

            private static boolean isEnabled(Component c, TMSchema.State state) {
                WindowsMenuItemUIAccessor accessor;
                if (state == null && c instanceof JMenuItem && (accessor = VistaMenuItemCheckIcon.getAccessor((JMenuItem)c)) != null) {
                    state = accessor.getState((JMenuItem)c);
                }
                if (state == null) {
                    if (c != null) {
                        return c.isEnabled();
                    }
                    return true;
                }
                return state != TMSchema.State.DISABLED && state != TMSchema.State.DISABLEDHOT && state != TMSchema.State.DISABLEDPUSHED;
            }

            private Icon getIcon() {
                TMSchema.State state;
                Icon rv = null;
                if (this.menuItem == null) {
                    return rv;
                }
                WindowsMenuItemUIAccessor accessor = VistaMenuItemCheckIcon.getAccessor(this.menuItem);
                TMSchema.State state2 = state = accessor != null ? accessor.getState(this.menuItem) : null;
                rv = VistaMenuItemCheckIcon.isEnabled(this.menuItem, null) ? (state == TMSchema.State.PUSHED ? this.menuItem.getPressedIcon() : this.menuItem.getIcon()) : this.menuItem.getDisabledIcon();
                return rv;
            }

            private Icon getLaFIcon() {
                Icon rv = (Icon)UIManager.getDefaults().get(VistaMenuItemCheckIcon.typeToString(this.type));
                if (rv instanceof VistaMenuItemCheckIcon && ((VistaMenuItemCheckIcon)rv).type == this.type) {
                    rv = null;
                }
                return rv;
            }

            private static String typeToString(Class<? extends JMenuItem> type) {
                assert (type == JMenuItem.class || type == JMenu.class || type == JCheckBoxMenuItem.class || type == JRadioButtonMenuItem.class);
                StringBuilder sb = new StringBuilder(type.getName());
                sb.delete(0, sb.lastIndexOf("J") + 1);
                sb.append(".checkIcon");
                return sb.toString();
            }
        }
    }

    private static class MenuArrowIcon
    implements Icon,
    UIResource,
    Serializable {
        private MenuArrowIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            XPStyle xp = XPStyle.getXP();
            if (WindowsMenuItemUI.isVistaPainting(xp)) {
                TMSchema.State state = TMSchema.State.NORMAL;
                if (c instanceof JMenuItem) {
                    state = ((JMenuItem)c).getModel().isEnabled() ? TMSchema.State.NORMAL : TMSchema.State.DISABLED;
                }
                XPStyle.Skin skin = xp.getSkin(c, TMSchema.Part.MP_POPUPSUBMENU);
                if (WindowsGraphicsUtils.isLeftToRight(c)) {
                    skin.paintSkin(g, x, y, state);
                } else {
                    Graphics2D g2d = (Graphics2D)g.create();
                    g2d.translate(x + skin.getWidth(), y);
                    g2d.scale(-1.0, 1.0);
                    skin.paintSkin(g2d, 0, 0, state);
                    g2d.dispose();
                }
            } else {
                g.translate(x, y);
                if (WindowsGraphicsUtils.isLeftToRight(c)) {
                    g.drawLine(0, 0, 0, 7);
                    g.drawLine(1, 1, 1, 6);
                    g.drawLine(2, 2, 2, 5);
                    g.drawLine(3, 3, 3, 4);
                } else {
                    g.drawLine(4, 0, 4, 7);
                    g.drawLine(3, 1, 3, 6);
                    g.drawLine(2, 2, 2, 5);
                    g.drawLine(1, 3, 1, 4);
                }
                g.translate(-x, -y);
            }
        }

        @Override
        public int getIconWidth() {
            XPStyle xp = XPStyle.getXP();
            if (WindowsMenuItemUI.isVistaPainting(xp)) {
                XPStyle.Skin skin = xp.getSkin(null, TMSchema.Part.MP_POPUPSUBMENU);
                return skin.getWidth();
            }
            return 4;
        }

        @Override
        public int getIconHeight() {
            XPStyle xp = XPStyle.getXP();
            if (WindowsMenuItemUI.isVistaPainting(xp)) {
                XPStyle.Skin skin = xp.getSkin(null, TMSchema.Part.MP_POPUPSUBMENU);
                return skin.getHeight();
            }
            return 8;
        }
    }

    private static class MenuItemArrowIcon
    implements Icon,
    UIResource,
    Serializable {
        private MenuItemArrowIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        @Override
        public int getIconWidth() {
            return 4;
        }

        @Override
        public int getIconHeight() {
            return 8;
        }
    }

    private static class MenuItemCheckIcon
    implements Icon,
    UIResource,
    Serializable {
        private MenuItemCheckIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        @Override
        public int getIconWidth() {
            return 9;
        }

        @Override
        public int getIconHeight() {
            return 9;
        }
    }

    private static class RadioButtonMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private RadioButtonMenuItemIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            AbstractButton b = (AbstractButton)c;
            ButtonModel model = b.getModel();
            if (b.isSelected()) {
                g.fillRoundRect(x + 3, y + 3, this.getIconWidth() - 6, this.getIconHeight() - 6, 4, 4);
            }
        }

        @Override
        public int getIconWidth() {
            return 12;
        }

        @Override
        public int getIconHeight() {
            return 12;
        }
    }

    private static class CheckBoxMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private CheckBoxMenuItemIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            AbstractButton b = (AbstractButton)c;
            ButtonModel model = b.getModel();
            boolean isSelected = model.isSelected();
            if (isSelected) {
                g.drawLine(x + 9, (y -= this.getIconHeight() / 2) + 3, x + 9, y + 3);
                g.drawLine(x + 8, y + 4, x + 9, y + 4);
                g.drawLine(x + 7, y + 5, x + 9, y + 5);
                g.drawLine(x + 6, y + 6, x + 8, y + 6);
                g.drawLine(x + 3, y + 7, x + 7, y + 7);
                g.drawLine(x + 4, y + 8, x + 6, y + 8);
                g.drawLine(x + 5, y + 9, x + 5, y + 9);
                g.drawLine(x + 3, y + 5, x + 3, y + 5);
                g.drawLine(x + 3, y + 6, x + 4, y + 6);
            }
        }

        @Override
        public int getIconWidth() {
            return 9;
        }

        @Override
        public int getIconHeight() {
            return 9;
        }
    }

    private static class RadioButtonIcon
    implements Icon,
    UIResource,
    Serializable {
        private RadioButtonIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            AbstractButton b = (AbstractButton)c;
            ButtonModel model = b.getModel();
            XPStyle xp = XPStyle.getXP();
            if (xp != null) {
                TMSchema.State state;
                TMSchema.Part part = TMSchema.Part.BP_RADIOBUTTON;
                XPStyle.Skin skin = xp.getSkin(b, part);
                boolean index = false;
                if (model.isSelected()) {
                    state = TMSchema.State.CHECKEDNORMAL;
                    if (!model.isEnabled()) {
                        state = TMSchema.State.CHECKEDDISABLED;
                    } else if (model.isPressed() && model.isArmed()) {
                        state = TMSchema.State.CHECKEDPRESSED;
                    } else if (model.isRollover()) {
                        state = TMSchema.State.CHECKEDHOT;
                    }
                } else {
                    state = TMSchema.State.UNCHECKEDNORMAL;
                    if (!model.isEnabled()) {
                        state = TMSchema.State.UNCHECKEDDISABLED;
                    } else if (model.isPressed() && model.isArmed()) {
                        state = TMSchema.State.UNCHECKEDPRESSED;
                    } else if (model.isRollover()) {
                        state = TMSchema.State.UNCHECKEDHOT;
                    }
                }
                skin.paintSkin(g, x, y, state);
            } else {
                if (model.isPressed() && model.isArmed() || !model.isEnabled()) {
                    g.setColor(UIManager.getColor("RadioButton.background"));
                } else {
                    g.setColor(UIManager.getColor("RadioButton.interiorBackground"));
                }
                g.fillRect(x + 2, y + 2, 8, 8);
                g.setColor(UIManager.getColor("RadioButton.shadow"));
                g.drawLine(x + 4, y + 0, x + 7, y + 0);
                g.drawLine(x + 2, y + 1, x + 3, y + 1);
                g.drawLine(x + 8, y + 1, x + 9, y + 1);
                g.drawLine(x + 1, y + 2, x + 1, y + 3);
                g.drawLine(x + 0, y + 4, x + 0, y + 7);
                g.drawLine(x + 1, y + 8, x + 1, y + 9);
                g.setColor(UIManager.getColor("RadioButton.highlight"));
                g.drawLine(x + 2, y + 10, x + 3, y + 10);
                g.drawLine(x + 4, y + 11, x + 7, y + 11);
                g.drawLine(x + 8, y + 10, x + 9, y + 10);
                g.drawLine(x + 10, y + 9, x + 10, y + 8);
                g.drawLine(x + 11, y + 7, x + 11, y + 4);
                g.drawLine(x + 10, y + 3, x + 10, y + 2);
                g.setColor(UIManager.getColor("RadioButton.darkShadow"));
                g.drawLine(x + 4, y + 1, x + 7, y + 1);
                g.drawLine(x + 2, y + 2, x + 3, y + 2);
                g.drawLine(x + 8, y + 2, x + 9, y + 2);
                g.drawLine(x + 2, y + 3, x + 2, y + 3);
                g.drawLine(x + 1, y + 4, x + 1, y + 7);
                g.drawLine(x + 2, y + 8, x + 2, y + 8);
                g.setColor(UIManager.getColor("RadioButton.light"));
                g.drawLine(x + 2, y + 9, x + 3, y + 9);
                g.drawLine(x + 4, y + 10, x + 7, y + 10);
                g.drawLine(x + 8, y + 9, x + 9, y + 9);
                g.drawLine(x + 9, y + 8, x + 9, y + 8);
                g.drawLine(x + 10, y + 7, x + 10, y + 4);
                g.drawLine(x + 9, y + 3, x + 9, y + 3);
                if (model.isSelected()) {
                    if (model.isEnabled()) {
                        g.setColor(UIManager.getColor("RadioButton.foreground"));
                    } else {
                        g.setColor(UIManager.getColor("RadioButton.shadow"));
                    }
                    g.fillRect(x + 4, y + 5, 4, 2);
                    g.fillRect(x + 5, y + 4, 2, 4);
                }
            }
        }

        @Override
        public int getIconWidth() {
            XPStyle xp = XPStyle.getXP();
            if (xp != null) {
                return xp.getSkin(null, TMSchema.Part.BP_RADIOBUTTON).getWidth();
            }
            return 13;
        }

        @Override
        public int getIconHeight() {
            XPStyle xp = XPStyle.getXP();
            if (xp != null) {
                return xp.getSkin(null, TMSchema.Part.BP_RADIOBUTTON).getHeight();
            }
            return 13;
        }
    }

    private static class CheckBoxIcon
    implements Icon,
    Serializable {
        static final int csize = 13;

        private CheckBoxIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            JCheckBox cb = (JCheckBox)c;
            ButtonModel model = cb.getModel();
            XPStyle xp = XPStyle.getXP();
            if (xp != null) {
                TMSchema.State state;
                if (model.isSelected()) {
                    state = TMSchema.State.CHECKEDNORMAL;
                    if (!model.isEnabled()) {
                        state = TMSchema.State.CHECKEDDISABLED;
                    } else if (model.isPressed() && model.isArmed()) {
                        state = TMSchema.State.CHECKEDPRESSED;
                    } else if (model.isRollover()) {
                        state = TMSchema.State.CHECKEDHOT;
                    }
                } else {
                    state = TMSchema.State.UNCHECKEDNORMAL;
                    if (!model.isEnabled()) {
                        state = TMSchema.State.UNCHECKEDDISABLED;
                    } else if (model.isPressed() && model.isArmed()) {
                        state = TMSchema.State.UNCHECKEDPRESSED;
                    } else if (model.isRollover()) {
                        state = TMSchema.State.UNCHECKEDHOT;
                    }
                }
                TMSchema.Part part = TMSchema.Part.BP_CHECKBOX;
                xp.getSkin(c, part).paintSkin(g, x, y, state);
            } else {
                if (!cb.isBorderPaintedFlat()) {
                    g.setColor(UIManager.getColor("CheckBox.shadow"));
                    g.drawLine(x, y, x + 11, y);
                    g.drawLine(x, y + 1, x, y + 11);
                    g.setColor(UIManager.getColor("CheckBox.highlight"));
                    g.drawLine(x + 12, y, x + 12, y + 12);
                    g.drawLine(x, y + 12, x + 11, y + 12);
                    g.setColor(UIManager.getColor("CheckBox.darkShadow"));
                    g.drawLine(x + 1, y + 1, x + 10, y + 1);
                    g.drawLine(x + 1, y + 2, x + 1, y + 10);
                    g.setColor(UIManager.getColor("CheckBox.light"));
                    g.drawLine(x + 1, y + 11, x + 11, y + 11);
                    g.drawLine(x + 11, y + 1, x + 11, y + 10);
                    if (model.isPressed() && model.isArmed() || !model.isEnabled()) {
                        g.setColor(UIManager.getColor("CheckBox.background"));
                    } else {
                        g.setColor(UIManager.getColor("CheckBox.interiorBackground"));
                    }
                    g.fillRect(x + 2, y + 2, 9, 9);
                } else {
                    g.setColor(UIManager.getColor("CheckBox.shadow"));
                    g.drawRect(x + 1, y + 1, 10, 10);
                    if (model.isPressed() && model.isArmed() || !model.isEnabled()) {
                        g.setColor(UIManager.getColor("CheckBox.background"));
                    } else {
                        g.setColor(UIManager.getColor("CheckBox.interiorBackground"));
                    }
                    g.fillRect(x + 2, y + 2, 9, 9);
                }
                if (model.isEnabled()) {
                    g.setColor(UIManager.getColor("CheckBox.foreground"));
                } else {
                    g.setColor(UIManager.getColor("CheckBox.shadow"));
                }
                if (model.isSelected()) {
                    g.drawLine(x + 9, y + 3, x + 9, y + 3);
                    g.drawLine(x + 8, y + 4, x + 9, y + 4);
                    g.drawLine(x + 7, y + 5, x + 9, y + 5);
                    g.drawLine(x + 6, y + 6, x + 8, y + 6);
                    g.drawLine(x + 3, y + 7, x + 7, y + 7);
                    g.drawLine(x + 4, y + 8, x + 6, y + 8);
                    g.drawLine(x + 5, y + 9, x + 5, y + 9);
                    g.drawLine(x + 3, y + 5, x + 3, y + 5);
                    g.drawLine(x + 3, y + 6, x + 4, y + 6);
                }
            }
        }

        @Override
        public int getIconWidth() {
            XPStyle xp = XPStyle.getXP();
            if (xp != null) {
                return xp.getSkin(null, TMSchema.Part.BP_CHECKBOX).getWidth();
            }
            return 13;
        }

        @Override
        public int getIconHeight() {
            XPStyle xp = XPStyle.getXP();
            if (xp != null) {
                return xp.getSkin(null, TMSchema.Part.BP_CHECKBOX).getHeight();
            }
            return 13;
        }
    }

    private static class ResizeIcon
    implements Icon,
    Serializable {
        private ResizeIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(UIManager.getColor("InternalFrame.resizeIconHighlight"));
            g.drawLine(0, 11, 11, 0);
            g.drawLine(4, 11, 11, 4);
            g.drawLine(8, 11, 11, 8);
            g.setColor(UIManager.getColor("InternalFrame.resizeIconShadow"));
            g.drawLine(1, 11, 11, 1);
            g.drawLine(2, 11, 11, 2);
            g.drawLine(5, 11, 11, 5);
            g.drawLine(6, 11, 11, 6);
            g.drawLine(9, 11, 11, 9);
            g.drawLine(10, 11, 11, 10);
        }

        @Override
        public int getIconWidth() {
            return 13;
        }

        @Override
        public int getIconHeight() {
            return 13;
        }
    }

    private static class FrameButtonIcon
    implements Icon,
    Serializable {
        private TMSchema.Part part;

        private FrameButtonIcon(TMSchema.Part part) {
            this.part = part;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x0, int y0) {
            int width = this.getIconWidth();
            int height = this.getIconHeight();
            XPStyle xp = XPStyle.getXP();
            if (xp != null) {
                boolean jifSelected;
                XPStyle.Skin skin = xp.getSkin(c, this.part);
                AbstractButton b = (AbstractButton)c;
                ButtonModel model = b.getModel();
                JInternalFrame jif = (JInternalFrame)SwingUtilities.getAncestorOfClass(JInternalFrame.class, b);
                boolean bl = jifSelected = jif != null && jif.isSelected();
                TMSchema.State state = jifSelected ? (!model.isEnabled() ? TMSchema.State.DISABLED : (model.isArmed() && model.isPressed() ? TMSchema.State.PUSHED : (model.isRollover() ? TMSchema.State.HOT : TMSchema.State.NORMAL))) : (!model.isEnabled() ? TMSchema.State.INACTIVEDISABLED : (model.isArmed() && model.isPressed() ? TMSchema.State.INACTIVEPUSHED : (model.isRollover() ? TMSchema.State.INACTIVEHOT : TMSchema.State.INACTIVENORMAL)));
                skin.paintSkin(g, 0, 0, width, height, state);
            } else {
                g.setColor(Color.black);
                int x = width / 12 + 2;
                int y = height / 5;
                int h = height - y * 2 - 1;
                int w = width * 3 / 4 - 3;
                int thickness2 = Math.max(height / 8, 2);
                int thickness = Math.max(width / 15, 1);
                if (this.part == TMSchema.Part.WP_CLOSEBUTTON) {
                    int lineWidth = width > 47 ? 6 : (width > 37 ? 5 : (width > 26 ? 4 : (width > 16 ? 3 : (width > 12 ? 2 : 1))));
                    y = height / 12 + 2;
                    if (lineWidth == 1) {
                        if (w % 2 == 1) {
                            ++x;
                            ++w;
                        }
                        g.drawLine(x, y, x + w - 2, y + w - 2);
                        g.drawLine(x + w - 2, y, x, y + w - 2);
                    } else if (lineWidth == 2) {
                        if (w > 6) {
                            ++x;
                            --w;
                        }
                        g.drawLine(x, y, x + w - 2, y + w - 2);
                        g.drawLine(x + w - 2, y, x, y + w - 2);
                        g.drawLine(x + 1, y, x + w - 1, y + w - 2);
                        g.drawLine(x + w - 1, y, x + 1, y + w - 2);
                    } else {
                        g.drawLine(x += 2, ++y, x + (w -= 2) - 1, y + w - 1);
                        g.drawLine(x + w - 1, y, x, y + w - 1);
                        g.drawLine(x + 1, y, x + w - 1, y + w - 2);
                        g.drawLine(x + w - 2, y, x, y + w - 2);
                        g.drawLine(x, y + 1, x + w - 2, y + w - 1);
                        g.drawLine(x + w - 1, y + 1, x + 1, y + w - 1);
                        for (int i = 4; i <= lineWidth; ++i) {
                            g.drawLine(x + i - 2, y, x + w - 1, y + w - i + 1);
                            g.drawLine(x, y + i - 2, x + w - i + 1, y + w - 1);
                            g.drawLine(x + w - i + 1, y, x, y + w - i + 1);
                            g.drawLine(x + w - 1, y + i - 2, x + i - 2, y + w - 1);
                        }
                    }
                } else if (this.part == TMSchema.Part.WP_MINBUTTON) {
                    g.fillRect(x, y + h - thickness2, w - w / 3, thickness2);
                } else if (this.part == TMSchema.Part.WP_MAXBUTTON) {
                    g.fillRect(x, y, w, thickness2);
                    g.fillRect(x, y, thickness, h);
                    g.fillRect(x + w - thickness, y, thickness, h);
                    g.fillRect(x, y + h - thickness, w, thickness);
                } else if (this.part == TMSchema.Part.WP_RESTOREBUTTON) {
                    g.fillRect(x + w / 3, y, w - w / 3, thickness2);
                    g.fillRect(x + w / 3, y, thickness, h / 3);
                    g.fillRect(x + w - thickness, y, thickness, h - h / 3);
                    g.fillRect(x + w - w / 3, y + h - h / 3 - thickness, w / 3, thickness);
                    g.fillRect(x, y + h / 3, w - w / 3, thickness2);
                    g.fillRect(x, y + h / 3, thickness, h - h / 3);
                    g.fillRect(x + w - w / 3 - thickness, y + h / 3, thickness, h - h / 3);
                    g.fillRect(x, y + h - thickness, w - w / 3, thickness);
                }
            }
        }

        @Override
        public int getIconWidth() {
            int width;
            if (XPStyle.getXP() != null) {
                width = UIManager.getInt("InternalFrame.titleButtonHeight") - 2;
                Dimension d = XPStyle.getPartSize(TMSchema.Part.WP_CLOSEBUTTON, TMSchema.State.NORMAL);
                if (d != null && d.width != 0 && d.height != 0) {
                    width = (int)((float)width * (float)d.width / (float)d.height);
                }
            } else {
                width = UIManager.getInt("InternalFrame.titleButtonWidth") - 2;
            }
            if (XPStyle.getXP() != null) {
                width -= 2;
            }
            return width;
        }

        @Override
        public int getIconHeight() {
            int height = UIManager.getInt("InternalFrame.titleButtonHeight") - 4;
            return height;
        }
    }
}

