/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;

class Comparators {
    private Comparators() {
        throw new AssertionError((Object)"no instances");
    }

    static final class NullComparator<T>
    implements Comparator<T>,
    Serializable {
        private static final long serialVersionUID = -7569533591570686392L;
        private final boolean nullFirst;
        private final Comparator<T> real;

        NullComparator(boolean nullFirst, Comparator<? super T> real) {
            this.nullFirst = nullFirst;
            this.real = real;
        }

        @Override
        public int compare(T a, T b) {
            if (a == null) {
                return b == null ? 0 : (this.nullFirst ? -1 : 1);
            }
            if (b == null) {
                return this.nullFirst ? 1 : -1;
            }
            return this.real == null ? 0 : this.real.compare(a, b);
        }

        @Override
        public Comparator<T> thenComparing(Comparator<? super T> other) {
            Objects.requireNonNull(other);
            return new NullComparator<T>(this.nullFirst, this.real == null ? other : this.real.thenComparing(other));
        }

        @Override
        public Comparator<T> reversed() {
            return new NullComparator<T>(!this.nullFirst, this.real == null ? null : this.real.reversed());
        }
    }

    static enum NaturalOrderComparator implements Comparator<Comparable<Object>>
    {
        INSTANCE;


        @Override
        public int compare(Comparable<Object> c1, Comparable<Object> c2) {
            return c1.compareTo(c2);
        }

        @Override
        public Comparator<Comparable<Object>> reversed() {
            return Comparator.reverseOrder();
        }
    }
}

