/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.spi;

import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.imageio.spi.DigraphNode;
import javax.imageio.spi.PartialOrderIterator;

class PartiallyOrderedSet
extends AbstractSet {
    private Map poNodes = new HashMap();
    private Set nodes = this.poNodes.keySet();

    @Override
    public int size() {
        return this.nodes.size();
    }

    @Override
    public boolean contains(Object o) {
        return this.nodes.contains(o);
    }

    @Override
    public Iterator iterator() {
        return new PartialOrderIterator(this.poNodes.values().iterator());
    }

    @Override
    public boolean add(Object o) {
        if (this.nodes.contains(o)) {
            return false;
        }
        DigraphNode node = new DigraphNode(o);
        this.poNodes.put(o, node);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        DigraphNode node = (DigraphNode)this.poNodes.get(o);
        if (node == null) {
            return false;
        }
        this.poNodes.remove(o);
        node.dispose();
        return true;
    }

    @Override
    public void clear() {
        this.poNodes.clear();
    }

    public boolean setOrdering(Object first, Object second) {
        DigraphNode firstPONode = (DigraphNode)this.poNodes.get(first);
        DigraphNode secondPONode = (DigraphNode)this.poNodes.get(second);
        secondPONode.removeEdge(firstPONode);
        return firstPONode.addEdge(secondPONode);
    }

    public boolean unsetOrdering(Object first, Object second) {
        DigraphNode secondPONode;
        DigraphNode firstPONode = (DigraphNode)this.poNodes.get(first);
        return firstPONode.removeEdge(secondPONode = (DigraphNode)this.poNodes.get(second)) || secondPONode.removeEdge(firstPONode);
    }

    public boolean hasOrdering(Object preferred, Object other) {
        DigraphNode preferredPONode = (DigraphNode)this.poNodes.get(preferred);
        DigraphNode otherPONode = (DigraphNode)this.poNodes.get(other);
        return preferredPONode.hasEdge(otherPONode);
    }
}

