/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Scanner;
import sun.awt.FontConfiguration;
import sun.awt.X11FontManager;
import sun.font.FontUtilities;
import sun.font.SunFontManager;
import sun.util.logging.PlatformLogger;

public class MFontConfiguration
extends FontConfiguration {
    private static FontConfiguration fontConfig = null;
    private static PlatformLogger logger;
    private static final String fontsDirPrefix = "$JRE_LIB_FONTS";
    private static HashMap encodingMap;

    public MFontConfiguration(SunFontManager fm) {
        super(fm);
        if (FontUtilities.debugFonts()) {
            logger = PlatformLogger.getLogger("sun.awt.FontConfiguration");
        }
        this.initTables();
    }

    public MFontConfiguration(SunFontManager fm, boolean preferLocaleFonts, boolean preferPropFonts) {
        super(fm, preferLocaleFonts, preferPropFonts);
        if (FontUtilities.debugFonts()) {
            logger = PlatformLogger.getLogger("sun.awt.FontConfiguration");
        }
        this.initTables();
    }

    @Override
    protected void initReorderMap() {
        this.reorderMap = new HashMap();
        if (osName == null) {
            this.initReorderMapForSolaris();
        } else {
            this.initReorderMapForLinux();
        }
    }

    private void initReorderMapForSolaris() {
        this.reorderMap.put("UTF-8.hi", "devanagari");
        this.reorderMap.put("UTF-8.ja", this.split("japanese-x0201,japanese-x0208,japanese-x0212"));
        this.reorderMap.put("UTF-8.ko", "korean-johab");
        this.reorderMap.put("UTF-8.th", "thai");
        this.reorderMap.put("UTF-8.zh.TW", "chinese-big5");
        this.reorderMap.put("UTF-8.zh.HK", this.split("chinese-big5,chinese-hkscs"));
        if (FontUtilities.isSolaris8) {
            this.reorderMap.put("UTF-8.zh.CN", this.split("chinese-gb2312,chinese-big5"));
        } else {
            this.reorderMap.put("UTF-8.zh.CN", this.split("chinese-gb18030-0,chinese-gb18030-1"));
        }
        this.reorderMap.put("UTF-8.zh", this.split("chinese-big5,chinese-hkscs,chinese-gb18030-0,chinese-gb18030-1"));
        this.reorderMap.put("Big5", "chinese-big5");
        this.reorderMap.put("Big5-HKSCS", this.split("chinese-big5,chinese-hkscs"));
        if (!FontUtilities.isSolaris8 && !FontUtilities.isSolaris9) {
            this.reorderMap.put("GB2312", this.split("chinese-gbk,chinese-gb2312"));
        } else {
            this.reorderMap.put("GB2312", "chinese-gb2312");
        }
        this.reorderMap.put("x-EUC-TW", this.split("chinese-cns11643-1,chinese-cns11643-2,chinese-cns11643-3"));
        this.reorderMap.put("GBK", "chinese-gbk");
        this.reorderMap.put("GB18030", this.split("chinese-gb18030-0,chinese-gb18030-1"));
        this.reorderMap.put("TIS-620", "thai");
        this.reorderMap.put("x-PCK", this.split("japanese-x0201,japanese-x0208,japanese-x0212"));
        this.reorderMap.put("x-eucJP-Open", this.split("japanese-x0201,japanese-x0208,japanese-x0212"));
        this.reorderMap.put("EUC-KR", "korean");
        this.reorderMap.put("ISO-8859-2", "latin-2");
        this.reorderMap.put("ISO-8859-5", "cyrillic-iso8859-5");
        this.reorderMap.put("windows-1251", "cyrillic-cp1251");
        this.reorderMap.put("KOI8-R", "cyrillic-koi8-r");
        this.reorderMap.put("ISO-8859-6", "arabic");
        this.reorderMap.put("ISO-8859-7", "greek");
        this.reorderMap.put("ISO-8859-8", "hebrew");
        this.reorderMap.put("ISO-8859-9", "latin-5");
        this.reorderMap.put("ISO-8859-13", "latin-7");
        this.reorderMap.put("ISO-8859-15", "latin-9");
    }

    private void initReorderMapForLinux() {
        this.reorderMap.put("UTF-8.ja.JP", "japanese-iso10646");
        this.reorderMap.put("UTF-8.ko.KR", "korean-iso10646");
        this.reorderMap.put("UTF-8.zh.TW", "chinese-tw-iso10646");
        this.reorderMap.put("UTF-8.zh.HK", "chinese-tw-iso10646");
        this.reorderMap.put("UTF-8.zh.CN", "chinese-cn-iso10646");
        this.reorderMap.put("x-euc-jp-linux", this.split("japanese-x0201,japanese-x0208"));
        this.reorderMap.put("GB2312", "chinese-gb18030");
        this.reorderMap.put("Big5", "chinese-big5");
        this.reorderMap.put("EUC-KR", "korean");
        if (osName.equals("Sun")) {
            this.reorderMap.put("GB18030", "chinese-cn-iso10646");
        } else {
            this.reorderMap.put("GB18030", "chinese-gb18030");
        }
    }

    @Override
    protected void setOsNameAndVersion() {
        super.setOsNameAndVersion();
        if (osName.equals("SunOS")) {
            osName = null;
        } else if (osName.equals("Linux")) {
            try {
                File f = new File("/etc/fedora-release");
                if (f.canRead()) {
                    osName = "Fedora";
                    osVersion = this.getVersionString(f);
                } else {
                    f = new File("/etc/redhat-release");
                    if (f.canRead()) {
                        osName = "RedHat";
                        osVersion = this.getVersionString(f);
                    } else {
                        f = new File("/etc/turbolinux-release");
                        if (f.canRead()) {
                            osName = "Turbo";
                            osVersion = this.getVersionString(f);
                        } else {
                            f = new File("/etc/SuSE-release");
                            if (f.canRead()) {
                                osName = "SuSE";
                                osVersion = this.getVersionString(f);
                            } else {
                                f = new File("/etc/lsb-release");
                                if (f.canRead()) {
                                    Properties props = new Properties();
                                    props.load(new FileInputStream(f));
                                    osName = props.getProperty("DISTRIB_ID");
                                    osVersion = props.getProperty("DISTRIB_RELEASE");
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String getVersionString(File f) {
        try {
            Scanner sc = new Scanner(f);
            return sc.findInLine("(\\d)+((\\.)(\\d)+)*");
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    protected String mapFileName(String fileName) {
        if (fileName != null && fileName.startsWith(fontsDirPrefix)) {
            return SunFontManager.jreFontDirName + fileName.substring(fontsDirPrefix.length());
        }
        return fileName;
    }

    @Override
    public String getFallbackFamilyName(String fontName, String defaultFallback) {
        String compatibilityName = this.getCompatibilityFamilyName(fontName);
        if (compatibilityName != null) {
            return compatibilityName;
        }
        return defaultFallback;
    }

    @Override
    protected String getEncoding(String awtFontName, String characterSubsetName) {
        String encoding;
        int beginIndex = 0;
        int fieldNum = 13;
        while (fieldNum-- > 0 && beginIndex >= 0) {
            beginIndex = awtFontName.indexOf("-", beginIndex) + 1;
        }
        if (beginIndex == -1) {
            return "default";
        }
        String xlfdEncoding = awtFontName.substring(beginIndex);
        if (xlfdEncoding.indexOf("fontspecific") > 0) {
            if (awtFontName.indexOf("dingbats") > 0) {
                return "sun.awt.motif.X11Dingbats";
            }
            if (awtFontName.indexOf("symbol") > 0) {
                return "sun.awt.Symbol";
            }
        }
        if ((encoding = (String)encodingMap.get(xlfdEncoding)) == null) {
            encoding = "default";
        }
        return encoding;
    }

    @Override
    protected Charset getDefaultFontCharset(String fontName) {
        return Charset.forName("ISO8859_1");
    }

    @Override
    protected String getFaceNameFromComponentFontName(String componentFontName) {
        return null;
    }

    @Override
    protected String getFileNameFromComponentFontName(String componentFontName) {
        String fileName = this.getFileNameFromPlatformName(componentFontName);
        if (fileName != null && fileName.charAt(0) == '/' && !this.needToSearchForFile(fileName)) {
            return fileName;
        }
        return ((X11FontManager)this.fontManager).getFileNameFromXLFD(componentFontName);
    }

    @Override
    public HashSet<String> getAWTFontPathSet() {
        HashSet<String> fontDirs = new HashSet<String>();
        short[] scripts = this.getCoreScripts(0);
        for (int i = 0; i < scripts.length; ++i) {
            String path = MFontConfiguration.getString(table_awtfontpaths[scripts[i]]);
            if (path == null) continue;
            int start = 0;
            int colon = path.indexOf(58);
            while (colon >= 0) {
                fontDirs.add(path.substring(start, colon));
                start = colon + 1;
                colon = path.indexOf(58, start);
            }
            fontDirs.add(start == 0 ? path : path.substring(start));
        }
        return fontDirs;
    }

    private void initTables() {
        encodingMap.put("iso8859-1", "ISO-8859-1");
        encodingMap.put("iso8859-2", "ISO-8859-2");
        encodingMap.put("iso8859-4", "ISO-8859-4");
        encodingMap.put("iso8859-5", "ISO-8859-5");
        encodingMap.put("iso8859-6", "ISO-8859-6");
        encodingMap.put("iso8859-7", "ISO-8859-7");
        encodingMap.put("iso8859-8", "ISO-8859-8");
        encodingMap.put("iso8859-9", "ISO-8859-9");
        encodingMap.put("iso8859-13", "ISO-8859-13");
        encodingMap.put("iso8859-15", "ISO-8859-15");
        encodingMap.put("gb2312.1980-0", "sun.awt.motif.X11GB2312");
        if (osName == null) {
            encodingMap.put("gbk-0", "GBK");
        } else {
            encodingMap.put("gbk-0", "sun.awt.motif.X11GBK");
        }
        encodingMap.put("gb18030.2000-0", "sun.awt.motif.X11GB18030_0");
        encodingMap.put("gb18030.2000-1", "sun.awt.motif.X11GB18030_1");
        encodingMap.put("cns11643-1", "sun.awt.motif.X11CNS11643P1");
        encodingMap.put("cns11643-2", "sun.awt.motif.X11CNS11643P2");
        encodingMap.put("cns11643-3", "sun.awt.motif.X11CNS11643P3");
        encodingMap.put("big5-1", "Big5");
        encodingMap.put("big5-0", "Big5");
        encodingMap.put("hkscs-1", "Big5-HKSCS");
        encodingMap.put("ansi-1251", "windows-1251");
        encodingMap.put("koi8-r", "KOI8-R");
        encodingMap.put("jisx0201.1976-0", "sun.awt.motif.X11JIS0201");
        encodingMap.put("jisx0208.1983-0", "sun.awt.motif.X11JIS0208");
        encodingMap.put("jisx0212.1990-0", "sun.awt.motif.X11JIS0212");
        encodingMap.put("ksc5601.1987-0", "sun.awt.motif.X11KSC5601");
        encodingMap.put("ksc5601.1992-3", "sun.awt.motif.X11Johab");
        encodingMap.put("tis620.2533-0", "TIS-620");
        encodingMap.put("iso10646-1", "UTF-16BE");
    }

    static {
        encodingMap = new HashMap();
    }
}

