/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import sun.awt.image.BufImgSurfaceData;
import sun.java2d.SurfaceData;
import sun.java2d.loops.Blit;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.XORComposite;

public class SunCompositeContext
implements CompositeContext {
    ColorModel srcCM;
    ColorModel dstCM;
    Composite composite;
    CompositeType comptype;

    public SunCompositeContext(AlphaComposite ac, ColorModel s, ColorModel d) {
        if (s == null) {
            throw new NullPointerException("Source color model cannot be null");
        }
        if (d == null) {
            throw new NullPointerException("Destination color model cannot be null");
        }
        this.srcCM = s;
        this.dstCM = d;
        this.composite = ac;
        this.comptype = CompositeType.forAlphaComposite(ac);
    }

    public SunCompositeContext(XORComposite xc, ColorModel s, ColorModel d) {
        if (s == null) {
            throw new NullPointerException("Source color model cannot be null");
        }
        if (d == null) {
            throw new NullPointerException("Destination color model cannot be null");
        }
        this.srcCM = s;
        this.dstCM = d;
        this.composite = xc;
        this.comptype = CompositeType.Xor;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void compose(Raster srcArg, Raster dstIn, WritableRaster dstOut) {
        WritableRaster src;
        if (dstIn != dstOut) {
            dstOut.setDataElements(0, 0, dstIn);
        }
        if (srcArg instanceof WritableRaster) {
            src = (WritableRaster)srcArg;
        } else {
            src = srcArg.createCompatibleWritableRaster();
            src.setDataElements(0, 0, srcArg);
        }
        int w = Math.min(src.getWidth(), dstIn.getWidth());
        int h = Math.min(src.getHeight(), dstIn.getHeight());
        BufferedImage srcImg = new BufferedImage(this.srcCM, src, this.srcCM.isAlphaPremultiplied(), null);
        BufferedImage dstImg = new BufferedImage(this.dstCM, dstOut, this.dstCM.isAlphaPremultiplied(), null);
        SurfaceData srcData = BufImgSurfaceData.createData(srcImg);
        SurfaceData dstData = BufImgSurfaceData.createData(dstImg);
        Blit blit = Blit.getFromCache(srcData.getSurfaceType(), this.comptype, dstData.getSurfaceType());
        blit.Blit(srcData, dstData, this.composite, null, 0, 0, 0, 0, w, h);
    }
}

