/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.proxy;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import sun.rmi.transport.proxy.CGIClientException;
import sun.rmi.transport.proxy.CGICommandHandler;
import sun.rmi.transport.proxy.CGIHandler;
import sun.rmi.transport.proxy.CGIServerException;

final class CGIForwardCommand
implements CGICommandHandler {
    CGIForwardCommand() {
    }

    @Override
    public String getName() {
        return "forward";
    }

    private String getLine(DataInputStream socketIn) throws IOException {
        return socketIn.readLine();
    }

    @Override
    public void execute(String param) throws CGIClientException, CGIServerException {
        String line;
        DataInputStream socketIn;
        Socket socket;
        int port;
        if (!CGIHandler.RequestMethod.equals("POST")) {
            throw new CGIClientException("can only forward POST requests");
        }
        try {
            port = Integer.parseInt(param);
        }
        catch (NumberFormatException e) {
            throw new CGIClientException("invalid port number.", e);
        }
        if (port <= 0 || port > 65535) {
            throw new CGIClientException("invalid port: " + port);
        }
        if (port < 1024) {
            throw new CGIClientException("permission denied for port: " + port);
        }
        try {
            socket = new Socket(InetAddress.getLocalHost(), port);
        }
        catch (IOException e) {
            throw new CGIServerException("could not connect to local port", e);
        }
        DataInputStream clientIn = new DataInputStream(System.in);
        byte[] buffer = new byte[CGIHandler.ContentLength];
        try {
            clientIn.readFully(buffer);
        }
        catch (EOFException e) {
            throw new CGIClientException("unexpected EOF reading request body", e);
        }
        catch (IOException e) {
            throw new CGIClientException("error reading request body", e);
        }
        try {
            DataOutputStream socketOut = new DataOutputStream(socket.getOutputStream());
            socketOut.writeBytes("POST / HTTP/1.0\r\n");
            socketOut.writeBytes("Content-length: " + CGIHandler.ContentLength + "\r\n\r\n");
            socketOut.write(buffer);
            socketOut.flush();
        }
        catch (IOException e) {
            throw new CGIServerException("error writing to server", e);
        }
        try {
            socketIn = new DataInputStream(socket.getInputStream());
        }
        catch (IOException e) {
            throw new CGIServerException("error reading from server", e);
        }
        String key = "Content-length:".toLowerCase();
        boolean contentLengthFound = false;
        int responseContentLength = -1;
        do {
            try {
                line = this.getLine(socketIn);
            }
            catch (IOException e) {
                throw new CGIServerException("error reading from server", e);
            }
            if (line == null) {
                throw new CGIServerException("unexpected EOF reading server response");
            }
            if (!line.toLowerCase().startsWith(key)) continue;
            if (contentLengthFound) {
                throw new CGIServerException("Multiple Content-length entries found.");
            }
            responseContentLength = Integer.parseInt(line.substring(key.length()).trim());
            contentLengthFound = true;
        } while (line.length() != 0 && line.charAt(0) != '\r' && line.charAt(0) != '\n');
        if (!contentLengthFound || responseContentLength < 0) {
            throw new CGIServerException("missing or invalid content length in server response");
        }
        buffer = new byte[responseContentLength];
        try {
            socketIn.readFully(buffer);
        }
        catch (EOFException e) {
            throw new CGIServerException("unexpected EOF reading server response", e);
        }
        catch (IOException e) {
            throw new CGIServerException("error reading from server", e);
        }
        System.out.println("Status: 200 OK");
        System.out.println("Content-type: application/octet-stream");
        System.out.println("");
        try {
            System.out.write(buffer);
        }
        catch (IOException e) {
            throw new CGIServerException("error writing response", e);
        }
        System.out.flush();
    }
}

