/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.core.relayd;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.ILttngRelaydConnector;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.Command;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.ConnectResponse;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.ConnectionType;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.ViewerCommand;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.impl.LttngRelaydConnector_2_4;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.impl.LttngRelaydConnector_Unsupported;

public final class LttngRelaydConnectorFactory {
    private LttngRelaydConnectorFactory() {
    }

    public static ILttngRelaydConnector getNewConnector(Socket myConnection) throws IOException {
        DataOutputStream outNet = new DataOutputStream(myConnection.getOutputStream());
        DataInputStream inNet = new DataInputStream(myConnection.getInputStream());
        ViewerCommand connectCommand = new ViewerCommand(Command.VIEWER_CONNECT, 20L, 0);
        outNet.write(connectCommand.serialize());
        outNet.flush();
        ConnectResponse payload = new ConnectResponse(0L, 2, 4, ConnectionType.VIEWER_CLIENT_COMMAND);
        outNet.write(payload.serialize());
        outNet.flush();
        ConnectResponse connectReply = new ConnectResponse(inNet);
        switch (connectReply.getMajor()) {
            case 2: {
                switch (connectReply.getMinor()) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        return new LttngRelaydConnector_Unsupported();
                    }
                }
                return new LttngRelaydConnector_2_4(inNet, outNet);
            }
        }
        return new LttngRelaydConnector_Unsupported();
    }
}

