/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.cachegrind;

import java.text.DecimalFormat;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.linuxtools.internal.valgrind.cachegrind.Messages;
import org.eclipse.linuxtools.internal.valgrind.cachegrind.model.CachegrindFile;
import org.eclipse.linuxtools.internal.valgrind.cachegrind.model.CachegrindFunction;
import org.eclipse.linuxtools.internal.valgrind.cachegrind.model.CachegrindLine;
import org.eclipse.linuxtools.internal.valgrind.cachegrind.model.CachegrindOutput;
import org.eclipse.linuxtools.internal.valgrind.cachegrind.model.ICachegrindElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CachegrindLabelProvider
extends CellLabelProvider {
    private static final String NAME_NOT_FOUND_SYMBOL = "???";
    protected CElementLabelProvider cLabelProvider = new CElementLabelProvider(259){

        public int getTextFlags() {
            return super.getTextFlags() | 0x20;
        }
    };
    protected DecimalFormat df = new DecimalFormat("#,##0");
    private static final Image FUNC_IMG = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.linuxtools.valgrind.cachegrind", (String)"icons/function_obj.gif").createImage();

    public void update(ViewerCell cell) {
        ICachegrindElement element = (ICachegrindElement)cell.getElement();
        int index = cell.getColumnIndex();
        if (index == 0) {
            if (element instanceof CachegrindFile) {
                IAdaptable model = ((CachegrindFile)element).getModel();
                if (model != null) {
                    cell.setText(this.cLabelProvider.getText((Object)model));
                    cell.setImage(this.cLabelProvider.getImage((Object)model));
                } else {
                    String name = ((CachegrindFile)element).getName();
                    cell.setText(name);
                    cell.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE"));
                }
            } else if (element instanceof CachegrindFunction) {
                IAdaptable model = ((CachegrindFunction)element).getModel();
                if (model != null) {
                    cell.setText(this.cLabelProvider.getText((Object)model));
                    cell.setImage(this.cLabelProvider.getImage((Object)model));
                } else {
                    String name = ((CachegrindFunction)element).getName();
                    cell.setText(name);
                    cell.setImage(FUNC_IMG);
                }
            } else if (element instanceof CachegrindLine) {
                cell.setText(NLS.bind((String)Messages.getString("CachegrindViewPart.line"), (Object)((CachegrindLine)element).getLine()));
                cell.setImage(DebugUITools.getImage((String)"IMG_OBJS_INSTRUCTION_POINTER_TOP"));
            } else if (element instanceof CachegrindOutput) {
                cell.setText(NLS.bind((String)Messages.getString("CachegrindViewPart.Total_PID"), (Object)((CachegrindOutput)element).getPid()));
                cell.setImage(DebugUITools.getImage((String)"IMG_OBJS_REGISTER"));
            }
        } else if (element instanceof CachegrindFunction) {
            cell.setText(this.df.format(((CachegrindFunction)element).getTotals()[index - 1]));
        } else if (element instanceof CachegrindLine) {
            cell.setText(this.df.format(((CachegrindLine)element).getValues()[index - 1]));
        } else if (element instanceof CachegrindOutput) {
            cell.setText(this.df.format(((CachegrindOutput)element).getSummary()[index - 1]));
        }
    }

    public CElementLabelProvider getCLabelProvider() {
        return this.cLabelProvider;
    }

    public String getToolTipText(Object element) {
        String tooltip = null;
        if (element instanceof CachegrindFile && ((CachegrindFile)element).getName().contains(NAME_NOT_FOUND_SYMBOL)) {
            tooltip = Messages.getString("CachegrindViewPart.Tooltip_no_debug_info");
        }
        if (element instanceof CachegrindFunction && ((CachegrindFunction)element).getName().contains(NAME_NOT_FOUND_SYMBOL)) {
            tooltip = Messages.getString("CachegrindViewPart.Tooltip_no_debug_info");
        }
        return tooltip;
    }
}

